/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.assignment.TaskTopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskTopicPartition
implements TaskTopicPartition {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTaskTopicPartition.class);
    private final TopicPartition topicPartition;
    private final boolean isSourceTopic;
    private final boolean isChangelogTopic;
    private final Runnable rackIdInformationFetcher;
    private Optional<Set<String>> rackIds;

    public DefaultTaskTopicPartition(TopicPartition topicPartition, boolean isSourceTopic, boolean isChangelogTopic, Runnable rackIdInformationFetcher) {
        this.topicPartition = topicPartition;
        this.isSourceTopic = isSourceTopic;
        this.isChangelogTopic = isChangelogTopic;
        this.rackIdInformationFetcher = rackIdInformationFetcher;
        this.rackIds = Optional.empty();
    }

    @Override
    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public boolean isSource() {
        return this.isSourceTopic;
    }

    @Override
    public boolean isChangelog() {
        return this.isChangelogTopic;
    }

    @Override
    public Optional<Set<String>> rackIds() {
        this.rackIdInformationFetcher.run();
        return this.rackIds;
    }

    public int hashCode() {
        int result = this.topicPartition.hashCode();
        result = 31 * result + Objects.hashCode(this.isSourceTopic);
        result = 31 * result + Objects.hashCode(this.isChangelogTopic);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskTopicPartition other = (TaskTopicPartition)obj;
        return this.topicPartition.equals(other.topicPartition()) && this.isSourceTopic == other.isSource() && this.isChangelogTopic == other.isChangelog();
    }

    public void annotateWithRackIds(Set<String> rackIds) {
        this.rackIds = Optional.of(rackIds);
    }
}

