/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionGrouper {
    private static final Logger log = LoggerFactory.getLogger(PartitionGrouper.class);

    public Map<TaskId, Set<TopicPartition>> partitionGroups(Map<TopologyMetadata.Subtopology, Set<String>> topicGroups, Cluster metadata) {
        return this.partitionGroups(topicGroups, new HashMap<TopologyMetadata.Subtopology, Set<String>>(), new HashMap<TaskId, Set<TopicPartition>>(), metadata);
    }

    public Map<TaskId, Set<TopicPartition>> partitionGroups(Map<TopologyMetadata.Subtopology, Set<String>> sourceTopicGroups, Map<TopologyMetadata.Subtopology, Set<String>> changelogTopicGroups, Map<TaskId, Set<TopicPartition>> changelogPartitionGroups, Cluster metadata) {
        HashMap sourcePartitionGroups = new HashMap();
        for (Map.Entry<TopologyMetadata.Subtopology, Set<String>> entry : sourceTopicGroups.entrySet()) {
            TopologyMetadata.Subtopology subtopology = entry.getKey();
            Set<String> sourceTopicGroup = entry.getValue();
            Set changelogTopicGroup = changelogTopicGroups.getOrDefault(subtopology, new HashSet());
            int maxNumPartitions = this.maxNumPartitions(metadata, sourceTopicGroup);
            for (int partitionId = 0; partitionId < maxNumPartitions; ++partitionId) {
                HashSet<TopicPartition> sourcePartitionGroup = new HashSet<TopicPartition>(sourceTopicGroup.size());
                HashSet<TopicPartition> changelogPartitionGroup = new HashSet<TopicPartition>(changelogTopicGroup.size());
                for (String topic : sourceTopicGroup) {
                    List<PartitionInfo> partitions = metadata.partitionsForTopic(topic);
                    if (partitionId >= partitions.size()) continue;
                    sourcePartitionGroup.add(new TopicPartition(topic, partitionId));
                }
                for (String topic : changelogTopicGroup) {
                    changelogPartitionGroup.add(new TopicPartition(topic, partitionId));
                }
                TaskId taskId = new TaskId(subtopology.nodeGroupId, partitionId, subtopology.namedTopology);
                sourcePartitionGroups.put(taskId, Collections.unmodifiableSet(sourcePartitionGroup));
                changelogPartitionGroups.put(taskId, Collections.unmodifiableSet(changelogPartitionGroup));
            }
        }
        return Collections.unmodifiableMap(sourcePartitionGroups);
    }

    protected int maxNumPartitions(Cluster metadata, Set<String> topics) {
        int maxNumPartitions = 0;
        for (String topic : topics) {
            List<PartitionInfo> partitions = metadata.partitionsForTopic(topic);
            if (partitions.isEmpty()) {
                log.error("Empty partitions for topic {}", (Object)topic);
                throw new RuntimeException("Empty partitions for topic " + topic);
            }
            int numPartitions = partitions.size();
            if (numPartitions <= maxNumPartitions) continue;
            maxNumPartitions = numPartitions;
        }
        return maxNumPartitions;
    }
}

