/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.internals.Topic;

public abstract class InternalTopicConfig {
    final String name;
    final Map<String, String> topicConfigs;
    final boolean enforceNumberOfPartitions;
    private Optional<Integer> numberOfPartitions = Optional.empty();
    static final Map<String, String> INTERNAL_TOPIC_DEFAULT_OVERRIDES = new HashMap<String, String>();

    InternalTopicConfig(String name, Map<String, String> topicConfigs) {
        this.name = Objects.requireNonNull(name, "name can't be null");
        Topic.validate(name);
        this.topicConfigs = Objects.requireNonNull(topicConfigs, "topicConfigs can't be null");
        this.enforceNumberOfPartitions = false;
    }

    InternalTopicConfig(String name, Map<String, String> topicConfigs, int numberOfPartitions, boolean enforceNumberOfPartitions) {
        this.name = Objects.requireNonNull(name, "name can't be null");
        Topic.validate(name);
        InternalTopicConfig.validateNumberOfPartitions(numberOfPartitions);
        this.topicConfigs = Objects.requireNonNull(topicConfigs, "topicConfigs can't be null");
        this.numberOfPartitions = Optional.of(numberOfPartitions);
        this.enforceNumberOfPartitions = enforceNumberOfPartitions;
    }

    public abstract Map<String, String> properties(Map<String, String> var1, long var2);

    public boolean hasEnforcedNumberOfPartitions() {
        return this.enforceNumberOfPartitions;
    }

    public String name() {
        return this.name;
    }

    public Optional<Integer> numberOfPartitions() {
        return this.numberOfPartitions;
    }

    public void setNumberOfPartitions(int numberOfPartitions) {
        if (this.hasEnforcedNumberOfPartitions()) {
            throw new UnsupportedOperationException("number of partitions are enforced on topic " + this.name() + " and can't be altered.");
        }
        InternalTopicConfig.validateNumberOfPartitions(numberOfPartitions);
        this.numberOfPartitions = Optional.of(numberOfPartitions);
    }

    private static void validateNumberOfPartitions(int numberOfPartitions) {
        if (numberOfPartitions < 1) {
            throw new IllegalArgumentException("Number of partitions must be at least 1.");
        }
    }

    public String toString() {
        return "InternalTopicConfig(name=" + this.name + ", topicConfigs=" + String.valueOf(this.topicConfigs) + ", enforceNumberOfPartitions=" + this.enforceNumberOfPartitions + ")";
    }

    static {
        INTERNAL_TOPIC_DEFAULT_OVERRIDES.put("message.timestamp.type", "CreateTime");
    }
}

