/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceData;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.slf4j.Logger;

public class DefaultStreamsRebalanceListener
implements StreamsRebalanceListener {
    private final Logger log;
    private final Time time;
    private final StreamsRebalanceData streamsRebalanceData;
    private final TaskManager taskManager;
    private final StreamThread streamThread;

    public DefaultStreamsRebalanceListener(Logger log, Time time, StreamsRebalanceData streamsRebalanceData, StreamThread streamThread, TaskManager taskManager) {
        this.log = log;
        this.time = time;
        this.streamsRebalanceData = streamsRebalanceData;
        this.streamThread = streamThread;
        this.taskManager = taskManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTasksRevoked(Set<StreamsRebalanceData.TaskId> tasks) {
        Map<TaskId, Set<TopicPartition>> activeTasksToRevokeWithPartitions = this.pairWithTopicPartitions(tasks.stream());
        Set<TopicPartition> partitionsToRevoke = activeTasksToRevokeWithPartitions.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        long start = this.time.milliseconds();
        try {
            this.log.info("Revoking active tasks {}.", tasks);
            this.taskManager.handleRevocation(partitionsToRevoke);
        }
        finally {
            this.log.info("partition revocation took {} ms.", (Object)(this.time.milliseconds() - start));
        }
        if (this.streamThread.state() != StreamThread.State.PENDING_SHUTDOWN) {
            this.streamThread.setState(StreamThread.State.PARTITIONS_REVOKED);
        }
    }

    @Override
    public void onTasksAssigned(StreamsRebalanceData.Assignment assignment) {
        Map<TaskId, Set<TopicPartition>> activeTasksWithPartitions = this.pairWithTopicPartitions(assignment.activeTasks().stream());
        Map<TaskId, Set<TopicPartition>> standbyTasksWithPartitions = this.pairWithTopicPartitions(Stream.concat(assignment.standbyTasks().stream(), assignment.warmupTasks().stream()));
        this.log.info("Processing new assignment {} from Streams Rebalance Protocol", (Object)assignment);
        this.taskManager.handleAssignment(activeTasksWithPartitions, standbyTasksWithPartitions);
        this.streamThread.setState(StreamThread.State.PARTITIONS_ASSIGNED);
        this.taskManager.handleRebalanceComplete();
        this.streamsRebalanceData.setReconciledAssignment(assignment);
    }

    @Override
    public void onAllTasksLost() {
        this.taskManager.handleLostAll();
        this.streamsRebalanceData.setReconciledAssignment(StreamsRebalanceData.Assignment.EMPTY);
    }

    private Map<TaskId, Set<TopicPartition>> pairWithTopicPartitions(Stream<StreamsRebalanceData.TaskId> taskIdStream) {
        return taskIdStream.collect(Collectors.toMap(this::toTaskId, task -> this.toTopicPartitions((StreamsRebalanceData.TaskId)task, this.streamsRebalanceData.subtopologies().get(task.subtopologyId()))));
    }

    private TaskId toTaskId(StreamsRebalanceData.TaskId task) {
        return new TaskId(Integer.parseInt(task.subtopologyId()), task.partitionId());
    }

    private Set<TopicPartition> toTopicPartitions(StreamsRebalanceData.TaskId task, StreamsRebalanceData.Subtopology subTopology) {
        return Stream.concat(subTopology.sourceTopics().stream(), subTopology.repartitionSourceTopics().keySet().stream()).map(t -> new TopicPartition((String)t, task.partitionId())).collect(Collectors.toSet());
    }
}

