/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.StreamsProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUtils.class);

    public static String adminClientId(String clientId) {
        return clientId + "-admin";
    }

    public static String consumerClientId(String threadClientId) {
        return threadClientId + "-consumer";
    }

    public static String restoreConsumerClientId(String threadClientId) {
        return threadClientId + "-restore-consumer";
    }

    public static String producerClientId(String threadClientId) {
        return threadClientId + "-producer";
    }

    public static Map<MetricName, Metric> consumerMetrics(Consumer<byte[], byte[]> mainConsumer, Consumer<byte[], byte[]> restoreConsumer) {
        Map<MetricName, Metric> consumerMetrics = mainConsumer.metrics();
        Map<MetricName, Metric> restoreConsumerMetrics = restoreConsumer.metrics();
        LinkedHashMap<MetricName, Metric> result = new LinkedHashMap<MetricName, Metric>();
        result.putAll(consumerMetrics);
        result.putAll(restoreConsumerMetrics);
        return result;
    }

    public static Map<MetricName, Metric> adminClientMetrics(Admin adminClient) {
        Map<MetricName, ? extends Metric> adminClientMetrics = adminClient.metrics();
        return new LinkedHashMap<MetricName, Metric>(adminClientMetrics);
    }

    public static Map<MetricName, Metric> producerMetrics(Collection<StreamsProducer> producers) {
        LinkedHashMap<MetricName, Metric> result = new LinkedHashMap<MetricName, Metric>();
        for (StreamsProducer producer : producers) {
            Map<MetricName, ? extends Metric> producerMetrics = producer.metrics();
            if (producerMetrics == null) continue;
            result.putAll(producerMetrics);
        }
        return result;
    }

    public static Map<TopicPartition, Long> fetchCommittedOffsets(Set<TopicPartition> partitions, Consumer<byte[], byte[]> consumer) {
        Map<TopicPartition, Long> committedOffsets;
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            committedOffsets = consumer.committed(partitions).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() == null ? 0L : ((OffsetAndMetadata)e.getValue()).offset()));
        }
        catch (TimeoutException timeoutException) {
            LOG.warn("The committed offsets request timed out, try increasing the consumer client's default.api.timeout.ms", (Throwable)timeoutException);
            throw timeoutException;
        }
        catch (KafkaException fatal) {
            LOG.warn("The committed offsets request failed.", (Throwable)fatal);
            throw new StreamsException(String.format("Failed to retrieve end offsets for %s", partitions), fatal);
        }
        return committedOffsets;
    }

    public static KafkaFuture<Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>> fetchEndOffsetsFuture(Collection<TopicPartition> partitions, Admin adminClient) {
        return adminClient.listOffsets(partitions.stream().collect(Collectors.toMap(Function.identity(), tp -> OffsetSpec.latest()))).all();
    }

    public static ListOffsetsResult fetchEndOffsetsResult(Collection<TopicPartition> partitions, Admin adminClient) {
        return adminClient.listOffsets(partitions.stream().collect(Collectors.toMap(Function.identity(), tp -> OffsetSpec.latest())));
    }

    public static Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> getEndOffsets(ListOffsetsResult resultFuture, Collection<TopicPartition> partitions) {
        HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> result = new HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>();
        for (TopicPartition partition : partitions) {
            try {
                KafkaFuture<ListOffsetsResult.ListOffsetsResultInfo> future = resultFuture.partitionResult(partition);
                if (future == null) {
                    throw new IllegalStateException("Could not get end offset for " + String.valueOf(partition));
                }
                result.put(partition, future.get());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                String msg = String.format("Error while attempting to read end offsets for partition '%s'", partition.toString());
                throw new StreamsException(msg, cause);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                String msg = String.format("Interrupted while attempting to read end offsets for partition '%s'", partition.toString());
                throw new StreamsException(msg, e);
            }
        }
        return result;
    }

    public static Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> getEndOffsets(KafkaFuture<Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>> endOffsetsFuture) {
        try {
            return endOffsetsFuture.get();
        }
        catch (InterruptedException | RuntimeException | ExecutionException e) {
            LOG.warn("The listOffsets request failed.", (Throwable)e);
            throw new StreamsException("Unable to obtain end offsets from kafka", e);
        }
    }

    public static Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> fetchEndOffsets(Collection<TopicPartition> partitions, Admin adminClient) {
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        return ClientUtils.getEndOffsets(ClientUtils.fetchEndOffsetsFuture(partitions, adminClient));
    }

    public static long producerRecordSizeInBytes(ProducerRecord<byte[], byte[]> record) {
        return ClientUtils.recordSizeInBytes(record.key() == null ? 0L : (long)record.key().length, record.value() == null ? 0L : (long)record.value().length, record.topic(), record.headers());
    }

    public static long consumerRecordSizeInBytes(ConsumerRecord<byte[], byte[]> record) {
        return ClientUtils.recordSizeInBytes(record.serializedKeySize(), record.serializedValueSize(), record.topic(), record.headers());
    }

    private static long recordSizeInBytes(long keyBytes, long valueBytes, String topic, Headers headers) {
        long headerSizeInBytes = 0L;
        if (headers != null) {
            for (Header header : headers.toArray()) {
                headerSizeInBytes += (long)Utils.utf8(header.key()).length;
                if (header.value() == null) continue;
                headerSizeInBytes += (long)header.value().length;
            }
        }
        return keyBytes + valueBytes + 8L + 8L + (long)Utils.utf8(topic).length + 4L + headerSizeInBytes;
    }

    public static final class QuietConsumerConfig
    extends ConsumerConfig {
        public QuietConsumerConfig(Map<String, Object> props) {
            super(props, false);
        }
    }

    public static final class QuietStreamsConfig
    extends StreamsConfig {
        public QuietStreamsConfig(Map<?, ?> props) {
            super(props, false);
        }
    }
}

