/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKey;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKeySchema;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionResponseWrapper;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignTableJoinProcessorSupplier<KLeft, KRight, VRight>
implements ProcessorSupplier<KRight, Change<VRight>, KLeft, SubscriptionResponseWrapper<VRight>> {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignTableJoinProcessorSupplier.class);
    private final StoreFactory subscriptionStoreFactory;
    private final CombinedKeySchema<KRight, KLeft> keySchema;
    private boolean useVersionedSemantics = false;

    public ForeignTableJoinProcessorSupplier(StoreFactory subscriptionStoreFactory, CombinedKeySchema<KRight, KLeft> keySchema) {
        this.subscriptionStoreFactory = subscriptionStoreFactory;
        this.keySchema = keySchema;
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return Collections.singleton(new StoreFactory.FactoryWrappingStoreBuilder(this.subscriptionStoreFactory));
    }

    @Override
    public Processor<KRight, Change<VRight>, KLeft, SubscriptionResponseWrapper<VRight>> get() {
        return new KTableKTableJoinProcessor();
    }

    public void setUseVersionedSemantics(boolean useVersionedSemantics) {
        this.useVersionedSemantics = useVersionedSemantics;
    }

    public boolean isUseVersionedSemantics() {
        return this.useVersionedSemantics;
    }

    private final class KTableKTableJoinProcessor
    extends ContextualProcessor<KRight, Change<VRight>, KLeft, SubscriptionResponseWrapper<VRight>> {
        private Sensor droppedRecordsSensor;
        private TimestampedKeyValueStore<Bytes, SubscriptionWrapper<KLeft>> subscriptionStore;

        private KTableKTableJoinProcessor() {
        }

        @Override
        public void init(ProcessorContext<KLeft, SubscriptionResponseWrapper<VRight>> context) {
            super.init(context);
            InternalProcessorContext internalProcessorContext = (InternalProcessorContext)context;
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), internalProcessorContext.taskId().toString(), internalProcessorContext.metrics());
            this.subscriptionStore = (TimestampedKeyValueStore)internalProcessorContext.getStateStore(ForeignTableJoinProcessorSupplier.this.subscriptionStoreFactory.storeName());
        }

        @Override
        public void process(Record<KRight, Change<VRight>> record) {
            if (record.key() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    LOG.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    LOG.warn("Skipping record due to null key. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            if (ForeignTableJoinProcessorSupplier.this.useVersionedSemantics && !record.value().isLatest) {
                LOG.info("Skipping out-of-order record from versioned table while performing table-table join.");
                this.droppedRecordsSensor.record();
                return;
            }
            Bytes prefixBytes = ForeignTableJoinProcessorSupplier.this.keySchema.prefixBytes(record.key());
            try (KeyValueIterator prefixScanResults = this.subscriptionStore.range(prefixBytes, Bytes.increment(prefixBytes));){
                while (prefixScanResults.hasNext()) {
                    KeyValue next = (KeyValue)prefixScanResults.next();
                    if (!this.prefixEquals(((Bytes)next.key).get(), prefixBytes.get())) continue;
                    CombinedKey combinedKey = ForeignTableJoinProcessorSupplier.this.keySchema.fromBytes((Bytes)next.key);
                    this.context().forward(record.withKey(combinedKey.primaryKey()).withValue(new SubscriptionResponseWrapper(((SubscriptionWrapper)((ValueAndTimestamp)next.value).value()).hash(), record.value().newValue, ((SubscriptionWrapper)((ValueAndTimestamp)next.value).value()).primaryPartition())));
                }
            }
        }

        private boolean prefixEquals(byte[] x, byte[] y) {
            int min = Math.min(x.length, y.length);
            ByteBuffer xSlice = ByteBuffer.wrap(x, 0, min);
            ByteBuffer ySlice = ByteBuffer.wrap(y, 0, min);
            return xSlice.equals(ySlice);
        }
    }
}

