/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.CloseOptions;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.SubscriptionPattern;
import org.apache.kafka.clients.consumer.internals.AsyncKafkaConsumer;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceData;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceListener;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.KafkaMetric;

public abstract class ConsumerWrapper
implements Consumer<byte[], byte[]> {
    protected AsyncKafkaConsumer<byte[], byte[]> delegate;

    public void wrapConsumer(AsyncKafkaConsumer<byte[], byte[]> delegate, Map<String, Object> config, Optional<StreamsRebalanceData> streamsRebalanceData) {
        this.delegate = delegate;
    }

    @Override
    public Set<TopicPartition> assignment() {
        return this.delegate.assignment();
    }

    @Override
    public Set<String> subscription() {
        return this.delegate.subscription();
    }

    @Override
    public void subscribe(Collection<String> topics) {
        this.delegate.subscribe(topics);
    }

    @Override
    public void subscribe(Collection<String> topics, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(topics, callback);
    }

    public void subscribe(Collection<String> topics, StreamsRebalanceListener streamsRebalanceListener) {
        this.delegate.subscribe(topics, streamsRebalanceListener);
    }

    @Override
    public void assign(Collection<TopicPartition> partitions) {
        this.delegate.assign(partitions);
    }

    @Override
    public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(pattern, callback);
    }

    @Override
    public void subscribe(Pattern pattern) {
        this.delegate.subscribe(pattern);
    }

    @Override
    public void subscribe(SubscriptionPattern pattern, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(pattern, callback);
    }

    @Override
    public void subscribe(SubscriptionPattern pattern) {
        this.delegate.subscribe(pattern);
    }

    @Override
    public void unsubscribe() {
        this.delegate.unsubscribe();
    }

    @Override
    public ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
        return this.delegate.poll(timeout);
    }

    @Override
    public void commitSync() {
        this.delegate.commitSync();
    }

    @Override
    public void commitSync(Duration timeout) {
        this.delegate.commitSync(timeout);
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.delegate.commitSync(offsets);
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.delegate.commitSync(offsets, timeout);
    }

    @Override
    public void commitAsync() {
        this.delegate.commitAsync();
    }

    @Override
    public void commitAsync(OffsetCommitCallback callback) {
        this.delegate.commitAsync(callback);
    }

    @Override
    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.delegate.commitAsync(offsets, callback);
    }

    @Override
    public void registerMetricForSubscription(KafkaMetric metric) {
        this.delegate.registerMetricForSubscription(metric);
    }

    @Override
    public void unregisterMetricFromSubscription(KafkaMetric metric) {
        this.delegate.unregisterMetricFromSubscription(metric);
    }

    @Override
    public void seek(TopicPartition partition, long offset) {
        this.delegate.seek(partition, offset);
    }

    @Override
    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        this.delegate.seek(partition, offsetAndMetadata);
    }

    @Override
    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.delegate.seekToBeginning(partitions);
    }

    @Override
    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.delegate.seekToEnd(partitions);
    }

    @Override
    public long position(TopicPartition partition) {
        return this.delegate.position(partition);
    }

    @Override
    public long position(TopicPartition partition, Duration timeout) {
        return this.delegate.position(partition, timeout);
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return this.delegate.committed(partitions);
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        return this.delegate.committed(partitions, timeout);
    }

    @Override
    public Uuid clientInstanceId(Duration timeout) {
        return this.delegate.clientInstanceId(timeout);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        return this.delegate.partitionsFor(topic, timeout);
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics() {
        return this.delegate.listTopics();
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        return this.delegate.listTopics(timeout);
    }

    @Override
    public Set<TopicPartition> paused() {
        return this.delegate.paused();
    }

    @Override
    public void pause(Collection<TopicPartition> partitions) {
        this.delegate.pause(partitions);
    }

    @Override
    public void resume(Collection<TopicPartition> partitions) {
        this.delegate.resume(partitions);
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.delegate.offsetsForTimes(timestampsToSearch);
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        return this.delegate.offsetsForTimes(timestampsToSearch, timeout);
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.beginningOffsets(partitions);
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.delegate.beginningOffsets(partitions, timeout);
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.endOffsets(partitions);
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.delegate.endOffsets(partitions, timeout);
    }

    @Override
    public OptionalLong currentLag(TopicPartition topicPartition) {
        return this.delegate.currentLag(topicPartition);
    }

    @Override
    public ConsumerGroupMetadata groupMetadata() {
        return this.delegate.groupMetadata();
    }

    @Override
    public void enforceRebalance() {
        this.delegate.enforceRebalance();
    }

    @Override
    public void enforceRebalance(String reason) {
        this.delegate.enforceRebalance(reason);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    @Deprecated
    public void close(Duration timeout) {
        this.delegate.close(timeout);
    }

    @Override
    public void close(CloseOptions option) {
        this.delegate.close(option);
    }

    @Override
    public void wakeup() {
        this.delegate.wakeup();
    }
}

