/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.ProcessingExceptionHandler;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.NoOpProcessorWrapper;
import org.apache.kafka.streams.state.DslStoreSuppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TopologyConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG = new ConfigDef().define("processor.wrapper.class", ConfigDef.Type.CLASS, NoOpProcessorWrapper.class.getName(), ConfigDef.Importance.LOW, "A processor wrapper class or class name that implements the <code>org.apache.kafka.streams.state.ProcessorWrapper</code> interface. Must be passed in to the StreamsBuilder or Topology constructor in order to take effect").define("buffered.records.per.partition", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "Maximum number of records to buffer per partition.").define("cache.max.bytes.buffering", ConfigDef.Type.LONG, null, ConfigDef.Importance.MEDIUM, "Maximum number of memory bytes to be used for buffering across all threads").define("statestore.cache.max.bytes", ConfigDef.Type.LONG, null, ConfigDef.Importance.MEDIUM, "Maximum number of memory bytes to be used for statestore cache across all threads").define("default.deserialization.exception.handler", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "Exception handling class that implements the <code>org.apache.kafka.streams.errors.DeserializationExceptionHandler</code> interface.").define("default.timestamp.extractor", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "Default timestamp extractor class that implements the <code>org.apache.kafka.streams.processor.TimestampExtractor</code> interface.").define("deserialization.exception.handler", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "Exception handling class that implements the <code>org.apache.kafka.streams.errors.DeserializationExceptionHandler</code> interface.").define("max.task.idle.ms", ConfigDef.Type.LONG, null, ConfigDef.Importance.MEDIUM, "This config controls whether joins and merges may produce out-of-order results. The config value is the maximum amount of time in milliseconds a stream task will stay idle when it is fully caught up on some (but not all) input partitions to wait for producers to send additional records and avoid potential out-of-order record processing across multiple input streams. The default (zero) does not wait for producers to send more records, but it does wait to fetch data that is already present on the brokers. This default means that for records that are already present on the brokers, Streams will process them in timestamp order. Set to -1 to disable idling entirely and process any locally available data, even though doing so may produce out-of-order processing.").define("task.timeout.ms", ConfigDef.Type.LONG, null, ConfigDef.Importance.MEDIUM, "The maximum amount of time in milliseconds a task might stall due to internal errors and retries until an error is raised. For a timeout of 0ms, a task would raise an error for the first internal error. For any timeout larger than 0ms, a task will retry at least once before an error is raised.").define("default.dsl.store", ConfigDef.Type.STRING, (Object)"rocksDB", ConfigDef.ValidString.in("rocksDB", "in_memory"), ConfigDef.Importance.LOW, "The default state store type used by DSL operators.").define("dsl.store.suppliers.class", ConfigDef.Type.CLASS, StreamsConfig.DSL_STORE_SUPPLIERS_CLASS_DEFAULT, ConfigDef.Importance.LOW, "Defines which store implementations to plug in to DSL operators. Must implement the <code>org.apache.kafka.streams.state.DslStoreSuppliers</code> interface.").define("ensure.explicit.internal.resource.naming", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.HIGH, "Whether to enforce explicit naming for all internal resources of the topology, including internal topics (e.g., changelog and repartition topics) and their associated state stores. When enabled, the application will refuse to start if any internal resource has an auto-generated name.");
    private static final Logger log = LoggerFactory.getLogger(TopologyConfig.class);
    private final StreamsConfig globalAppConfigs;
    public final String topologyName;
    public final boolean eosEnabled;
    public final StreamsConfig applicationConfigs;
    public final Properties topologyOverrides;
    public final int maxBufferedSize;
    public final long cacheSize;
    public final long maxTaskIdleMs;
    public final long taskTimeoutMs;
    public final String storeType;
    public final Class<?> dslStoreSuppliers;
    public final Supplier<TimestampExtractor> timestampExtractorSupplier;
    public final Supplier<DeserializationExceptionHandler> deserializationExceptionHandlerSupplier;
    public final Supplier<ProcessingExceptionHandler> processingExceptionHandlerSupplier;
    public final boolean ensureExplicitInternalResourceNaming;

    public TopologyConfig(StreamsConfig configs) {
        this(null, configs, Utils.mkObjectProperties(configs.originals()));
    }

    public TopologyConfig(String topologyName, StreamsConfig globalAppConfigs, Properties topologyOverrides) {
        super(CONFIG, topologyOverrides, false);
        String deserializationExceptionHandlerKey;
        this.globalAppConfigs = globalAppConfigs;
        this.topologyName = topologyName;
        this.eosEnabled = StreamsConfigUtils.eosEnabled(globalAppConfigs);
        this.applicationConfigs = globalAppConfigs;
        this.topologyOverrides = topologyOverrides;
        this.processingExceptionHandlerSupplier = () -> globalAppConfigs.getConfiguredInstance("processing.exception.handler", ProcessingExceptionHandler.class);
        if (this.isTopologyOverride("buffered.records.per.partition", topologyOverrides)) {
            this.maxBufferedSize = this.getInt("buffered.records.per.partition");
            log.info("Topology {} is overriding {} to {}", new Object[]{topologyName, "buffered.records.per.partition", this.maxBufferedSize});
        } else {
            this.maxBufferedSize = globalAppConfigs.getInt("buffered.records.per.partition");
        }
        boolean stateStoreCacheMaxBytesOverridden = this.isTopologyOverride("statestore.cache.max.bytes", topologyOverrides);
        boolean cacheMaxBytesBufferingOverridden = this.isTopologyOverride("cache.max.bytes.buffering", topologyOverrides);
        if (!stateStoreCacheMaxBytesOverridden && !cacheMaxBytesBufferingOverridden) {
            this.cacheSize = StreamsConfigUtils.totalCacheSize(globalAppConfigs);
        } else {
            if (stateStoreCacheMaxBytesOverridden && cacheMaxBytesBufferingOverridden) {
                this.cacheSize = this.getLong("statestore.cache.max.bytes");
                log.info("Topology {} is using both deprecated config {} and new config {}, hence {} is ignored and the new config {} (value {}) is used", new Object[]{topologyName, "cache.max.bytes.buffering", "statestore.cache.max.bytes", "cache.max.bytes.buffering", "statestore.cache.max.bytes", this.cacheSize});
            } else if (cacheMaxBytesBufferingOverridden) {
                this.cacheSize = this.getLong("cache.max.bytes.buffering");
                log.info("Topology {} is using only deprecated config {}, and will be used to set cache size to {}; we suggest setting the new config {} instead as deprecated {} would be removed in the future.", new Object[]{topologyName, "cache.max.bytes.buffering", this.cacheSize, "statestore.cache.max.bytes", "cache.max.bytes.buffering"});
            } else {
                this.cacheSize = this.getLong("statestore.cache.max.bytes");
            }
            if (this.cacheSize != 0L) {
                log.warn("Topology {} is overriding cache size to {} but this will not have any effect as the topology-level cache size config only controls whether record buffering is enabled or disabled, thus the only valid override value is 0", (Object)topologyName, (Object)this.cacheSize);
            } else {
                log.info("Topology {} is overriding cache size to {}, record buffering will be disabled", (Object)topologyName, (Object)this.cacheSize);
            }
        }
        if (this.isTopologyOverride("max.task.idle.ms", topologyOverrides)) {
            this.maxTaskIdleMs = this.getLong("max.task.idle.ms");
            log.info("Topology {} is overriding {} to {}", new Object[]{topologyName, "max.task.idle.ms", this.maxTaskIdleMs});
        } else {
            this.maxTaskIdleMs = globalAppConfigs.getLong("max.task.idle.ms");
        }
        if (this.isTopologyOverride("task.timeout.ms", topologyOverrides)) {
            this.taskTimeoutMs = this.getLong("task.timeout.ms");
            log.info("Topology {} is overriding {} to {}", new Object[]{topologyName, "task.timeout.ms", this.taskTimeoutMs});
        } else {
            this.taskTimeoutMs = globalAppConfigs.getLong("task.timeout.ms");
        }
        if (this.isTopologyOverride("default.timestamp.extractor", topologyOverrides)) {
            this.timestampExtractorSupplier = () -> this.getConfiguredInstance("default.timestamp.extractor", TimestampExtractor.class);
            log.info("Topology {} is overriding {} to {}", new Object[]{topologyName, "default.timestamp.extractor", this.getClass("default.timestamp.extractor")});
        } else {
            this.timestampExtractorSupplier = () -> globalAppConfigs.getConfiguredInstance("default.timestamp.extractor", TimestampExtractor.class);
        }
        String string = deserializationExceptionHandlerKey = globalAppConfigs.originals().containsKey("deserialization.exception.handler") || this.originals().containsKey("deserialization.exception.handler") ? "deserialization.exception.handler" : "default.deserialization.exception.handler";
        if (this.isTopologyOverride(deserializationExceptionHandlerKey, topologyOverrides)) {
            this.deserializationExceptionHandlerSupplier = () -> this.getConfiguredInstance(deserializationExceptionHandlerKey, DeserializationExceptionHandler.class);
            log.info("Topology {} is overriding {} to {}", new Object[]{topologyName, deserializationExceptionHandlerKey, this.getClass(deserializationExceptionHandlerKey)});
        } else {
            this.deserializationExceptionHandlerSupplier = () -> globalAppConfigs.getConfiguredInstance(deserializationExceptionHandlerKey, DeserializationExceptionHandler.class);
        }
        if (this.isTopologyOverride("default.dsl.store", topologyOverrides)) {
            this.storeType = this.getString("default.dsl.store");
            log.info("Topology {} is overriding {} to {}", new Object[]{topologyName, "default.dsl.store", this.storeType});
        } else {
            this.storeType = globalAppConfigs.getString("default.dsl.store");
        }
        if (this.isTopologyOverride("dsl.store.suppliers.class", topologyOverrides)) {
            this.dslStoreSuppliers = this.getClass("dsl.store.suppliers.class");
            log.info("Topology {} is overriding {} to {}", new Object[]{topologyName, "dsl.store.suppliers.class", this.dslStoreSuppliers});
        } else {
            this.dslStoreSuppliers = globalAppConfigs.getClass("dsl.store.suppliers.class");
        }
        this.ensureExplicitInternalResourceNaming = globalAppConfigs.getBoolean("ensure.explicit.internal.resource.naming");
    }

    @Deprecated
    public Materialized.StoreType parseStoreType() {
        return MaterializedInternal.parse(this.storeType);
    }

    public Optional<DslStoreSuppliers> resolveDslStoreSuppliers() {
        if (this.isTopologyOverride("dsl.store.suppliers.class", this.topologyOverrides) || this.globalAppConfigs.originals().containsKey("dsl.store.suppliers.class")) {
            return Optional.of(Utils.newInstance(this.dslStoreSuppliers, DslStoreSuppliers.class));
        }
        if (this.isTopologyOverride("default.dsl.store", this.topologyOverrides) || this.globalAppConfigs.originals().containsKey("default.dsl.store")) {
            return Optional.of(MaterializedInternal.parse(this.storeType));
        }
        return Optional.empty();
    }

    public boolean isNamedTopology() {
        return this.topologyName != null;
    }

    private boolean isTopologyOverride(String config, Properties topologyOverrides) {
        return this.topologyName != null && topologyOverrides.containsKey(config);
    }

    public TaskConfig getTaskConfig() {
        return new TaskConfig(this.maxTaskIdleMs, this.taskTimeoutMs, this.maxBufferedSize, this.timestampExtractorSupplier.get(), this.deserializationExceptionHandlerSupplier.get(), this.processingExceptionHandlerSupplier.get(), this.eosEnabled);
    }

    public static class TaskConfig {
        public final long maxTaskIdleMs;
        public final long taskTimeoutMs;
        public final int maxBufferedSize;
        public final TimestampExtractor timestampExtractor;
        public final DeserializationExceptionHandler deserializationExceptionHandler;
        public final ProcessingExceptionHandler processingExceptionHandler;
        public final boolean eosEnabled;

        private TaskConfig(long maxTaskIdleMs, long taskTimeoutMs, int maxBufferedSize, TimestampExtractor timestampExtractor, DeserializationExceptionHandler deserializationExceptionHandler, ProcessingExceptionHandler processingExceptionHandler, boolean eosEnabled) {
            this.maxTaskIdleMs = maxTaskIdleMs;
            this.taskTimeoutMs = taskTimeoutMs;
            this.maxBufferedSize = maxBufferedSize;
            this.timestampExtractor = timestampExtractor;
            this.deserializationExceptionHandler = deserializationExceptionHandler;
            this.processingExceptionHandler = processingExceptionHandler;
            this.eosEnabled = eosEnabled;
        }
    }

    public static class InternalConfig {
        public static final String ENABLE_PROCESS_PROCESSVALUE_FIX = "__enable.process.processValue.fix__";

        public static boolean getBoolean(Map<String, Object> configs, String key, boolean defaultValue) {
            Object value = configs.getOrDefault(key, defaultValue);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            log.warn("Invalid value ({}) on internal configuration '{}'. Please specify a true/false value.", value, (Object)key);
            return defaultValue;
        }
    }
}

