/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.concurrent.TimeUnit;
import stormpot.Allocator;
import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.Reallocator;
import stormpot.Slot;
import stormpot.internal.ReallocatingAdaptor;

class TimingReallocatingAdaptor<T extends Poolable>
extends ReallocatingAdaptor<T>
implements Reallocator<T> {
    final MetricsRecorder metricsRecorder;

    TimingReallocatingAdaptor(Allocator<T> allocator, MetricsRecorder metricsRecorder) {
        super(allocator);
        this.metricsRecorder = metricsRecorder;
    }

    @Override
    public T allocate(Slot slot) throws Exception {
        long start = System.nanoTime();
        try {
            Object obj = super.allocate(slot);
            long elapsedNanos = System.nanoTime() - start;
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
            this.metricsRecorder.recordAllocationLatencySampleMillis(milliseconds);
            return obj;
        }
        catch (Exception e) {
            long elapsedNanos = System.nanoTime() - start;
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
            this.metricsRecorder.recordAllocationFailureLatencySampleMillis(milliseconds);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate(T poolable) throws Exception {
        long start = System.nanoTime();
        try {
            super.deallocate(poolable);
        }
        finally {
            long elapsedNanos = System.nanoTime() - start;
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
            this.metricsRecorder.recordDeallocationLatencySampleMillis(milliseconds);
        }
    }
}

