/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import stormpot.Allocator;
import stormpot.Completion;
import stormpot.Poolable;
import stormpot.internal.AllocationController;
import stormpot.internal.BAllocThread;
import stormpot.internal.BSlot;
import stormpot.internal.PoolBuilderImpl;
import stormpot.internal.RefillPile;

public final class ThreadedAllocationController<T extends Poolable>
extends AllocationController<T> {
    private final BAllocThread<T> allocator;
    private final Thread allocatorThread;

    ThreadedAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilderImpl<T> builder, BSlot<T> poisonPill) {
        this.allocator = new BAllocThread<T>(live, disregardPile, newAllocations, builder, poisonPill);
        ThreadFactory factory = builder.getThreadFactory();
        this.allocatorThread = factory.newThread(this.allocator);
        this.allocatorThread.start();
    }

    @Override
    public Completion shutdown() {
        return this.allocator.shutdown(this.allocatorThread);
    }

    @Override
    Completion switchAllocator(Allocator<T> replacementAllocator) {
        return this.allocator.switchAllocator(replacementAllocator);
    }

    @Override
    public void offerDeadSlot(BSlot<T> slot) {
        this.allocator.offerDeadSlot(slot);
    }

    @Override
    public void setTargetSize(long size) {
        this.allocator.setTargetSize(size);
    }

    @Override
    public long getTargetSize() {
        return this.allocator.getTargetSize();
    }

    @Override
    public long getAllocationCount() {
        return this.allocator.getAllocationCount();
    }

    @Override
    public long getFailedAllocationCount() {
        return this.allocator.getFailedAllocationCount();
    }

    @Override
    public long countLeakedObjects() {
        return this.allocator.countLeakedObjects();
    }

    @Override
    public long allocatedSize() {
        return this.allocator.allocatedSize();
    }

    @Override
    public long inUse() {
        return this.allocator.inUse();
    }
}

