/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.Objects;
import stormpot.Allocator;
import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.Reallocator;
import stormpot.Slot;
import stormpot.internal.TimingReallocatingAdaptor;
import stormpot.internal.TimingReallocatorAdaptor;

public class ReallocatingAdaptor<T extends Poolable>
implements Reallocator<T> {
    final Allocator<T> allocator;

    public ReallocatingAdaptor(Allocator<T> allocator) {
        this.allocator = Objects.requireNonNull(allocator, "allocator");
    }

    static <T extends Poolable> Reallocator<T> adapt(Allocator<T> allocator, MetricsRecorder metricsRecorder) {
        if (metricsRecorder == null) {
            if (allocator instanceof Reallocator) {
                return (Reallocator)allocator;
            }
            return new ReallocatingAdaptor<T>(allocator);
        }
        if (allocator instanceof Reallocator) {
            return new TimingReallocatorAdaptor((Reallocator)allocator, metricsRecorder);
        }
        return new TimingReallocatingAdaptor<T>(allocator, metricsRecorder);
    }

    @Override
    public T reallocate(Slot slot, T poolable) throws Exception {
        try {
            this.allocator.deallocate(poolable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.allocator.allocate(slot);
    }

    @Override
    public T allocate(Slot slot) throws Exception {
        return this.allocator.allocate(slot);
    }

    @Override
    public void deallocate(T poolable) throws Exception {
        this.allocator.deallocate(poolable);
    }

    public Allocator<T> unwrap() {
        return this.allocator;
    }
}

