/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.ToIntFunction;
import stormpot.internal.BSlot;
import stormpot.internal.IdentityHashSet;

public final class PreciseLeakDetector {
    private static final ToIntFunction<Object> REF_HASH = obj -> ((CountedPhantomRef)obj).id;
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final LongAdder leakedObjectCount = new LongAdder();
    private final IdentityHashSet refs = new IdentityHashSet(REF_HASH);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(BSlot<?> slot) {
        CountedPhantomRef<Object> ref = new CountedPhantomRef<Object>(slot.obj, this.referenceQueue);
        slot.leakCheck = ref;
        IdentityHashSet identityHashSet = this.refs;
        synchronized (identityHashSet) {
            this.refs.add(ref);
        }
        this.accumulateLeaks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulateLeaks() {
        Reference<Object> ref;
        ArrayList<Reference<Object>> refsToRemove = null;
        while ((ref = this.referenceQueue.poll()) != null) {
            if (refsToRemove == null) {
                refsToRemove = new ArrayList<Reference<Object>>();
            }
            refsToRemove.add(ref);
        }
        if (refsToRemove != null) {
            this.leakedObjectCount.add(refsToRemove.size());
            IdentityHashSet identityHashSet = this.refs;
            synchronized (identityHashSet) {
                for (Reference reference : refsToRemove) {
                    this.refs.remove(reference);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(BSlot<?> slot) {
        slot.leakCheck.clear();
        IdentityHashSet identityHashSet = this.refs;
        synchronized (identityHashSet) {
            this.refs.remove(slot.leakCheck);
        }
        slot.leakCheck = null;
        this.accumulateLeaks();
    }

    public long countLeakedObjects() {
        this.accumulateLeaks();
        return this.leakedObjectCount.sum();
    }

    private static final class CountedPhantomRef<T>
    extends PhantomReference<T> {
        private static final AtomicInteger COUNTER = new AtomicInteger();
        private final int id = COUNTER.getAndIncrement();

        CountedPhantomRef(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
        }
    }
}

