/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class IdentityHashSet
implements Iterable<Object> {
    private static final int BLOCK_LEN = 8;
    private static final ToIntFunction<Object> DEFAULT_HASH = System::identityHashCode;
    private final Object[] stash = new Object[8];
    private final int subtreeMix;
    private final ToIntFunction<Object> hashOf;
    private int stashSize;
    private int sectionLength = 8 * this.sectionBlocks;
    private int sectionBlocks = 8;
    private Object[] table = new Object[this.sectionLength * 2];
    private boolean treeMode;

    public IdentityHashSet() {
        this(DEFAULT_HASH);
    }

    public IdentityHashSet(ToIntFunction<Object> hashCode) {
        this.subtreeMix = ThreadLocalRandom.current().nextInt();
        this.hashOf = Objects.requireNonNull(hashCode, "hashCode");
    }

    public void add(Object obj) {
        while (true) {
            if (this.treeMode) {
                this.subtree(obj).add(obj);
                return;
            }
            int mask = this.sectionBlocks - 1;
            int ihash = this.hashOf.applyAsInt(obj);
            int h1 = 8 * (ihash & mask);
            int h2 = this.sectionLength + 8 * (IdentityHashSet.fmix32(ihash) & mask);
            for (int i = 0; i < this.stashSize; ++i) {
                if (obj != this.stash[i]) continue;
                return;
            }
            int e1 = Integer.MAX_VALUE;
            int e2 = Integer.MAX_VALUE;
            for (int i = 0; i < 8; ++i) {
                Object o1 = this.table[h1 + i];
                Object o2 = this.table[h2 + i];
                if (o1 == obj || o2 == obj) {
                    return;
                }
                if (o1 == null) {
                    e1 = Math.min(i, e1);
                }
                if (o2 != null) continue;
                e2 = Math.min(i, e2);
            }
            if (e1 < e2) {
                this.table[h1 + e1] = obj;
                return;
            }
            if (e2 != Integer.MAX_VALUE) {
                this.table[h2 + e2] = obj;
                return;
            }
            if (this.stashSize < 8) {
                this.stash[this.stashSize] = obj;
                ++this.stashSize;
                return;
            }
            this.resize();
        }
    }

    public void remove(Object obj) {
        int i;
        if (this.treeMode) {
            this.subtree(obj).remove(obj);
            return;
        }
        int ihash = this.hashOf.applyAsInt(obj);
        int mask = this.sectionBlocks - 1;
        int h1 = 8 * (ihash & mask);
        int h2 = this.sectionLength + 8 * (IdentityHashSet.fmix32(ihash) & mask);
        for (i = 0; i < this.stashSize; ++i) {
            if (obj != this.stash[i]) continue;
            if (i == this.stashSize - 1) {
                this.stash[i] = null;
            } else {
                this.stash[i] = this.stash[this.stashSize - 1];
                this.stash[this.stashSize - 1] = null;
            }
            --this.stashSize;
            return;
        }
        for (i = 0; i < 8; ++i) {
            Object o1 = this.table[h1 + i];
            Object o2 = this.table[h2 + i];
            if (o1 == obj) {
                this.table[h1 + i] = null;
                return;
            }
            if (o2 != obj) continue;
            this.table[h2 + i] = null;
            return;
        }
    }

    private IdentityHashSet subtree(Object obj) {
        int ihash = this.hashOf.applyAsInt(obj);
        ihash = IdentityHashSet.fmix32(ihash ^ this.subtreeMix) & this.sectionBlocks;
        return (IdentityHashSet)this.table[ihash];
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.treeMode) {
            return Stream.of(this.table).flatMap(obj -> {
                IdentityHashSet set = (IdentityHashSet)obj;
                return StreamSupport.stream(set.spliterator(), false);
            }).iterator();
        }
        return Stream.concat(Stream.of(this.stash), Stream.of(this.table)).filter(Objects::nonNull).iterator();
    }

    private static int fmix32(int key) {
        key ^= key >>> 16;
        key *= -2048144789;
        key ^= key >>> 13;
        key *= -1028477387;
        key ^= key >>> 16;
        return key;
    }

    private void resize() {
        int newSectionLength = this.sectionLength * 2;
        int newTableLength = newSectionLength * 2;
        int newSectionBlocks = this.sectionBlocks * 2;
        Object[] stashCopy = Arrays.copyOfRange(this.stash, 0, this.stashSize);
        Arrays.fill(this.stash, null);
        this.stashSize = 0;
        Object[] oldTable = this.table;
        if (newTableLength >= 0x200000) {
            this.treeMode = true;
            int len = 16384;
            Object[] newTable = new Object[len];
            for (int i = 0; i < len; ++i) {
                newTable[i] = new IdentityHashSet(this.hashOf);
            }
            this.table = newTable;
            this.sectionLength = len;
            this.sectionBlocks = len - 1;
        } else {
            this.sectionLength = newSectionLength;
            this.sectionBlocks = newSectionBlocks;
            this.table = new Object[newTableLength];
        }
        for (Object obj : stashCopy) {
            this.add(obj);
        }
        for (Object obj : oldTable) {
            if (obj == null) continue;
            this.add(obj);
        }
    }
}

