/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import stormpot.Allocator;
import stormpot.Completion;
import stormpot.Expiration;
import stormpot.ManagedPool;
import stormpot.MetricsRecorder;
import stormpot.Pool;
import stormpot.PoolException;
import stormpot.PoolTap;
import stormpot.Poolable;
import stormpot.Timeout;
import stormpot.internal.AllocationController;
import stormpot.internal.AllocationProcess;
import stormpot.internal.BSlot;
import stormpot.internal.BSlotCache;
import stormpot.internal.BlazePoolSingleThreadedTap;
import stormpot.internal.BlazePoolThreadSafeTap;
import stormpot.internal.BlazePoolVirtualThreadSafeTap;
import stormpot.internal.NanoClock;
import stormpot.internal.PoisonException;
import stormpot.internal.PoolBuilderImpl;
import stormpot.internal.RefillPile;
import stormpot.internal.StackCompletion;
import stormpot.internal.ThreadLocalBSlotCache;

public final class BlazePool<T extends Poolable>
implements Pool<T>,
ManagedPool {
    private static final VarHandle SHUTDOWN;
    private static final VarHandle VIRT_THR_TAP;
    private static final Exception SHUTDOWN_POISON;
    static final Exception EXPLICIT_EXPIRE_POISON;
    private final LinkedTransferQueue<BSlot<T>> live = new LinkedTransferQueue();
    private final RefillPile<T> disregardPile = new RefillPile<T>(this.live);
    private final RefillPile<T> newAllocations = new RefillPile<T>(this.live);
    private final AllocationController<T> allocator;
    private final ThreadLocal<BSlotCache<T>> tlr;
    private final Expiration<? super T> deallocRule;
    private final MetricsRecorder metricsRecorder;
    private final boolean optimizeForMemory;
    private volatile BlazePoolVirtualThreadSafeTap<T> virtualThreadSafeTap;
    private final BSlot<T> poisonPill;
    private volatile boolean shutdown;

    public BlazePool(PoolBuilderImpl<T> builder, AllocationProcess factory) {
        this.optimizeForMemory = builder.isOptimizeForReducedMemoryUsage();
        this.tlr = new ThreadLocalBSlotCache(this.optimizeForMemory);
        this.poisonPill = new BSlot<T>(this.live, null);
        this.poisonPill.poison = SHUTDOWN_POISON;
        this.deallocRule = builder.getExpiration();
        this.metricsRecorder = builder.getMetricsRecorder();
        this.allocator = factory.buildAllocationController(this.live, this.disregardPile, this.newAllocations, builder, this.poisonPill);
    }

    @Override
    public T claim(Timeout timeout) throws PoolException, InterruptedException {
        return this.claim(timeout, this.tlr.get());
    }

    @Override
    public T tryClaim() throws PoolException {
        return this.tryClaim(this.tlr.get());
    }

    T claim(Timeout timeout, BSlotCache<T> cache) throws PoolException, InterruptedException {
        this.checkShutDown();
        Objects.requireNonNull(timeout, "Timeout cannot be null.");
        T obj = this.tlrClaim(cache);
        if (obj != null) {
            return obj;
        }
        return this.slowClaim(timeout, cache);
    }

    T tryClaim(BSlotCache<T> cache) throws PoolException {
        this.checkShutDown();
        T obj = this.tlrClaim(cache);
        if (obj != null) {
            return obj;
        }
        return this.slowClaim(cache);
    }

    T tlrClaim(BSlotCache<T> cache) {
        BSlot slot = cache.slot;
        if (slot != null && slot.live2claimTlr() && this.isValid(slot, cache, true)) {
            return slot.obj;
        }
        return null;
    }

    private T slowClaim(BSlotCache<T> cache) throws PoolException {
        BSlot<T> slot = this.newAllocations.pop();
        while (true) {
            if (slot == null) {
                slot = this.live.poll();
            }
            if (slot == null) {
                this.disregardPile.refill();
                return null;
            }
            if (slot.live2claim()) {
                if (!this.isValid(slot, cache, false)) continue;
                cache.slot = slot;
                return slot.obj;
            }
            this.disregardPile.push(slot);
        }
    }

    private T slowClaim(Timeout timeout, BSlotCache<T> cache) throws PoolException, InterruptedException {
        long timeoutNanos;
        long startNanos = NanoClock.nanoTime();
        long timeoutLeft = timeoutNanos = timeout.getTimeoutInBaseUnit();
        TimeUnit baseUnit = timeout.getBaseUnit();
        long maxWaitQuantum = baseUnit.convert(100L, TimeUnit.MILLISECONDS);
        do {
            this.checkShutDown();
            BSlot<T> slot = this.newAllocations.pop();
            if (slot == null) {
                long pollWait = Math.min(timeoutLeft, maxWaitQuantum);
                slot = this.live.poll(pollWait, baseUnit);
            }
            if (slot == null) {
                this.disregardPile.refill();
                continue;
            }
            if (slot.live2claim()) {
                if (!this.isValid(slot, cache, false)) continue;
                cache.slot = slot;
                return slot.obj;
            }
            this.disregardPile.push(slot);
        } while ((timeoutLeft = NanoClock.timeoutLeft(startNanos, timeoutNanos)) > 0L);
        return null;
    }

    void checkShutDown() {
        if (this.isShutDown()) {
            throw new IllegalStateException("Pool has been shut down");
        }
    }

    private boolean isValid(BSlot<T> slot, BSlotCache<T> cache, boolean isTlr) {
        if (slot.poison != null) {
            this.handleUncommonInvalidation(slot, cache, isTlr);
            return false;
        }
        try {
            if (this.deallocRule.hasExpired(slot)) {
                this.handleCommonInvalidation(slot, cache, null);
                return false;
            }
            return true;
        }
        catch (Throwable ex) {
            this.handleCommonInvalidation(slot, cache, ex);
            return false;
        }
    }

    private void handleUncommonInvalidation(BSlot<T> slot, BSlotCache<T> cache, boolean isTlr) {
        Exception poison = slot.poison;
        if (poison == SHUTDOWN_POISON) {
            slot.claim2live();
            this.live.offer(this.poisonPill);
            throw new IllegalStateException("Pool has been shut down");
        }
        this.kill(slot, cache);
        if (!isTlr && poison != EXPLICIT_EXPIRE_POISON) {
            throw new PoolException("Allocation failed", poison);
        }
    }

    private void handleCommonInvalidation(BSlot<T> slot, BSlotCache<T> cache, Throwable exception) {
        this.kill(slot, cache);
        if (exception != null) {
            String msg = "Got exception when checking whether an object had expired";
            throw new PoolException(msg, exception);
        }
    }

    private void kill(BSlot<T> slot, BSlotCache<T> cache) {
        if (slot.isClaimed()) {
            slot.claim2dead();
            this.allocator.offerDeadSlot(slot);
        } else {
            slot.claimTlr2live();
            cache.slot = null;
        }
    }

    @Override
    public Completion shutdown() {
        SHUTDOWN.setOpaque(this, true);
        return this.allocator.shutdown();
    }

    @Override
    public Completion switchAllocator(Allocator<T> replacementAllocator) {
        if (this.isShutDown()) {
            return new StackCompletion(true);
        }
        return this.allocator.switchAllocator(replacementAllocator);
    }

    @Override
    public void setTargetSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Target pool size must be positive");
        }
        if (this.isShutDown()) {
            return;
        }
        this.allocator.setTargetSize(size);
    }

    @Override
    public long getTargetSize() {
        return this.allocator.getTargetSize();
    }

    @Override
    public ManagedPool getManagedPool() {
        return this;
    }

    @Override
    public PoolTap<T> getThreadSafeTap() {
        return new BlazePoolThreadSafeTap(this);
    }

    @Override
    public PoolTap<T> getVirtualThreadSafeTap() {
        BlazePoolVirtualThreadSafeTap tmp;
        BlazePoolVirtualThreadSafeTap tap = this.virtualThreadSafeTap;
        if (tap == null && (tmp = VIRT_THR_TAP.compareAndExchange(this, null, tap = new BlazePoolVirtualThreadSafeTap(this, this.optimizeForMemory))) != null) {
            tap = tmp;
        }
        return tap;
    }

    @Override
    public PoolTap<T> getSingleThreadedTap() {
        return new BlazePoolSingleThreadedTap(this, this.optimizeForMemory);
    }

    @Override
    public long getAllocationCount() {
        return this.allocator.getAllocationCount();
    }

    @Override
    public long getFailedAllocationCount() {
        return this.allocator.getFailedAllocationCount();
    }

    @Override
    public boolean isShutDown() {
        return SHUTDOWN.getOpaque(this);
    }

    @Override
    public double getObjectLifetimePercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getObjectLifetimePercentile(percentile);
    }

    @Override
    public double getAllocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getAllocationLatencyPercentile(percentile);
    }

    @Override
    public double getAllocationFailureLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getAllocationFailureLatencyPercentile(percentile);
    }

    @Override
    public double getReallocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getReallocationLatencyPercentile(percentile);
    }

    @Override
    public double getReallocationFailureLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getReallocationFailurePercentile(percentile);
    }

    @Override
    public double getDeallocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getDeallocationLatencyPercentile(percentile);
    }

    @Override
    public long getLeakedObjectsCount() {
        return this.allocator.countLeakedObjects();
    }

    @Override
    public long getCurrentAllocatedCount() {
        return this.allocator.allocatedSize();
    }

    @Override
    public long getCurrentInUseCount() {
        return this.allocator.inUse();
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            SHUTDOWN = lookup.findVarHandle(BlazePool.class, "shutdown", Boolean.TYPE).withInvokeExactBehavior();
            VIRT_THR_TAP = lookup.findVarHandle(BlazePool.class, "virtualThreadSafeTap", BlazePoolVirtualThreadSafeTap.class).withInvokeExactBehavior();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError("Failed to initialise the shutdown VarHandle.", e);
        }
        SHUTDOWN_POISON = new PoisonException("Stormpot Poison: Shutdown");
        EXPLICIT_EXPIRE_POISON = new PoisonException("Stormpot Poison: Expired");
    }
}

