/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import stormpot.PoolException;
import stormpot.Poolable;
import stormpot.Timeout;

public interface PoolTap<T extends Poolable> {
    public T claim(Timeout var1) throws PoolException, InterruptedException;

    default public T tryClaim() throws PoolException {
        try {
            return this.claim(Timeout.ZERO_TIMEOUT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> Optional<R> apply(Timeout timeout, Function<T, R> function) throws InterruptedException {
        Objects.requireNonNull(function, "Function cannot be null.");
        T obj = this.claim(timeout);
        if (obj == null) {
            return Optional.empty();
        }
        try {
            Optional<R> optional = Optional.ofNullable(function.apply(obj));
            return optional;
        }
        finally {
            obj.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean supply(Timeout timeout, Consumer<T> consumer) throws InterruptedException {
        Objects.requireNonNull(consumer, "Consumer cannot be null.");
        T obj = this.claim(timeout);
        if (obj == null) {
            return false;
        }
        try {
            consumer.accept(obj);
            boolean bl = true;
            return bl;
        }
        finally {
            obj.release();
        }
    }
}

