/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.TimeUnit;
import stormpot.Poolable;
import stormpot.SlotInfo;
import stormpot.internal.EveryExpiration;
import stormpot.internal.OrExpiration;
import stormpot.internal.TimeExpiration;
import stormpot.internal.TimeSpreadExpiration;

public interface Expiration<T extends Poolable> {
    public static <T extends Poolable> Expiration<T> after(long time, TimeUnit unit) {
        return new TimeExpiration(time, unit);
    }

    public static <T extends Poolable> Expiration<T> after(long fromTime, long toTime, TimeUnit unit) {
        return new TimeSpreadExpiration(fromTime, toTime, unit);
    }

    public static <T extends Poolable> Expiration<T> never() {
        return info -> false;
    }

    default public Expiration<T> or(Expiration<T> other) {
        return new OrExpiration<T>(this, other);
    }

    default public Expiration<T> every(long time, TimeUnit unit) {
        return this.every(time, time, unit);
    }

    default public Expiration<T> every(long fromTime, long toTime, TimeUnit unit) {
        return new EveryExpiration(this, fromTime, toTime, unit);
    }

    public boolean hasExpired(SlotInfo<? extends T> var1) throws Exception;
}

