/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction0;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectBytePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectByteMap;
import org.eclipse.collections.api.map.primitive.ObjectByteMap;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ObjectBytePair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedByteCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.factory.primitive.ByteObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectByteMaps;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectByteMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectByteMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ObjectByteHashMapWithHashingStrategy<K>
implements MutableObjectByteMap<K>,
Externalizable {
    public static final byte EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectByteHashMapWithHashingStrategy.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectByteHashMapWithHashingStrategy.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private byte[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private HashingStrategy<? super K> hashingStrategy;

    @Deprecated
    public ObjectByteHashMapWithHashingStrategy() {
    }

    public ObjectByteHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy) {
        this.hashingStrategy = hashingStrategy;
        this.allocateTable(16);
    }

    public ObjectByteHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.hashingStrategy = hashingStrategy;
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public ObjectByteHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, ObjectByteMap<? extends K> map) {
        this(hashingStrategy, Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectByteHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy) {
        return new ObjectByteHashMapWithHashingStrategy<K>(hashingStrategy);
    }

    public static <K> ObjectByteHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy, ObjectByteMap<K> map) {
        return new ObjectByteHashMapWithHashingStrategy<K>(hashingStrategy, map);
    }

    public static <K> ObjectByteHashMapWithHashingStrategy<K> newMap(ObjectByteHashMapWithHashingStrategy<K> map) {
        return new ObjectByteHashMapWithHashingStrategy<K>(map.hashingStrategy, map);
    }

    public static <K> ObjectByteHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, byte value1) {
        return new ObjectByteHashMapWithHashingStrategy<K>(hashingStrategy, 1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectByteHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, byte value1, K key2, byte value2) {
        return new ObjectByteHashMapWithHashingStrategy<K>(hashingStrategy, 2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectByteHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, byte value1, K key2, byte value2, K key3, byte value3) {
        return new ObjectByteHashMapWithHashingStrategy<K>(hashingStrategy, 3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectByteHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, byte value1, K key2, byte value2, K key3, byte value3, K key4, byte value4) {
        return new ObjectByteHashMapWithHashingStrategy<K>(hashingStrategy, 4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectByteMap)) {
            return false;
        }
        ObjectByteMap other = (ObjectByteMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += this.hashingStrategy.computeHashCode(this.toNonSentinel(this.keys[i])) ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public int size() {
        return this.occupiedWithData;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return this.size() != 0;
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    @Override
    public byte[] toArray() {
        byte[] result = new byte[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    @Override
    public byte[] toArray(byte[] target) {
        if (target.length < this.size()) {
            target = new byte[this.size()];
        }
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            target[index] = this.values[i];
            ++index;
        }
        return target;
    }

    @Override
    public boolean contains(byte value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return this.containsAll(source.toArray());
    }

    @Override
    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, (byte)0);
    }

    @Override
    public void put(K key, byte value) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    @Override
    public void putAll(ObjectByteMap<? extends K> map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(ObjectByteToByteFunction<? super K> function) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    public void removeKeyAtIndex(K key, int index) {
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    @Override
    public void remove(Object key) {
        this.removeKey(key);
    }

    @Override
    public byte removeKeyIfAbsent(K key, byte value) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            byte oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    @Override
    public byte getIfAbsentPut(K key, byte value) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public byte getIfAbsentPut(K key, ByteFunction0 function) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        byte value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> byte getIfAbsentPutWith(K key, ByteFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        byte value = function.byteValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public byte getIfAbsentPutWithKey(K key, ByteFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        byte value = function.byteValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public byte updateValue(K key, byte initialValueIfAbsent, ByteToByteFunction function) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        byte value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, byte value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectByteHashMapWithHashingStrategy.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    @Override
    public byte addToValue(K key, byte toBeAdded) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = (byte)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    @Override
    public ObjectByteHashMapWithHashingStrategy<K> withKeyValue(K key1, byte value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectByteHashMapWithHashingStrategy<K> withKeysValues(K key1, byte value1, K key2, byte value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectByteHashMapWithHashingStrategy<K> withKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectByteHashMapWithHashingStrategy<K> withKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3, K key4, byte value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public ObjectByteHashMapWithHashingStrategy<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public ObjectByteHashMapWithHashingStrategy<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    @Override
    public MutableObjectByteMap<K> asUnmodifiable() {
        return new UnmodifiableObjectByteMap(this);
    }

    @Override
    public MutableObjectByteMap<K> asSynchronized() {
        return new SynchronizedObjectByteMap(this);
    }

    @Override
    public ImmutableObjectByteMap<K> toImmutable() {
        return ObjectByteMaps.immutable.withAll(this);
    }

    @Override
    public byte get(Object key) {
        return this.getIfAbsent(key, (byte)0);
    }

    @Override
    public byte getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public byte getIfAbsent(Object key, byte ifAbsent) {
        int index = this.probe(key);
        if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    @Override
    public boolean containsValue(byte value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public void forEachValue(ByteProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    @Override
    public void forEachKeyValue(ObjectByteProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public ObjectByteHashMapWithHashingStrategy<K> select(ObjectBytePredicate<? super K> predicate) {
        ObjectByteHashMapWithHashingStrategy<K> result = ObjectByteHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public ObjectByteHashMapWithHashingStrategy<K> reject(ObjectBytePredicate<? super K> predicate) {
        ObjectByteHashMapWithHashingStrategy<K> result = ObjectByteHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public MutableByteCollection select(BytePredicate predicate) {
        ByteArrayList result = new ByteArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableByteCollection reject(BytePredicate predicate) {
        ByteArrayList result = new ByteArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    @Override
    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        FastList<V> result = FastList.newList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    @Override
    public int count(BytePredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList<ByteIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableByteIterator iterator2 = this.byteIterator();
            while (iterator2.hasNext()) {
                MutableByteBag batch = ByteBags.mutable.empty();
                for (int i = 0; i < size && iterator2.hasNext(); ++i) {
                    batch.add(iterator2.next());
                }
                result.add(batch);
            }
        }
        return result;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    @Override
    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte min = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        byte max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        byte min = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public MutableByteList toList() {
        ByteArrayList result = new ByteArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableByteSet toSet() {
        ByteHashSet result = new ByteHashSet(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableByteBag toBag() {
        ByteHashBag result = new ByteHashBag(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableByteList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeByte(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashingStrategy = (HashingStrategy)in.readObject();
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size << 1));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readByte());
        }
    }

    @Override
    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ObjectBytePair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableByteObjectMap<K> flipUniqueValues() {
        MutableByteObjectMap result = ByteObjectMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        byte[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectByteHashMapWithHashingStrategy.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || this.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectByteHashMapWithHashingStrategy.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        K nonSentinelKey = this.toNonSentinel(element);
        int h = nonSentinelKey == null ? 0 : this.hashingStrategy.computeHashCode(nonSentinelKey);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private boolean nullSafeEquals(K value, Object other) {
        return value == null ? other == null : value != NULL_KEY && other != null && this.hashingStrategy.equals(value, this.toNonSentinel(other));
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new byte[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectByteHashMapWithHashingStrategy.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public MutableByteCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectByteHashMapWithHashingStrategy x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$502(ObjectByteHashMapWithHashingStrategy x0, byte[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectBytePair<K>> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ObjectBytePair<K>> procedure) {
            for (int i = 0; i < ObjectByteHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i]), ObjectByteHashMapWithHashingStrategy.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectBytePair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectByteHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i]), ObjectByteHashMapWithHashingStrategy.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectBytePair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectByteHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i]), ObjectByteHashMapWithHashingStrategy.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<ObjectBytePair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectBytePair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectBytePair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectByteHashMapWithHashingStrategy.this.keys;
                while (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectBytePair<Object> result = PrimitiveTuples.pair(ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[this.position]), ObjectByteHashMapWithHashingStrategy.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectByteHashMapWithHashingStrategy.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        @Override
        public void each(Procedure<? super K> procedure) {
            ObjectByteHashMapWithHashingStrategy.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectByteProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectByteHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i])) continue;
                objectByteProcedure.value(ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectByteHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i]), parameter);
            }
        }

        @Override
        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectByteHashMapWithHashingStrategy.this.keys;
                while (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectByteHashMapWithHashingStrategy.this.size();
            }
        }
    }

    private class ValuesCollection
    implements MutableByteCollection {
        private ValuesCollection() {
        }

        @Override
        public int size() {
            return ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectByteHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return ObjectByteHashMapWithHashingStrategy.this.notEmpty();
        }

        @Override
        public String makeString() {
            return this.makeString(", ");
        }

        @Override
        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        @Override
        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        @Override
        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectByteHashMapWithHashingStrategy.this.keys.length; ++i) {
                    Object key = ObjectByteHashMapWithHashingStrategy.this.keys[i];
                    if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectByteHashMapWithHashingStrategy.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean add(byte element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(byte item) {
            int oldSize = ObjectByteHashMapWithHashingStrategy.this.size();
            for (int i = 0; i < ObjectByteHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[i]) || item != ObjectByteHashMapWithHashingStrategy.this.values[i]) continue;
                ObjectByteHashMapWithHashingStrategy.this.removeKey(ObjectByteHashMapWithHashingStrategy.this.keys[i]);
            }
            return oldSize != ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(ByteIterable source) {
            int oldSize = ObjectByteHashMapWithHashingStrategy.this.size();
            ByteIterator iterator2 = source.byteIterator();
            while (iterator2.hasNext()) {
                this.remove(iterator2.next());
            }
            return oldSize != ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(byte ... source) {
            int oldSize = ObjectByteHashMapWithHashingStrategy.this.size();
            for (byte item : source) {
                this.remove(item);
            }
            return oldSize != ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean retainAll(ByteIterable source) {
            int oldSize = ObjectByteHashMapWithHashingStrategy.this.size();
            ByteSet sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            MutableObjectByteMap retained = ObjectByteHashMapWithHashingStrategy.this.select((T object, byte value) -> sourceSet.contains(value));
            if (((ObjectByteHashMapWithHashingStrategy)retained).size() != oldSize) {
                ObjectByteHashMapWithHashingStrategy.access$302(ObjectByteHashMapWithHashingStrategy.this, ((ObjectByteHashMapWithHashingStrategy)retained).keys);
                ObjectByteHashMapWithHashingStrategy.access$502(ObjectByteHashMapWithHashingStrategy.this, ((ObjectByteHashMapWithHashingStrategy)retained).values);
                ObjectByteHashMapWithHashingStrategy.this.occupiedWithData = ((ObjectByteHashMapWithHashingStrategy)retained).occupiedWithData;
                ObjectByteHashMapWithHashingStrategy.this.occupiedWithSentinels = ((ObjectByteHashMapWithHashingStrategy)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(byte ... source) {
            return this.retainAll(ByteHashSet.newSetWith(source));
        }

        @Override
        public void clear() {
            ObjectByteHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public MutableByteCollection with(byte element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteCollection without(byte element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteCollection withAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteCollection withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteCollection asUnmodifiable() {
            return UnmodifiableByteCollection.of(this);
        }

        @Override
        public MutableByteCollection asSynchronized() {
            return SynchronizedByteCollection.of(this);
        }

        @Override
        public ImmutableByteCollection toImmutable() {
            return ByteLists.immutable.withAll(this);
        }

        @Override
        public MutableByteIterator byteIterator() {
            return ObjectByteHashMapWithHashingStrategy.this.byteIterator();
        }

        @Override
        public byte[] toArray() {
            return ObjectByteHashMapWithHashingStrategy.this.toArray();
        }

        @Override
        public byte[] toArray(byte[] target) {
            return ObjectByteHashMapWithHashingStrategy.this.toArray(target);
        }

        @Override
        public boolean contains(byte value) {
            return ObjectByteHashMapWithHashingStrategy.this.containsValue(value);
        }

        @Override
        public boolean containsAll(byte ... source) {
            return ObjectByteHashMapWithHashingStrategy.this.containsAll(source);
        }

        @Override
        public boolean containsAll(ByteIterable source) {
            return ObjectByteHashMapWithHashingStrategy.this.containsAll(source);
        }

        @Override
        public void forEach(ByteProcedure procedure) {
            ObjectByteHashMapWithHashingStrategy.this.forEach(procedure);
        }

        @Override
        public void each(ByteProcedure procedure) {
            this.forEach(procedure);
        }

        @Override
        public MutableByteCollection select(BytePredicate predicate) {
            return ObjectByteHashMapWithHashingStrategy.this.select(predicate);
        }

        @Override
        public MutableByteCollection reject(BytePredicate predicate) {
            return ObjectByteHashMapWithHashingStrategy.this.reject(predicate);
        }

        @Override
        public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
            return ObjectByteHashMapWithHashingStrategy.this.collect((ByteToObjectFunction)function);
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            return ObjectByteHashMapWithHashingStrategy.this.injectInto(injectedValue, function);
        }

        @Override
        public RichIterable<ByteIterable> chunk(int size) {
            return ObjectByteHashMapWithHashingStrategy.this.chunk(size);
        }

        @Override
        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            return ObjectByteHashMapWithHashingStrategy.this.detectIfNone(predicate, ifNone);
        }

        @Override
        public int count(BytePredicate predicate) {
            return ObjectByteHashMapWithHashingStrategy.this.count(predicate);
        }

        @Override
        public boolean anySatisfy(BytePredicate predicate) {
            return ObjectByteHashMapWithHashingStrategy.this.anySatisfy(predicate);
        }

        @Override
        public boolean allSatisfy(BytePredicate predicate) {
            return ObjectByteHashMapWithHashingStrategy.this.allSatisfy(predicate);
        }

        @Override
        public boolean noneSatisfy(BytePredicate predicate) {
            return ObjectByteHashMapWithHashingStrategy.this.noneSatisfy(predicate);
        }

        @Override
        public MutableByteList toList() {
            return ObjectByteHashMapWithHashingStrategy.this.toList();
        }

        @Override
        public MutableByteSet toSet() {
            return ObjectByteHashMapWithHashingStrategy.this.toSet();
        }

        @Override
        public MutableByteBag toBag() {
            return ObjectByteHashMapWithHashingStrategy.this.toBag();
        }

        @Override
        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter(this);
        }

        @Override
        public byte[] toSortedArray() {
            return ObjectByteHashMapWithHashingStrategy.this.toSortedArray();
        }

        @Override
        public MutableByteList toSortedList() {
            return ObjectByteHashMapWithHashingStrategy.this.toSortedList();
        }

        @Override
        public long sum() {
            return ObjectByteHashMapWithHashingStrategy.this.sum();
        }

        @Override
        public byte max() {
            return ObjectByteHashMapWithHashingStrategy.this.max();
        }

        @Override
        public byte maxIfEmpty(byte defaultValue) {
            return ObjectByteHashMapWithHashingStrategy.this.maxIfEmpty(defaultValue);
        }

        @Override
        public byte min() {
            return ObjectByteHashMapWithHashingStrategy.this.min();
        }

        @Override
        public byte minIfEmpty(byte defaultValue) {
            return ObjectByteHashMapWithHashingStrategy.this.minIfEmpty(defaultValue);
        }

        @Override
        public double average() {
            return ObjectByteHashMapWithHashingStrategy.this.average();
        }

        @Override
        public double median() {
            return ObjectByteHashMapWithHashingStrategy.this.median();
        }

        @Override
        public MutableByteCollection newEmpty() {
            return new ByteHashBag();
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectByteHashMapWithHashingStrategy.this.keys;
            while (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectByteHashMapWithHashingStrategy.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectByteHashMapWithHashingStrategy.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectByteHashMapWithHashingStrategy.this.removeKeyAtIndex(ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectByteHashMapWithHashingStrategy.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectByteHashMapWithHashingStrategy.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectByteHashMapWithHashingStrategy.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : ObjectByteHashMapWithHashingStrategy.this.hashingStrategy.computeHashCode(nonSentinelKey);
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectByteHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectByteHashMapWithHashingStrategy.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectByteHashMapWithHashingStrategy.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectByteHashMapWithHashingStrategy.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectByteHashMapWithHashingStrategy.this.size();
            ObjectByteHashMapWithHashingStrategy.this.removeKey(key);
            return oldSize != ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectByteHashMapWithHashingStrategy.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectByteHashMapWithHashingStrategy.this.size();
            Iterator iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                Object next = iterator2.next();
                if (collection.contains(next)) continue;
                iterator2.remove();
            }
            return oldSize != ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectByteHashMapWithHashingStrategy.this.size();
            for (Object object : collection) {
                ObjectByteHashMapWithHashingStrategy.this.removeKey(object);
            }
            return oldSize != ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public void clear() {
            ObjectByteHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectByteHashMapWithHashingStrategy.this.keys.length; ++i) {
                Object key = ObjectByteHashMapWithHashingStrategy.this.keys[i];
                if (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                result[count++] = ObjectByteHashMapWithHashingStrategy.this.keys[i];
            }
        }
    }

    private class InternalByteIterator
    implements MutableByteIterator {
        private int count;
        private int position;

        private InternalByteIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != ObjectByteHashMapWithHashingStrategy.this.size();
        }

        @Override
        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectByteHashMapWithHashingStrategy.this.keys;
            while (!ObjectByteHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = ObjectByteHashMapWithHashingStrategy.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (this.position == 0 || !ObjectByteHashMapWithHashingStrategy.isNonSentinel(ObjectByteHashMapWithHashingStrategy.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectByteHashMapWithHashingStrategy.this.remove(ObjectByteHashMapWithHashingStrategy.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

