/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.models.stream.StreamEntryDeletionResult;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.OutputFactory;
import io.lettuce.core.output.StreamingOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StreamEntryDeletionResultListOutput<K, V>
extends CommandOutput<K, V, List<StreamEntryDeletionResult>>
implements StreamingOutput<StreamEntryDeletionResult> {
    private boolean initialized;
    private StreamingOutput.Subscriber<StreamEntryDeletionResult> subscriber;

    public StreamEntryDeletionResultListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<StreamEntryDeletionResult>)ListSubscriber.instance());
    }

    @Override
    public void set(long integer) {
        if (!this.initialized) {
            this.multi(1);
        }
        StreamEntryDeletionResult result = StreamEntryDeletionResult.fromCode((int)integer);
        this.subscriber.onNext((Collection)this.output, result);
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<StreamEntryDeletionResult> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<StreamEntryDeletionResult> getSubscriber() {
        return this.subscriber;
    }
}

