/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.util;

import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.BitSet;

public class SearchUtils {
    public static final String MULTI_FIELD_KEY_DELIMITER = ":";
    public static final String REGEX_MATCH_DELIMITER = "\\:";
    public static final String ESCAPED_MULTI_FIELD_KEY_DELIMITER = "\\\\:";

    public static Object[] parseKey(HollowReadStateEngine readStateEngine, PrimaryKey primaryKey, String keyString) {
        String[] fields = keyString.split("(?<!\\\\):", primaryKey.numFields());
        Object[] key = new Object[fields.length];
        block9: for (int i = 0; i < fields.length; ++i) {
            switch (primaryKey.getFieldType(readStateEngine, i)) {
                case BOOLEAN: {
                    key[i] = Boolean.parseBoolean(fields[i]);
                    continue block9;
                }
                case STRING: {
                    key[i] = fields[i].replaceAll(ESCAPED_MULTI_FIELD_KEY_DELIMITER, MULTI_FIELD_KEY_DELIMITER);
                    continue block9;
                }
                case INT: 
                case REFERENCE: {
                    key[i] = Integer.parseInt(fields[i]);
                    continue block9;
                }
                case LONG: {
                    key[i] = Long.parseLong(fields[i]);
                    continue block9;
                }
                case DOUBLE: {
                    key[i] = Double.parseDouble(fields[i]);
                    continue block9;
                }
                case FLOAT: {
                    key[i] = Float.valueOf(Float.parseFloat(fields[i]));
                    continue block9;
                }
                case BYTES: {
                    throw new IllegalArgumentException("Primary key contains a field of type BYTES");
                }
            }
        }
        return key;
    }

    public static int[][] getFieldPathIndexes(HollowReadStateEngine readStateEngine, PrimaryKey primaryKey) {
        if (primaryKey != null) {
            int[][] fieldPathIndexes = new int[primaryKey.numFields()][];
            for (int i = 0; i < primaryKey.numFields(); ++i) {
                fieldPathIndexes[i] = primaryKey.getFieldPathIndex(readStateEngine, i);
            }
            return fieldPathIndexes;
        }
        return null;
    }

    public static HollowPrimaryKeyIndex findPrimaryKeyIndex(HollowTypeReadState typeState) {
        PrimaryKey pkey = SearchUtils.getPrimaryKey(typeState.getSchema());
        if (pkey == null) {
            return null;
        }
        for (HollowTypeStateListener listener : typeState.getListeners()) {
            if (!(listener instanceof HollowPrimaryKeyIndex) || !((HollowPrimaryKeyIndex)listener).getPrimaryKey().equals(pkey)) continue;
            return (HollowPrimaryKeyIndex)listener;
        }
        return null;
    }

    public static PrimaryKey getPrimaryKey(HollowSchema schema) {
        if (schema.getSchemaType() == HollowSchema.SchemaType.OBJECT) {
            return ((HollowObjectSchema)schema).getPrimaryKey();
        }
        return null;
    }

    public static Integer getOrdinalToDisplay(HollowReadStateEngine readStateEngine, String query, Object[] parsedKey, int ordinal, BitSet selectedOrdinals, int[][] fieldPathIndexes, HollowTypeReadState keyTypeState) {
        if ("".equals(query) && ordinal != -1) {
            return ordinal;
        }
        if (!"".equals(query)) {
            if (ordinal != -1 && selectedOrdinals.get(ordinal) && SearchUtils.recordKeyEquals(keyTypeState, ordinal, parsedKey, fieldPathIndexes)) {
                return ordinal;
            }
            HollowPrimaryKeyIndex idx = SearchUtils.findPrimaryKeyIndex(keyTypeState);
            if (idx != null) {
                return idx.getMatchingOrdinal(parsedKey);
            }
            ordinal = selectedOrdinals.nextSetBit(0);
            while (ordinal != -1) {
                if (SearchUtils.recordKeyEquals(keyTypeState, ordinal, parsedKey, fieldPathIndexes)) {
                    return ordinal;
                }
                ordinal = selectedOrdinals.nextSetBit(ordinal + 1);
            }
        }
        return -1;
    }

    private static boolean recordKeyEquals(HollowTypeReadState typeState, int ordinal, Object[] key, int[][] fieldPathIndexes) {
        HollowObjectTypeReadState objState = (HollowObjectTypeReadState)typeState;
        for (int i = 0; i < fieldPathIndexes.length; ++i) {
            int curOrdinal = ordinal;
            HollowObjectTypeReadState curState = objState;
            for (int j = 0; j < fieldPathIndexes[i].length - 1; ++j) {
                curOrdinal = curState.readOrdinal(curOrdinal, fieldPathIndexes[i][j]);
                curState = (HollowObjectTypeReadState)curState.getSchema().getReferencedTypeState(fieldPathIndexes[i][j]);
            }
            if (HollowReadFieldUtils.fieldValueEquals(curState, curOrdinal, fieldPathIndexes[i][fieldPathIndexes[i].length - 1], key[i])) continue;
            return false;
        }
        return true;
    }
}

