/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.split;

import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.tools.split.HollowSplitterCopyDirector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HollowSplitterPrimaryKeyCopyDirector
implements HollowSplitterCopyDirector {
    private final int numShards;
    private final List<String> topLevelTypes;
    private final Map<String, HollowPrimaryKeyValueDeriver> primaryKeyDeriverByType;

    public HollowSplitterPrimaryKeyCopyDirector(HollowReadStateEngine stateEngine, int numShards, PrimaryKey ... keys) {
        this.numShards = numShards;
        this.topLevelTypes = new ArrayList<String>(keys.length);
        this.primaryKeyDeriverByType = new HashMap<String, HollowPrimaryKeyValueDeriver>();
        for (int i = 0; i < keys.length; ++i) {
            this.topLevelTypes.add(keys[i].getType());
            HollowPrimaryKeyValueDeriver deriver = new HollowPrimaryKeyValueDeriver(keys[i], stateEngine);
            this.primaryKeyDeriverByType.put(keys[i].getType(), deriver);
        }
    }

    public void addReplicatedTypes(String ... replicatedTypes) {
        this.topLevelTypes.addAll(Arrays.asList(replicatedTypes));
    }

    @Override
    public String[] getTopLevelTypes() {
        return this.topLevelTypes.toArray(new String[this.topLevelTypes.size()]);
    }

    @Override
    public int getNumShards() {
        return this.numShards;
    }

    @Override
    public int getShard(HollowTypeReadState topLevelType, int ordinal) {
        HollowPrimaryKeyValueDeriver deriver = this.primaryKeyDeriverByType.get(topLevelType.getSchema().getName());
        if (deriver == null) {
            return -1;
        }
        Object[] key = deriver.getRecordKey(ordinal);
        return this.hashKey(topLevelType.getSchema().getName(), key) % this.numShards;
    }

    public int hashKey(String type, Object[] key) {
        return Arrays.hashCode(key);
    }
}

