/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.split;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.HollowWriteStateCreator;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.tools.split.HollowSplitterCopyDirector;
import com.netflix.hollow.tools.split.HollowSplitterShardCopier;
import java.util.List;

public class HollowSplitter {
    private final HollowReadStateEngine inputStateEngine;
    private final HollowWriteStateEngine[] outputStateEngines;
    private final HollowSplitterCopyDirector director;

    public HollowSplitter(HollowSplitterCopyDirector director, HollowReadStateEngine inputStateEngine) {
        this.inputStateEngine = inputStateEngine;
        this.outputStateEngines = new HollowWriteStateEngine[director.getNumShards()];
        this.director = director;
        List<HollowSchema> schemas = inputStateEngine.getSchemas();
        for (int i = 0; i < director.getNumShards(); ++i) {
            this.outputStateEngines[i] = HollowWriteStateCreator.createWithSchemas(schemas);
        }
    }

    public void split() {
        this.prepareForNextCycle();
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getNumberOfShards(), this.getClass(), "split");
        int i = 0;
        while (i < this.getNumberOfShards()) {
            final int shardNumber = i++;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    HollowSplitterShardCopier copier = new HollowSplitterShardCopier(HollowSplitter.this.inputStateEngine, HollowSplitter.this.outputStateEngines[shardNumber], HollowSplitter.this.director, shardNumber);
                    copier.copy();
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public HollowReadStateEngine getInputStateEngine() {
        return this.inputStateEngine;
    }

    public HollowWriteStateEngine getOutputShardStateEngine(int shardNumber) {
        return this.outputStateEngines[shardNumber];
    }

    public int getNumberOfShards() {
        return this.outputStateEngines.length;
    }

    private void prepareForNextCycle() {
        for (int i = 0; i < this.outputStateEngines.length; ++i) {
            this.outputStateEngines[i].prepareForNextCycle();
        }
    }
}

