/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.query;

import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class HollowFieldMatchQuery {
    private final HollowReadStateEngine readEngine;

    public HollowFieldMatchQuery(HollowReadStateEngine readEngine) {
        this.readEngine = readEngine;
    }

    public Map<String, BitSet> findMatchingRecords(String fieldName, String fieldValue) {
        HashMap<String, BitSet> matches = new HashMap<String, BitSet>();
        for (HollowTypeReadState typeState : this.readEngine.getTypeStates()) {
            this.augmentMatchingRecords(typeState, fieldName, fieldValue, matches);
        }
        return matches;
    }

    public Map<String, BitSet> findMatchingRecords(String typeName, String fieldName, String fieldValue) {
        HashMap<String, BitSet> matches = new HashMap<String, BitSet>();
        HollowTypeReadState typeState = this.readEngine.getTypeState(typeName);
        if (typeState != null) {
            this.augmentMatchingRecords(typeState, fieldName, fieldValue, matches);
        }
        return matches;
    }

    private void augmentMatchingRecords(HollowTypeReadState typeState, String fieldName, String fieldValue, Map<String, BitSet> matches) {
        if (typeState.getSchema().getSchemaType() == HollowSchema.SchemaType.OBJECT) {
            HollowObjectSchema schema = (HollowObjectSchema)typeState.getSchema();
            for (int i = 0; i < schema.numFields(); ++i) {
                if (!schema.getFieldName(i).equals(fieldName)) continue;
                HollowObjectTypeReadState objState = (HollowObjectTypeReadState)typeState;
                BitSet typeQueryMatches = null;
                if (schema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE) {
                    typeQueryMatches = this.attemptReferenceTraversalQuery(objState, i, fieldValue);
                } else {
                    Object queryValue = this.castQueryValue(fieldValue, schema.getFieldType(i));
                    if (queryValue != null) {
                        typeQueryMatches = this.queryBasedOnValueMatches(objState, i, queryValue);
                    }
                }
                if (typeQueryMatches == null || typeQueryMatches.cardinality() <= 0) continue;
                matches.put(typeState.getSchema().getName(), typeQueryMatches);
            }
        }
    }

    private BitSet attemptReferenceTraversalQuery(HollowObjectTypeReadState typeState, int fieldIdx, String fieldValue) {
        HollowObjectTypeReadState refObjTypeState;
        HollowObjectSchema refSchema;
        HollowTypeReadState referencedTypeState = typeState.getSchema().getReferencedTypeState(fieldIdx);
        if (referencedTypeState.getSchema().getSchemaType() == HollowSchema.SchemaType.OBJECT && (refSchema = (refObjTypeState = (HollowObjectTypeReadState)referencedTypeState).getSchema()).numFields() == 1) {
            if (refSchema.getFieldType(0) == HollowObjectSchema.FieldType.REFERENCE) {
                BitSet refQueryMatches = this.attemptReferenceTraversalQuery(refObjTypeState, 0, fieldValue);
                if (refQueryMatches != null) {
                    return this.queryBasedOnMatchedReferences(typeState, fieldIdx, refQueryMatches);
                }
            } else {
                BitSet refQueryMatches;
                Object queryValue = this.castQueryValue(fieldValue, refSchema.getFieldType(0));
                if (queryValue != null && (refQueryMatches = this.queryBasedOnValueMatches(refObjTypeState, 0, queryValue)).cardinality() > 0) {
                    return this.queryBasedOnMatchedReferences(typeState, fieldIdx, refQueryMatches);
                }
            }
        }
        return null;
    }

    private BitSet queryBasedOnMatchedReferences(HollowObjectTypeReadState typeState, int referenceFieldPosition, BitSet matchedReferences) {
        BitSet populatedOrdinals = typeState.getPopulatedOrdinals();
        BitSet typeQueryMatches = new BitSet(populatedOrdinals.length());
        int ordinal = populatedOrdinals.nextSetBit(0);
        while (ordinal != -1) {
            int refOrdinal = typeState.readOrdinal(ordinal, referenceFieldPosition);
            if (refOrdinal != -1 && matchedReferences.get(refOrdinal)) {
                typeQueryMatches.set(ordinal);
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal + 1);
        }
        return typeQueryMatches;
    }

    private BitSet queryBasedOnValueMatches(HollowObjectTypeReadState typeState, int fieldPosition, Object queryValue) {
        BitSet populatedOrdinals = typeState.getPopulatedOrdinals();
        BitSet typeQueryMatches = new BitSet(populatedOrdinals.length());
        int ordinal = populatedOrdinals.nextSetBit(0);
        while (ordinal != -1) {
            if (HollowReadFieldUtils.fieldValueEquals(typeState, ordinal, fieldPosition, queryValue)) {
                typeQueryMatches.set(ordinal);
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal + 1);
        }
        return typeQueryMatches;
    }

    private Object castQueryValue(String fieldValue, HollowObjectSchema.FieldType fieldType) {
        try {
            switch (fieldType) {
                case BOOLEAN: {
                    return Boolean.valueOf(fieldValue);
                }
                case DOUBLE: {
                    return Double.parseDouble(fieldValue);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(fieldValue));
                }
                case INT: {
                    return Integer.parseInt(fieldValue);
                }
                case LONG: {
                    return Long.parseLong(fieldValue);
                }
                case STRING: {
                    return fieldValue;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

