/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.patch.delta;

import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import java.util.HashMap;
import java.util.Map;

public class PartialOrdinalRemapper
implements OrdinalRemapper {
    private final Map<String, IntMap> ordinalMappings = new HashMap<String, IntMap>();

    public void addOrdinalRemapping(String typeName, IntMap mapping) {
        this.ordinalMappings.put(typeName, mapping);
    }

    public IntMap getOrdinalRemapping(String typeName) {
        return this.ordinalMappings.get(typeName);
    }

    @Override
    public int getMappedOrdinal(String type, int originalOrdinal) {
        int remappedOrdinal;
        IntMap mapping = this.ordinalMappings.get(type);
        if (mapping != null && (remappedOrdinal = mapping.get(originalOrdinal)) != -1) {
            return remappedOrdinal;
        }
        return originalOrdinal;
    }

    @Override
    public boolean ordinalIsMapped(String type, int originalOrdinal) {
        return true;
    }

    @Override
    public void remapOrdinal(String type, int originalOrdinal, int mappedOrdinal) {
        throw new UnsupportedOperationException("Cannot explicitly remap an ordinal in an IntMapOrdinalRemapper");
    }
}

