/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history;

import com.netflix.hollow.tools.history.HollowHistoricalStateDataAccess;
import com.netflix.hollow.tools.history.HollowHistoricalTypeDataAccess;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateKeyOrdinalMapping;
import java.util.Map;

public class HollowHistoricalState {
    private final long version;
    private final HollowHistoricalStateKeyOrdinalMapping keyOrdinalMapping;
    private final HollowHistoricalStateDataAccess dataAccess;
    private final Map<String, String> headerEntries;
    private HollowHistoricalState nextState;

    public HollowHistoricalState(long version, HollowHistoricalStateKeyOrdinalMapping keyOrdinalMapping, HollowHistoricalStateDataAccess dataAccess, Map<String, String> headerEntries) {
        this.version = version;
        this.dataAccess = dataAccess;
        this.keyOrdinalMapping = keyOrdinalMapping;
        this.headerEntries = headerEntries;
    }

    public long getVersion() {
        return this.version;
    }

    public HollowHistoricalStateDataAccess getDataAccess() {
        return this.dataAccess;
    }

    public HollowHistoricalStateKeyOrdinalMapping getKeyOrdinalMapping() {
        return this.keyOrdinalMapping;
    }

    public HollowHistoricalState getNextState() {
        return this.nextState;
    }

    public Map<String, String> getHeaderEntries() {
        return this.headerEntries;
    }

    void setNextState(HollowHistoricalState nextState) {
        this.nextState = nextState;
    }

    public long getApproximateHeapFootprintInBytes() {
        long total = 0L;
        for (HollowHistoricalTypeDataAccess typeDataAccess : this.dataAccess.getTypeDataAccessMap().values()) {
            total += typeDataAccess.removedRecords.getApproximateHeapFootprintInBytes();
        }
        return total;
    }
}

