/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSetSampler;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.SetMapKeyHasher;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.tools.history.HistoricalPrimaryKeyMatcher;
import com.netflix.hollow.tools.history.HollowHistoricalStateDataAccess;
import com.netflix.hollow.tools.history.HollowHistoricalTypeDataAccess;

public class HollowHistoricalSetDataAccess
extends HollowHistoricalTypeDataAccess
implements HollowSetTypeDataAccess {
    private HistoricalPrimaryKeyMatcher keyMatcher;

    public HollowHistoricalSetDataAccess(HollowHistoricalStateDataAccess dataAccess, HollowTypeReadState typeState) {
        super(dataAccess, typeState, new HollowSetSampler(typeState.getSchema().getName(), DisabledSamplingDirector.INSTANCE));
    }

    @Override
    public HollowSetSchema getSchema() {
        return this.removedRecords().getSchema();
    }

    @Override
    public int size(int ordinal) {
        this.sampler().recordSize();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowSetTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).size(ordinal);
        }
        return this.removedRecords().size(this.getMappedOrdinal(ordinal));
    }

    @Override
    public boolean contains(int ordinal, int value) {
        this.sampler().recordGet();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowSetTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).contains(ordinal, value);
        }
        return this.removedRecords().contains(this.getMappedOrdinal(ordinal), value);
    }

    @Override
    public int findElement(int ordinal, Object ... hashKey) {
        this.sampler().recordGet();
        this.recordStackTrace();
        if (this.keyMatcher == null) {
            return -1;
        }
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowSetTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).findElement(ordinal, hashKey);
        }
        ordinal = this.ordinalRemap.get(ordinal);
        HollowSetTypeReadState removedRecords = (HollowSetTypeReadState)this.getRemovedRecords();
        int hashTableSize = HashCodes.hashTableSize(removedRecords.size(ordinal));
        int hash = SetMapKeyHasher.hash(hashKey, this.keyMatcher.getFieldTypes());
        int bucket = hash & hashTableSize - 1;
        int bucketOrdinal = removedRecords.relativeBucketValue(ordinal, bucket);
        while (bucketOrdinal != -1) {
            if (this.keyMatcher.keyMatches(bucketOrdinal, hashKey)) {
                return bucketOrdinal;
            }
            ++bucket;
            bucketOrdinal = removedRecords.relativeBucketValue(ordinal, bucket &= hashTableSize - 1);
        }
        return -1;
    }

    @Override
    public boolean contains(int ordinal, int value, int hashCode) {
        this.sampler().recordGet();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowSetTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).contains(ordinal, value, hashCode);
        }
        return this.removedRecords().contains(this.getMappedOrdinal(ordinal), value, hashCode);
    }

    @Override
    public int relativeBucketValue(int ordinal, int bucketIndex) {
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowSetTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).relativeBucketValue(ordinal, bucketIndex);
        }
        return this.removedRecords().relativeBucketValue(this.getMappedOrdinal(ordinal), bucketIndex);
    }

    @Override
    public HollowOrdinalIterator potentialMatchOrdinalIterator(int ordinal, int hashCode) {
        this.sampler().recordIterator();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowSetTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).potentialMatchOrdinalIterator(ordinal, hashCode);
        }
        return this.removedRecords().potentialMatchOrdinalIterator(this.getMappedOrdinal(ordinal), hashCode);
    }

    @Override
    public HollowOrdinalIterator ordinalIterator(int ordinal) {
        this.sampler().recordIterator();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowSetTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).ordinalIterator(ordinal);
        }
        return this.removedRecords().ordinalIterator(this.getMappedOrdinal(ordinal));
    }

    private HollowSetTypeReadState removedRecords() {
        return (HollowSetTypeReadState)this.removedRecords;
    }

    private HollowSetSampler sampler() {
        return (HollowSetSampler)this.sampler;
    }

    void buildKeyMatcher() {
        PrimaryKey hashKey = this.getSchema().getHashKey();
        if (hashKey != null) {
            this.keyMatcher = new HistoricalPrimaryKeyMatcher(this.getDataAccess(), hashKey);
        }
    }
}

