/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.filter;

import com.netflix.hollow.core.HollowBlobHeader;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.HollowBlobHeaderReader;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadState;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.IOUtils;
import com.netflix.hollow.core.write.HollowBlobHeaderWriter;
import com.netflix.hollow.tools.filter.FilteredHollowBlobWriterStreamAndFilter;
import com.netflix.hollow.tools.filter.FixedLengthArrayWriter;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FilteredHollowBlobWriter {
    private final HollowFilterConfig[] configs;
    private final HollowBlobHeaderReader headerReader;
    private final HollowBlobHeaderWriter headerWriter;
    private final ArraySegmentRecycler memoryRecycler;
    private final Set<String> expectedTypes;

    public FilteredHollowBlobWriter(HollowFilterConfig ... configs) {
        this.configs = configs;
        this.headerReader = new HollowBlobHeaderReader();
        this.headerWriter = new HollowBlobHeaderWriter();
        this.memoryRecycler = WastefulRecycler.DEFAULT_INSTANCE;
        this.expectedTypes = new HashSet<String>();
        for (HollowFilterConfig config : configs) {
            this.expectedTypes.addAll(config.getSpecifiedTypes());
        }
    }

    public void filterSnapshot(InputStream in, OutputStream ... out) throws IOException {
        this.filter(false, in, out);
    }

    public void filterDelta(InputStream in, OutputStream ... out) throws IOException {
        this.filter(true, in, out);
    }

    public void filter(boolean delta, InputStream is, OutputStream ... out) throws IOException {
        HollowBlobInput in = HollowBlobInput.serial(is);
        FilteredHollowBlobWriterStreamAndFilter[] allStreamAndFilters = FilteredHollowBlobWriterStreamAndFilter.combine(out, this.configs);
        HollowBlobHeader header = this.headerReader.readHeader(in);
        List<HollowSchema> unfilteredSchemaList = header.getSchemas();
        for (FilteredHollowBlobWriterStreamAndFilter streamAndFilter : allStreamAndFilters) {
            List<HollowSchema> filteredSchemaList = this.getFilteredSchemaList(unfilteredSchemaList, streamAndFilter.getConfig());
            header.setSchemas(filteredSchemaList);
            this.headerWriter.writeHeader(header, streamAndFilter.getStream());
            VarInt.writeVInt(streamAndFilter.getStream(), filteredSchemaList.size());
        }
        int numStates = VarInt.readVInt(in);
        HashSet<String> encounteredTypes = new HashSet<String>();
        for (int i = 0; i < numStates; ++i) {
            HollowSchema schema = HollowSchema.readFrom(in);
            encounteredTypes.add(schema.getName());
            int numShards = this.readNumShards(in);
            FilteredHollowBlobWriterStreamAndFilter[] streamsWithType = FilteredHollowBlobWriterStreamAndFilter.withType(schema.getName(), allStreamAndFilters);
            if (schema instanceof HollowObjectSchema) {
                if (streamsWithType.length == 0) {
                    HollowObjectTypeReadState.discardType(in, (HollowObjectSchema)schema, numShards, delta);
                    continue;
                }
                this.copyFilteredObjectState(delta, in, streamsWithType, (HollowObjectSchema)schema, numShards);
                continue;
            }
            for (int j = 0; j < streamsWithType.length; ++j) {
                schema.writeTo(streamsWithType[j].getStream());
                VarInt.writeVInt(streamsWithType[j].getStream(), 1 + VarInt.sizeOfVInt(numShards));
                VarInt.writeVInt(streamsWithType[j].getStream(), 0);
                VarInt.writeVInt(streamsWithType[j].getStream(), numShards);
            }
            if (schema instanceof HollowListSchema) {
                if (streamsWithType.length == 0) {
                    HollowListTypeReadState.discardType(in, numShards, delta);
                    continue;
                }
                this.copyListState(delta, in, FilteredHollowBlobWriterStreamAndFilter.streamsOnly(streamsWithType), numShards);
                continue;
            }
            if (schema instanceof HollowSetSchema) {
                if (streamsWithType.length == 0) {
                    HollowSetTypeReadState.discardType(in, numShards, delta);
                    continue;
                }
                this.copySetState(delta, in, FilteredHollowBlobWriterStreamAndFilter.streamsOnly(streamsWithType), numShards);
                continue;
            }
            if (!(schema instanceof HollowMapSchema)) continue;
            if (streamsWithType.length == 0) {
                HollowMapTypeReadState.discardType(in, numShards, delta);
                continue;
            }
            this.copyMapState(delta, in, FilteredHollowBlobWriterStreamAndFilter.streamsOnly(streamsWithType), numShards);
        }
    }

    private int readNumShards(HollowBlobInput in) throws IOException {
        int backwardsCompatibilityBytes = VarInt.readVInt(in);
        if (backwardsCompatibilityBytes == 0) {
            return 1;
        }
        this.skipForwardsCompatibilityBytes(in);
        return VarInt.readVInt(in);
    }

    private void skipForwardsCompatibilityBytes(HollowBlobInput in) throws IOException {
        int skippedBytes;
        for (int bytesToSkip = VarInt.readVInt(in); bytesToSkip > 0; bytesToSkip -= skippedBytes) {
            skippedBytes = (int)in.skipBytes(bytesToSkip);
            if (skippedBytes >= 0) continue;
            throw new EOFException();
        }
    }

    private void copyFilteredObjectState(boolean delta, HollowBlobInput in, FilteredHollowBlobWriterStreamAndFilter[] streamAndFilters, HollowObjectSchema schema, int numShards) throws IOException {
        DataOutputStream[] os = FilteredHollowBlobWriterStreamAndFilter.streamsOnly(streamAndFilters);
        HollowObjectSchema[] filteredObjectSchemas = new HollowObjectSchema[os.length];
        for (int i = 0; i < streamAndFilters.length; ++i) {
            HollowObjectSchema filteredObjectSchema;
            filteredObjectSchemas[i] = filteredObjectSchema = this.getFilteredObjectSchema(schema, streamAndFilters[i].getConfig());
            filteredObjectSchema.writeTo(streamAndFilters[i].getStream());
            VarInt.writeVInt(streamAndFilters[i].getStream(), 1 + VarInt.sizeOfVInt(numShards));
            VarInt.writeVInt(streamAndFilters[i].getStream(), 0);
            VarInt.writeVInt(streamAndFilters[i].getStream(), numShards);
        }
        if (numShards > 1) {
            IOUtils.copyVInt(in, os);
        }
        for (int shard = 0; shard < numShards; ++shard) {
            int i;
            long bitsPerRecord;
            int maxShardOrdinal = IOUtils.copyVInt(in, os);
            int numRecordsToCopy = maxShardOrdinal + 1;
            if (delta) {
                GapEncodedVariableLengthIntegerReader.copyEncodedDeltaOrdinals(in, os);
                GapEncodedVariableLengthIntegerReader addedOrdinals = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
                numRecordsToCopy = addedOrdinals.remainingElements();
                for (DataOutputStream stream : os) {
                    addedOrdinals.writeTo(stream);
                }
            }
            int[] bitsPerField = new int[schema.numFields()];
            for (int i3 = 0; i3 < schema.numFields(); ++i3) {
                bitsPerField[i3] = VarInt.readVInt(in);
            }
            FixedLengthElementArray[] fixedLengthArraysPerStream = new FixedLengthElementArray[os.length];
            long[] bitsRequiredPerStream = new long[os.length];
            List[] fixedLengthArraysPerField = new List[schema.numFields()];
            for (int i2 = 0; i2 < fixedLengthArraysPerField.length; ++i2) {
                fixedLengthArraysPerField[i2] = new ArrayList();
            }
            for (int i2 = 0; i2 < streamAndFilters.length; ++i2) {
                bitsPerRecord = this.writeBitsPerField(schema, bitsPerField, filteredObjectSchemas[i2], streamAndFilters[i2].getStream());
                bitsRequiredPerStream[i2] = bitsPerRecord * (long)numRecordsToCopy;
                fixedLengthArraysPerStream[i2] = new FixedLengthElementArray(this.memoryRecycler, bitsRequiredPerStream[i2]);
                FixedLengthArrayWriter fixedLengthArrayWriter = new FixedLengthArrayWriter(fixedLengthArraysPerStream[i2]);
                for (int j = 0; j < schema.numFields(); ++j) {
                    if (filteredObjectSchemas[i2].getPosition(schema.getFieldName(j)) == -1) continue;
                    fixedLengthArraysPerField[j].add(fixedLengthArrayWriter);
                }
            }
            FixedLengthElementArray unfilteredFixedLengthFields = FixedLengthElementArray.newFrom(in, this.memoryRecycler);
            bitsPerRecord = 0L;
            for (int fieldBits : bitsPerField) {
                bitsPerRecord += (long)fieldBits;
            }
            long l = bitsPerRecord * (long)numRecordsToCopy;
            int fieldCursor = 0;
            for (long bitCursor = 0L; bitCursor < l; bitCursor += (long)bitsPerField[fieldCursor]) {
                if (fixedLengthArraysPerField[fieldCursor].isEmpty()) continue;
                long fieldValue = bitsPerField[fieldCursor] > 56 ? unfilteredFixedLengthFields.getLargeElementValue(bitCursor, bitsPerField[fieldCursor]) : unfilteredFixedLengthFields.getElementValue(bitCursor, bitsPerField[fieldCursor]);
                for (int i4 = 0; i4 < fixedLengthArraysPerField[fieldCursor].size(); ++i4) {
                    ((FixedLengthArrayWriter)fixedLengthArraysPerField[fieldCursor].get(i4)).writeField(fieldValue, bitsPerField[fieldCursor]);
                }
                if (++fieldCursor != schema.numFields()) continue;
                fieldCursor = 0;
            }
            for (i = 0; i < os.length; ++i) {
                long numLongsRequired = bitsRequiredPerStream[i] == 0L ? 0L : (bitsRequiredPerStream[i] - 1L) / 64L + 1L;
                fixedLengthArraysPerStream[i].writeTo(os[i], numLongsRequired);
            }
            for (i = 0; i < schema.numFields(); ++i) {
                ArrayList<DataOutputStream> streamsWithFieldList = new ArrayList<DataOutputStream>();
                for (int j = 0; j < streamAndFilters.length; ++j) {
                    HollowFilterConfig.ObjectFilterConfig objectTypeConfig = streamAndFilters[j].getConfig().getObjectTypeConfig(schema.getName());
                    if (!objectTypeConfig.includesField(schema.getFieldName(i))) continue;
                    streamsWithFieldList.add(streamAndFilters[j].getStream());
                }
                DataOutputStream[] streamsWithField = new DataOutputStream[streamsWithFieldList.size()];
                streamsWithField = streamsWithFieldList.toArray(streamsWithField);
                long numBytesInVarLengthData = IOUtils.copyVLong(in, streamsWithField);
                IOUtils.copyBytes(in, streamsWithField, numBytesInVarLengthData);
            }
        }
        if (!delta) {
            this.copySnapshotPopulatedOrdinals(in, os);
        }
    }

    private long writeBitsPerField(HollowObjectSchema unfilteredSchema, int[] bitsPerField, HollowObjectSchema filteredSchema, DataOutputStream os) throws IOException {
        long bitsPerRecord = 0L;
        for (int i = 0; i < unfilteredSchema.numFields(); ++i) {
            if (filteredSchema.getPosition(unfilteredSchema.getFieldName(i)) == -1) continue;
            VarInt.writeVInt(os, bitsPerField[i]);
            bitsPerRecord += (long)bitsPerField[i];
        }
        return bitsPerRecord;
    }

    private List<HollowSchema> getFilteredSchemaList(List<HollowSchema> schemaList, HollowFilterConfig filterConfig) {
        ArrayList<HollowSchema> filteredList = new ArrayList<HollowSchema>();
        for (HollowSchema schema : schemaList) {
            HollowSchema filteredSchema = this.getFilteredSchema(schema, filterConfig);
            if (filteredSchema == null) continue;
            filteredList.add(filteredSchema);
        }
        return filteredList;
    }

    private HollowSchema getFilteredSchema(HollowSchema schema, HollowFilterConfig filterConfig) {
        if (filterConfig.doesIncludeType(schema.getName())) {
            if (schema.getSchemaType() == HollowSchema.SchemaType.OBJECT) {
                return this.getFilteredObjectSchema((HollowObjectSchema)schema, filterConfig);
            }
            return schema;
        }
        return null;
    }

    private HollowObjectSchema getFilteredObjectSchema(HollowObjectSchema schema, HollowFilterConfig filterConfig) {
        HollowFilterConfig.ObjectFilterConfig typeConfig = filterConfig.getObjectTypeConfig(schema.getName());
        int numIncludedFields = 0;
        for (int i = 0; i < schema.numFields(); ++i) {
            if (!typeConfig.includesField(schema.getFieldName(i))) continue;
            ++numIncludedFields;
        }
        if (numIncludedFields == schema.numFields()) {
            return schema;
        }
        HollowObjectSchema filteredSchema = new HollowObjectSchema(schema.getName(), numIncludedFields, schema.getPrimaryKey());
        for (int i = 0; i < schema.numFields(); ++i) {
            if (!typeConfig.includesField(schema.getFieldName(i))) continue;
            filteredSchema.addField(schema.getFieldName(i), schema.getFieldType(i), schema.getReferencedType(i));
        }
        return filteredSchema;
    }

    private void copyListState(boolean delta, HollowBlobInput in, DataOutputStream[] os, int numShards) throws IOException {
        if (numShards > 1) {
            IOUtils.copyVInt(in, os);
        }
        for (int shard = 0; shard < numShards; ++shard) {
            IOUtils.copyVInt(in, os);
            if (delta) {
                GapEncodedVariableLengthIntegerReader.copyEncodedDeltaOrdinals(in, os);
                GapEncodedVariableLengthIntegerReader.copyEncodedDeltaOrdinals(in, os);
            }
            IOUtils.copyVInt(in, os);
            IOUtils.copyVInt(in, os);
            IOUtils.copyVLong(in, os);
            IOUtils.copySegmentedLongArray(in, os);
            IOUtils.copySegmentedLongArray(in, os);
        }
        if (!delta) {
            this.copySnapshotPopulatedOrdinals(in, os);
        }
    }

    private void copySetState(boolean delta, HollowBlobInput in, DataOutputStream[] os, int numShards) throws IOException {
        if (numShards > 1) {
            IOUtils.copyVInt(in, os);
        }
        for (int shard = 0; shard < numShards; ++shard) {
            IOUtils.copyVInt(in, os);
            if (delta) {
                GapEncodedVariableLengthIntegerReader.copyEncodedDeltaOrdinals(in, os);
                GapEncodedVariableLengthIntegerReader.copyEncodedDeltaOrdinals(in, os);
            }
            IOUtils.copyVInt(in, os);
            IOUtils.copyVInt(in, os);
            IOUtils.copyVInt(in, os);
            IOUtils.copyVLong(in, os);
            IOUtils.copySegmentedLongArray(in, os);
            IOUtils.copySegmentedLongArray(in, os);
        }
        if (!delta) {
            this.copySnapshotPopulatedOrdinals(in, os);
        }
    }

    private void copyMapState(boolean delta, HollowBlobInput in, DataOutputStream[] os, int numShards) throws IOException {
        if (numShards > 1) {
            IOUtils.copyVInt(in, os);
        }
        for (int shard = 0; shard < numShards; ++shard) {
            IOUtils.copyVInt(in, os);
            if (delta) {
                GapEncodedVariableLengthIntegerReader.copyEncodedDeltaOrdinals(in, os);
                GapEncodedVariableLengthIntegerReader.copyEncodedDeltaOrdinals(in, os);
            }
            IOUtils.copyVInt(in, os);
            IOUtils.copyVInt(in, os);
            IOUtils.copyVInt(in, os);
            IOUtils.copyVInt(in, os);
            IOUtils.copyVLong(in, os);
            IOUtils.copySegmentedLongArray(in, os);
            IOUtils.copySegmentedLongArray(in, os);
        }
        if (!delta) {
            this.copySnapshotPopulatedOrdinals(in, os);
        }
    }

    private void copySnapshotPopulatedOrdinals(HollowBlobInput in, DataOutputStream[] os) throws IOException {
        int numLongs = in.readInt();
        for (int i = 0; i < os.length; ++i) {
            os[i].writeInt(numLongs);
        }
        IOUtils.copyBytes(in, os, numLongs * 8);
    }
}

