/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.exact.mapper;

import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.util.LongList;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.tools.diff.exact.CombinedMatchPairResultsIterator;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalMap;
import java.util.BitSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicIntegerArray;

public abstract class DiffEqualityTypeMapper {
    protected final HollowTypeReadState fromState;
    protected final HollowTypeReadState toState;
    private final boolean oneToOne;

    protected DiffEqualityTypeMapper(HollowTypeReadState fromState, HollowTypeReadState toState, boolean oneToOne) {
        this.fromState = fromState;
        this.toState = toState;
        this.oneToOne = oneToOne;
    }

    public DiffEqualOrdinalMap mapEqualObjects() {
        int[] toOrdinalsHashed = this.hashToOrdinals();
        return this.mapMatchingFromOrdinals(toOrdinalsHashed);
    }

    protected int[] hashToOrdinals() {
        PopulatedOrdinalListener listener = this.toState.getListener(PopulatedOrdinalListener.class);
        BitSet toPopulatedOrdinals = listener.getPopulatedOrdinals();
        int ordinalSpaceLength = toPopulatedOrdinals.length();
        int hashedOrdinalsLength = 1 << 32 - Integer.numberOfLeadingZeros(toPopulatedOrdinals.cardinality() * 2 - 1);
        AtomicIntegerArray hashedToOrdinals = new AtomicIntegerArray(hashedOrdinalsLength);
        for (int i = 0; i < hashedOrdinalsLength; ++i) {
            hashedToOrdinals.set(i, -1);
        }
        SimultaneousExecutor executor = new SimultaneousExecutor(1.5, this.getClass(), "hash-to-ordinals");
        int numThreads = executor.getCorePoolSize();
        int i = 0;
        while (i < numThreads) {
            int threadNumber = i++;
            executor.execute(() -> {
                for (int t = threadNumber; t < ordinalSpaceLength; t += numThreads) {
                    int hashCode;
                    if (!toPopulatedOrdinals.get(t) || (hashCode = this.toRecordHashCode(t)) == -1) continue;
                    int bucket = hashCode & hashedToOrdinals.length() - 1;
                    while (!hashedToOrdinals.compareAndSet(bucket, -1, t)) {
                        bucket = bucket + 1 & hashedToOrdinals.length() - 1;
                    }
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        int[] arr = new int[hashedToOrdinals.length()];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = hashedToOrdinals.get(i2);
        }
        return arr;
    }

    protected DiffEqualOrdinalMap mapMatchingFromOrdinals(int[] hashedToOrdinals) {
        PopulatedOrdinalListener listener = this.fromState.getListener(PopulatedOrdinalListener.class);
        BitSet fromPopulatedOrdinals = listener.getPopulatedOrdinals();
        int ordinalSpaceLength = fromPopulatedOrdinals.length();
        SimultaneousExecutor executor = new SimultaneousExecutor(1.5, this.getClass(), "map-matching-from-ordinals");
        int numThreads = executor.getCorePoolSize();
        LongList[] matchPairResults = new LongList[numThreads];
        int i = 0;
        while (i < numThreads) {
            int threadNumber = i++;
            matchPairResults[threadNumber] = new LongList();
            executor.execute(() -> {
                EqualityDeterminer equalityDeterminer = this.getEqualityDeterminer();
                for (int t = threadNumber; t < ordinalSpaceLength; t += numThreads) {
                    int hashCode;
                    if (!fromPopulatedOrdinals.get(t) || (hashCode = this.fromRecordHashCode(t)) == -1) continue;
                    int bucket = hashCode & hashedToOrdinals.length - 1;
                    while (hashedToOrdinals[bucket] != -1) {
                        if (equalityDeterminer.recordsAreEqual(t, hashedToOrdinals[bucket])) {
                            matchPairResults[threadNumber].add((long)t << 32 | (long)hashedToOrdinals[bucket]);
                        }
                        bucket = bucket + 1 & hashedToOrdinals.length - 1;
                    }
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        int numMatches = 0;
        for (int i2 = 0; i2 < matchPairResults.length; ++i2) {
            numMatches += matchPairResults[i2].size();
        }
        CombinedMatchPairResultsIterator resultsIterator = new CombinedMatchPairResultsIterator(matchPairResults);
        DiffEqualOrdinalMap ordinalMap = new DiffEqualOrdinalMap(numMatches);
        if (this.oneToOne) {
            BitSet alreadyMappedToOrdinals = new BitSet(this.toState.maxOrdinal() + 1);
            block4: while (resultsIterator.next()) {
                int fromOrdinal = resultsIterator.fromOrdinal();
                IntList toOrdinals = resultsIterator.toOrdinals();
                for (int i3 = 0; i3 < toOrdinals.size(); ++i3) {
                    if (alreadyMappedToOrdinals.get(toOrdinals.get(i3))) continue;
                    alreadyMappedToOrdinals.set(toOrdinals.get(i3));
                    ordinalMap.putEqualOrdinal(fromOrdinal, toOrdinals.get(i3));
                    continue block4;
                }
            }
        } else {
            while (resultsIterator.next()) {
                ordinalMap.putEqualOrdinals(resultsIterator.fromOrdinal(), resultsIterator.toOrdinals());
            }
        }
        return ordinalMap;
    }

    public abstract boolean requiresTraversalForMissingFields();

    protected abstract int fromRecordHashCode(int var1);

    protected abstract int toRecordHashCode(int var1);

    protected abstract EqualityDeterminer getEqualityDeterminer();

    protected static interface EqualityDeterminer {
        public boolean recordsAreEqual(int var1, int var2);
    }
}

