/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.exact.mapper;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalMap;
import com.netflix.hollow.tools.diff.exact.DiffEqualityMapping;
import com.netflix.hollow.tools.diff.exact.mapper.DiffEqualityTypeMapper;

public class DiffEqualityMapMapper
extends DiffEqualityTypeMapper {
    private final DiffEqualOrdinalMap keyEqualOrdinalMap;
    private final DiffEqualOrdinalMap valueEqualOrdinalMap;
    private final boolean requiresTraversalForMissingFields;

    public DiffEqualityMapMapper(DiffEqualityMapping mapping, HollowMapTypeReadState fromState, HollowMapTypeReadState toState, boolean oneToOne) {
        super(fromState, toState, oneToOne);
        HollowMapSchema schema = fromState.getSchema();
        this.keyEqualOrdinalMap = mapping.getEqualOrdinalMap(schema.getKeyType());
        this.valueEqualOrdinalMap = mapping.getEqualOrdinalMap(schema.getValueType());
        this.requiresTraversalForMissingFields = mapping.requiresMissingFieldTraversal(schema.getKeyType()) || mapping.requiresMissingFieldTraversal(schema.getValueType());
    }

    @Override
    public boolean requiresTraversalForMissingFields() {
        return this.requiresTraversalForMissingFields;
    }

    @Override
    protected int fromRecordHashCode(int ordinal) {
        return this.recordHashCode(this.fromState(), ordinal, this.keyEqualOrdinalMap.getFromOrdinalIdentityTranslator(), this.valueEqualOrdinalMap.getFromOrdinalIdentityTranslator());
    }

    @Override
    protected int toRecordHashCode(int ordinal) {
        return this.recordHashCode(this.toState(), ordinal, this.keyEqualOrdinalMap.getToOrdinalIdentityTranslator(), this.valueEqualOrdinalMap.getToOrdinalIdentityTranslator());
    }

    private int recordHashCode(HollowMapTypeReadState typeState, int ordinal, DiffEqualOrdinalMap.OrdinalIdentityTranslator keyTranslator, DiffEqualOrdinalMap.OrdinalIdentityTranslator valueTranslator) {
        HollowMapEntryOrdinalIterator iter = typeState.ordinalIterator(ordinal);
        int hashCode = 0;
        while (iter.next()) {
            int keyIdentityOrdinal = keyTranslator.getIdentityOrdinal(iter.getKey());
            int valueIdentityOrdinal = valueTranslator.getIdentityOrdinal(iter.getValue());
            if (keyIdentityOrdinal == -1 && iter.getKey() != -1) {
                return -1;
            }
            if (valueIdentityOrdinal == -1 && iter.getValue() != -1) {
                return -1;
            }
            hashCode ^= HashCodes.hashInt(keyIdentityOrdinal + 31 * valueIdentityOrdinal);
        }
        return hashCode;
    }

    @Override
    protected DiffEqualityTypeMapper.EqualityDeterminer getEqualityDeterminer() {
        return new DiffEqualityTypeMapper.EqualityDeterminer(){
            private final IntList fromKeysIntList = new IntList();
            private final IntList fromValuesIntList = new IntList();
            private final IntList toKeysIntList = new IntList();
            private final IntList toValuesIntList = new IntList();

            @Override
            public boolean recordsAreEqual(int fromOrdinal, int toOrdinal) {
                if (!this.populateIntLists(this.fromKeysIntList, this.fromValuesIntList, DiffEqualityMapMapper.this.fromState().ordinalIterator(fromOrdinal), DiffEqualityMapMapper.this.keyEqualOrdinalMap.getFromOrdinalIdentityTranslator(), DiffEqualityMapMapper.this.valueEqualOrdinalMap.getFromOrdinalIdentityTranslator())) {
                    return false;
                }
                if (!this.populateIntLists(this.toKeysIntList, this.toValuesIntList, DiffEqualityMapMapper.this.toState().ordinalIterator(toOrdinal), DiffEqualityMapMapper.this.keyEqualOrdinalMap.getToOrdinalIdentityTranslator(), DiffEqualityMapMapper.this.valueEqualOrdinalMap.getToOrdinalIdentityTranslator())) {
                    return false;
                }
                return this.fromKeysIntList.equals(this.toKeysIntList) && this.fromValuesIntList.equals(this.toValuesIntList);
            }

            private boolean populateIntLists(IntList keysList, IntList valuesList, HollowMapEntryOrdinalIterator iter, DiffEqualOrdinalMap.OrdinalIdentityTranslator keyTranslator, DiffEqualOrdinalMap.OrdinalIdentityTranslator valueTranslator) {
                keysList.clear();
                valuesList.clear();
                while (iter.next()) {
                    int keyIdentity = keyTranslator.getIdentityOrdinal(iter.getKey());
                    int valueIdentity = valueTranslator.getIdentityOrdinal(iter.getValue());
                    if (keyIdentity == -1 && iter.getKey() != -1) {
                        return false;
                    }
                    if (valueIdentity == -1 && iter.getValue() != -1) {
                        return false;
                    }
                    keysList.add(keyTranslator.getIdentityOrdinal(iter.getKey()));
                    valuesList.add(valueTranslator.getIdentityOrdinal(iter.getValue()));
                }
                keysList.sort();
                valuesList.sort();
                return true;
            }
        };
    }

    private HollowMapTypeReadState fromState() {
        return (HollowMapTypeReadState)this.fromState;
    }

    private HollowMapTypeReadState toState() {
        return (HollowMapTypeReadState)this.toState;
    }
}

