/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.exact;

import com.netflix.hollow.core.read.engine.HollowCollectionTypeReadState;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadState;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalMap;
import com.netflix.hollow.tools.diff.exact.mapper.DiffEqualityCollectionMapper;
import com.netflix.hollow.tools.diff.exact.mapper.DiffEqualityMapMapper;
import com.netflix.hollow.tools.diff.exact.mapper.DiffEqualityObjectMapper;
import com.netflix.hollow.tools.diff.exact.mapper.DiffEqualityOrderedListMapper;
import com.netflix.hollow.tools.diff.exact.mapper.DiffEqualityTypeMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DiffEqualityMapping {
    private final Logger log = Logger.getLogger(DiffEqualityMapping.class.getName());
    private final HollowReadStateEngine fromState;
    private final HollowReadStateEngine toState;
    private final boolean oneToOne;
    private final boolean listOrderingIsImportant;
    private final Map<String, DiffEqualOrdinalMap> map = new HashMap<String, DiffEqualOrdinalMap>();
    private final Set<String> typesWhichRequireMissingFieldTraversal = new HashSet<String>();
    private boolean isPrepared;

    public DiffEqualityMapping(HollowReadStateEngine fromState, HollowReadStateEngine toState) {
        this(fromState, toState, false, true);
    }

    public DiffEqualityMapping(HollowReadStateEngine fromState, HollowReadStateEngine toState, boolean oneToOne, boolean listOrderingIsImportant) {
        this.fromState = fromState;
        this.toState = toState;
        this.oneToOne = oneToOne;
        this.listOrderingIsImportant = listOrderingIsImportant;
    }

    public boolean requiresMissingFieldTraversal(String type) {
        return this.typesWhichRequireMissingFieldTraversal.contains(type);
    }

    public DiffEqualOrdinalMap getEqualOrdinalMap(String type) {
        DiffEqualOrdinalMap ordinalMap = this.map.get(type);
        if (ordinalMap != null) {
            return ordinalMap;
        }
        return this.isPrepared ? DiffEqualOrdinalMap.EMPTY_MAP : this.buildMap(type);
    }

    public void markPrepared() {
        this.isPrepared = true;
    }

    private DiffEqualOrdinalMap buildMap(String type) {
        HollowTypeReadState fromTypeState = this.fromState.getTypeState(type);
        HollowTypeReadState toTypeState = this.toState.getTypeState(type);
        if (fromTypeState == null || toTypeState == null) {
            return DiffEqualOrdinalMap.EMPTY_MAP;
        }
        this.log.info("starting to build equality map for " + type);
        DiffEqualOrdinalMap map = this.buildMap(fromTypeState, toTypeState);
        this.log.info("finished building equality map for " + type);
        return map;
    }

    private DiffEqualOrdinalMap buildMap(HollowTypeReadState fromTypeState, HollowTypeReadState toTypeState) {
        String typeName = fromTypeState.getSchema().getName();
        DiffEqualityTypeMapper mapper = this.getTypeMapper(fromTypeState, toTypeState);
        DiffEqualOrdinalMap equalOrdinalMap = mapper.mapEqualObjects();
        if (mapper.requiresTraversalForMissingFields()) {
            this.typesWhichRequireMissingFieldTraversal.add(fromTypeState.getSchema().getName());
        }
        equalOrdinalMap.buildToOrdinalIdentityMapping();
        this.map.put(typeName, equalOrdinalMap);
        return equalOrdinalMap;
    }

    private DiffEqualityTypeMapper getTypeMapper(HollowTypeReadState fromState, HollowTypeReadState toState) {
        if (fromState instanceof HollowObjectTypeReadState) {
            return new DiffEqualityObjectMapper(this, (HollowObjectTypeReadState)fromState, (HollowObjectTypeReadState)toState, this.oneToOne);
        }
        if (this.listOrderingIsImportant && fromState instanceof HollowListTypeReadState) {
            return new DiffEqualityOrderedListMapper(this, (HollowListTypeReadState)fromState, (HollowListTypeReadState)toState, this.oneToOne);
        }
        if (fromState instanceof HollowCollectionTypeReadState) {
            return new DiffEqualityCollectionMapper(this, (HollowCollectionTypeReadState)fromState, (HollowCollectionTypeReadState)toState, this.oneToOne);
        }
        if (fromState instanceof HollowMapTypeReadState) {
            return new DiffEqualityMapMapper(this, (HollowMapTypeReadState)fromState, (HollowMapTypeReadState)toState, this.oneToOne);
        }
        throw new IllegalArgumentException("I don't know how to map equality for a " + fromState.getClass().getName());
    }
}

