/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.count;

import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.HollowDiff;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.tools.diff.count.HollowDiffCountingNode;
import com.netflix.hollow.tools.diff.count.HollowFieldDiff;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class HollowDiffFieldCountingNode
extends HollowDiffCountingNode {
    private final HollowObjectTypeReadState fromState;
    private final HollowObjectTypeReadState toState;
    private final int fromFieldIndex;
    private final int toFieldIndex;
    private int[] hashedOrdinals;
    private int[] ordinalHashCodes;
    private int[] ordinalHashCounts;
    private int hashSizeBeforeGrow;
    private int hashSize;
    private int currentTopLevelFromOrdinal;
    private int currentTopLevelToOrdinal;
    private int unmatchedToFields;
    private final HollowFieldDiff fieldDiff;

    public HollowDiffFieldCountingNode(HollowDiff diff, HollowTypeDiff topLevelTypeDiff, HollowDiffNodeIdentifier nodeId, HollowObjectTypeReadState fromState, HollowObjectTypeReadState toState, HollowObjectSchema unionSchema, int unionFieldIndex) {
        super(diff, topLevelTypeDiff, nodeId);
        this.fromState = fromState;
        this.toState = toState;
        String fieldName = unionSchema.getFieldName(unionFieldIndex);
        this.fromFieldIndex = fromState == null ? -1 : fromState.getSchema().getPosition(fieldName);
        this.toFieldIndex = toState == null ? -1 : toState.getSchema().getPosition(fieldName);
        this.fieldDiff = new HollowFieldDiff(nodeId);
        this.hashedOrdinals = new int[16];
        this.ordinalHashCodes = new int[16];
        this.ordinalHashCounts = new int[16];
        this.hashSizeBeforeGrow = 11;
        Arrays.fill(this.hashedOrdinals, -1);
    }

    @Override
    public void prepare(int topLevelFromOrdinal, int topLevelToOrdinal) {
        this.currentTopLevelFromOrdinal = topLevelFromOrdinal;
        this.currentTopLevelToOrdinal = topLevelToOrdinal;
    }

    @Override
    public int traverseDiffs(IntList fromOrdinals, IntList toOrdinals) {
        int i;
        if (this.fromFieldIndex == -1 || this.toFieldIndex == -1) {
            return this.traverseMissingFields(fromOrdinals, toOrdinals);
        }
        this.clearHashTable();
        for (i = 0; i < fromOrdinals.size(); ++i) {
            this.indexFromOrdinal(fromOrdinals.get(i));
        }
        for (i = 0; i < toOrdinals.size(); ++i) {
            this.compareToOrdinal(toOrdinals.get(i));
        }
        int score = this.unmatchedToFields;
        for (int i2 = 0; i2 < this.ordinalHashCounts.length; ++i2) {
            score += this.ordinalHashCounts[i2];
        }
        if (score != 0) {
            this.fieldDiff.addDiff(this.currentTopLevelFromOrdinal, this.currentTopLevelToOrdinal, score);
        }
        return score;
    }

    @Override
    public int traverseMissingFields(IntList fromOrdinals, IntList toOrdinals) {
        if (this.fromFieldIndex == -1) {
            this.fieldDiff.addDiff(this.currentTopLevelFromOrdinal, this.currentTopLevelToOrdinal, toOrdinals.size());
            return toOrdinals.size();
        }
        if (this.toFieldIndex == -1) {
            this.fieldDiff.addDiff(this.currentTopLevelFromOrdinal, this.currentTopLevelToOrdinal, fromOrdinals.size());
            return fromOrdinals.size();
        }
        return 0;
    }

    private void clearHashTable() {
        Arrays.fill(this.hashedOrdinals, -1);
        Arrays.fill(this.ordinalHashCounts, 0);
        this.unmatchedToFields = 0;
        this.hashSize = 0;
    }

    private void indexFromOrdinal(int ordinal) {
        int hashCode;
        if (this.hashSize == this.hashSizeBeforeGrow) {
            this.growHashTable();
        }
        if (this.hashIntoArray(ordinal, hashCode = HollowReadFieldUtils.fieldHashCode(this.fromState, ordinal, this.fromFieldIndex), 1, this.hashedOrdinals, this.ordinalHashCodes, this.ordinalHashCounts)) {
            ++this.hashSize;
        }
    }

    private void compareToOrdinal(int ordinal) {
        int hashCode = HollowReadFieldUtils.fieldHashCode(this.toState, ordinal, this.toFieldIndex);
        int bucket = hashCode & this.hashedOrdinals.length - 1;
        while (this.hashedOrdinals[bucket] != -1) {
            if (HollowReadFieldUtils.fieldsAreEqual(this.fromState, this.hashedOrdinals[bucket], this.fromFieldIndex, this.toState, ordinal, this.toFieldIndex)) {
                if (this.ordinalHashCounts[bucket] > 0) {
                    int n = bucket;
                    this.ordinalHashCounts[n] = this.ordinalHashCounts[n] - 1;
                } else {
                    ++this.unmatchedToFields;
                }
                return;
            }
            bucket = bucket + 1 & this.hashedOrdinals.length - 1;
        }
        ++this.unmatchedToFields;
    }

    private void growHashTable() {
        int[] newHashedOrdinals = new int[this.hashedOrdinals.length * 2];
        int[] newOrdinalHashCodes = new int[this.ordinalHashCodes.length * 2];
        int[] newOrdinalHashCodeCounts = new int[this.ordinalHashCounts.length * 2];
        Arrays.fill(newHashedOrdinals, -1);
        long[] ordinalsAndHashCodes = this.ordinalsAndHashCodes();
        for (int i = 0; i < ordinalsAndHashCodes.length; ++i) {
            int hashOrdinal = (int)(ordinalsAndHashCodes[i] >> 32);
            int hashCode = (int)ordinalsAndHashCodes[i];
            int hashCount = this.findOrdinalCount(hashOrdinal, hashCode);
            this.hashIntoArray(hashOrdinal, hashCode, hashCount, newHashedOrdinals, newOrdinalHashCodes, newOrdinalHashCodeCounts);
        }
        this.hashedOrdinals = newHashedOrdinals;
        this.ordinalHashCodes = newOrdinalHashCodes;
        this.ordinalHashCounts = newOrdinalHashCodeCounts;
        this.hashSizeBeforeGrow = newHashedOrdinals.length * 7 / 10;
    }

    private long[] ordinalsAndHashCodes() {
        long[] ordinalsAndHashCodes = new long[this.hashSize];
        int count = 0;
        for (int i = 0; i < this.hashedOrdinals.length; ++i) {
            if (this.hashedOrdinals[i] == -1) continue;
            ordinalsAndHashCodes[count++] = (long)this.hashedOrdinals[i] << 32 | (long)this.ordinalHashCodes[i] & 0xFFFFFFFFL;
        }
        Arrays.sort(ordinalsAndHashCodes);
        return ordinalsAndHashCodes;
    }

    private int findOrdinalCount(int ordinal, int hashCode) {
        int bucket = hashCode & this.hashedOrdinals.length - 1;
        while (this.hashedOrdinals[bucket] != ordinal) {
            bucket = bucket + 1 & this.hashedOrdinals.length - 1;
        }
        return this.ordinalHashCounts[bucket];
    }

    private boolean hashIntoArray(int ordinal, int hashCode, int count, int[] hashedOrdinals, int[] ordinalHashCodes, int[] ordinalHashCounts) {
        int bucket = hashCode & hashedOrdinals.length - 1;
        while (hashedOrdinals[bucket] != -1) {
            if (HollowReadFieldUtils.fieldsAreEqual(this.fromState, hashedOrdinals[bucket], this.fromFieldIndex, this.fromState, ordinal, this.fromFieldIndex)) {
                int n = bucket;
                ordinalHashCounts[n] = ordinalHashCounts[n] + 1;
                return false;
            }
            bucket = bucket + 1 & hashedOrdinals.length - 1;
        }
        hashedOrdinals[bucket] = ordinal;
        ordinalHashCodes[bucket] = hashCode;
        ordinalHashCounts[bucket] = count;
        return true;
    }

    @Override
    public List<HollowFieldDiff> getFieldDiffs() {
        if (this.fieldDiff.getTotalDiffScore() > 0L) {
            return Collections.singletonList(this.fieldDiff);
        }
        return Collections.emptyList();
    }
}

