/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.count;

import com.netflix.hollow.core.read.engine.HollowCollectionTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.HollowDiff;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.tools.diff.count.HollowDiffCountingNode;
import com.netflix.hollow.tools.diff.count.HollowFieldDiff;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalFilter;
import java.util.List;

public class HollowDiffCollectionCountingNode
extends HollowDiffCountingNode {
    private final HollowCollectionTypeReadState fromState;
    private final HollowCollectionTypeReadState toState;
    private final HollowDiffCountingNode elementNode;
    private final DiffEqualOrdinalFilter referenceFilter;
    private final boolean requiresTraversalForMissingFields;
    private final IntList traversalFromOrdinals = new IntList();
    private final IntList traversalToOrdinals = new IntList();

    public HollowDiffCollectionCountingNode(HollowDiff diff, HollowTypeDiff topLevelTypeDiff, HollowDiffNodeIdentifier nodeId, HollowCollectionTypeReadState fromState, HollowCollectionTypeReadState toState) {
        super(diff, topLevelTypeDiff, nodeId);
        this.fromState = fromState;
        this.toState = toState;
        HollowTypeReadState refFromState = fromState == null ? null : fromState.getSchema().getElementTypeState();
        HollowTypeReadState refToState = toState == null ? null : toState.getSchema().getElementTypeState();
        String referencedType = fromState == null ? toState.getSchema().getElementType() : fromState.getSchema().getElementType();
        this.elementNode = this.getHollowDiffCountingNode(refFromState, refToState, "element");
        this.referenceFilter = new DiffEqualOrdinalFilter(this.equalityMapping.getEqualOrdinalMap(referencedType));
        this.requiresTraversalForMissingFields = this.equalityMapping.requiresMissingFieldTraversal(referencedType);
    }

    @Override
    public void prepare(int topLevelFromOrdinal, int topLevelToOrdinal) {
        this.elementNode.prepare(topLevelFromOrdinal, topLevelToOrdinal);
    }

    @Override
    public List<HollowFieldDiff> getFieldDiffs() {
        return this.elementNode.getFieldDiffs();
    }

    @Override
    public int traverseDiffs(IntList fromOrdinals, IntList toOrdinals) {
        this.fillTraversalLists(fromOrdinals, toOrdinals);
        this.referenceFilter.filter(this.traversalFromOrdinals, this.traversalToOrdinals);
        int score = 0;
        if (this.referenceFilter.getUnmatchedFromOrdinals().size() != 0 || this.referenceFilter.getUnmatchedToOrdinals().size() != 0) {
            score += this.elementNode.traverseDiffs(this.referenceFilter.getUnmatchedFromOrdinals(), this.referenceFilter.getUnmatchedToOrdinals());
        }
        if (this.requiresTraversalForMissingFields && (this.referenceFilter.getMatchedFromOrdinals().size() != 0 || this.referenceFilter.getMatchedToOrdinals().size() != 0)) {
            score += this.elementNode.traverseMissingFields(this.referenceFilter.getMatchedFromOrdinals(), this.referenceFilter.getMatchedToOrdinals());
        }
        return score;
    }

    @Override
    public int traverseMissingFields(IntList fromOrdinals, IntList toOrdinals) {
        this.fillTraversalLists(fromOrdinals, toOrdinals);
        return this.elementNode.traverseMissingFields(this.traversalFromOrdinals, this.traversalToOrdinals);
    }

    private void fillTraversalLists(IntList fromOrdinals, IntList toOrdinals) {
        int i;
        this.traversalFromOrdinals.clear();
        this.traversalToOrdinals.clear();
        if (this.fromState != null) {
            for (i = 0; i < fromOrdinals.size(); ++i) {
                this.fillListWithReferencedOrdinals(this.fromState, fromOrdinals.get(i), this.traversalFromOrdinals);
            }
        }
        if (this.toState != null) {
            for (i = 0; i < toOrdinals.size(); ++i) {
                this.fillListWithReferencedOrdinals(this.toState, toOrdinals.get(i), this.traversalToOrdinals);
            }
        }
    }

    private void fillListWithReferencedOrdinals(HollowCollectionTypeReadState typeState, int ordinal, IntList fillList) {
        HollowOrdinalIterator iter = typeState.ordinalIterator(ordinal);
        int refOrdinal = iter.next();
        while (refOrdinal != Integer.MAX_VALUE) {
            fillList.add(refOrdinal);
            refOrdinal = iter.next();
        }
    }
}

