/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.tools.diff.exact.DiffEqualityMapping;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

public class HollowDiff {
    private final EnumSet<HollowObjectSchema.FieldType> SINGLE_FIELD_SUPPORTED_TYPES = EnumSet.of(HollowObjectSchema.FieldType.INT, new HollowObjectSchema.FieldType[]{HollowObjectSchema.FieldType.LONG, HollowObjectSchema.FieldType.DOUBLE, HollowObjectSchema.FieldType.STRING, HollowObjectSchema.FieldType.FLOAT, HollowObjectSchema.FieldType.BOOLEAN});
    private final Logger log = Logger.getLogger(HollowDiff.class.getName());
    private final HollowReadStateEngine fromStateEngine;
    private final HollowReadStateEngine toStateEngine;
    private final DiffEqualityMapping equalityMapping;
    private final Map<String, HollowTypeDiff> typeDiffs = new LinkedHashMap<String, HollowTypeDiff>();

    public HollowDiff(HollowReadStateEngine from, HollowReadStateEngine to) {
        this(from, to, true, false);
    }

    public HollowDiff(HollowReadStateEngine from, HollowReadStateEngine to, boolean isAutoDiscoverTypeDiff) {
        this(from, to, isAutoDiscoverTypeDiff, false);
    }

    public HollowDiff(HollowReadStateEngine from, HollowReadStateEngine to, boolean isAutoDiscoverTypeDiff, boolean isIncludeNonPrimaryKeyTypes) {
        this.fromStateEngine = from;
        this.toStateEngine = to;
        this.equalityMapping = new DiffEqualityMapping(from, to);
        if (isAutoDiscoverTypeDiff) {
            ArrayList<HollowSchema> schemas = new ArrayList<HollowSchema>();
            schemas.addAll(this.fromStateEngine.getSchemas());
            schemas.addAll(this.toStateEngine.getSchemas());
            for (HollowSchema schema : schemas) {
                HollowObjectSchema objectSchema;
                PrimaryKey pKey;
                if (!(schema instanceof HollowObjectSchema) || (pKey = (objectSchema = (HollowObjectSchema)schema).getPrimaryKey()) == null && !isIncludeNonPrimaryKeyTypes) continue;
                if (pKey == null && objectSchema.numFields() == 1 && this.SINGLE_FIELD_SUPPORTED_TYPES.contains((Object)objectSchema.getFieldType(0))) {
                    pKey = new PrimaryKey(schema.getName(), objectSchema.getFieldName(0));
                }
                this.addTypeDiff(schema.getName(), pKey == null ? null : pKey.getFieldPaths());
            }
        }
    }

    public HollowTypeDiff addTypeDiff(String type, String ... primaryKeyPaths) {
        HollowTypeDiff typeDiff = new HollowTypeDiff(this, type, primaryKeyPaths);
        if (typeDiff.hasAnyData()) {
            this.typeDiffs.put(type, typeDiff);
        }
        return typeDiff;
    }

    public List<HollowTypeDiff> getTypeDiffs() {
        return new ArrayList<HollowTypeDiff>(this.typeDiffs.values());
    }

    public HollowTypeDiff getTypeDiff(String type) {
        return this.typeDiffs.get(type);
    }

    public HollowReadStateEngine getFromStateEngine() {
        return this.fromStateEngine;
    }

    public HollowReadStateEngine getToStateEngine() {
        return this.toStateEngine;
    }

    public void calculateDiffs() {
        long startTime = System.currentTimeMillis();
        this.prepareForDiffCalculation();
        long endTime = System.currentTimeMillis();
        this.log.info("PREPARED IN " + (endTime - startTime) + "ms");
        for (HollowTypeDiff typeDiff : this.typeDiffs.values()) {
            typeDiff.calculateDiffs();
        }
    }

    public DiffEqualityMapping getEqualityMapping() {
        return this.equalityMapping;
    }

    private void prepareForDiffCalculation() {
        SimultaneousExecutor executor = new SimultaneousExecutor(1 + this.typeDiffs.size(), this.getClass(), "prepare");
        executor.execute(() -> {
            for (HollowTypeDiff typeDiff : this.typeDiffs.values()) {
                this.equalityMapping.getEqualOrdinalMap(typeDiff.getTypeName());
            }
        });
        for (HollowTypeDiff typeDiff : this.typeDiffs.values()) {
            executor.execute(typeDiff::calculateMatches);
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.equalityMapping.markPrepared();
    }
}

