/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.combine;

import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.tools.combine.HollowCombinerCopyDirector;
import com.netflix.hollow.tools.traverse.TransitiveSetTraverser;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class HollowCombinerExcludePrimaryKeysCopyDirector
implements HollowCombinerCopyDirector {
    private final HollowCombinerCopyDirector baseDirector;
    private final Map<HollowTypeReadState, BitSet> excludedOrdinals = new HashMap<HollowTypeReadState, BitSet>();

    public HollowCombinerExcludePrimaryKeysCopyDirector() {
        this(HollowCombinerCopyDirector.DEFAULT_DIRECTOR);
    }

    public HollowCombinerExcludePrimaryKeysCopyDirector(HollowCombinerCopyDirector baseDirector) {
        this.baseDirector = baseDirector;
    }

    public void excludeKey(HollowPrimaryKeyIndex idx, Object ... key) {
        int excludeOrdinal = idx.getMatchingOrdinal(key);
        if (excludeOrdinal >= 0) {
            BitSet excludedOrdinals = this.excludedOrdinals.get(idx.getTypeState());
            if (excludedOrdinals == null) {
                excludedOrdinals = new BitSet(idx.getTypeState().maxOrdinal() + 1);
                this.excludedOrdinals.put(idx.getTypeState(), excludedOrdinals);
            }
            excludedOrdinals.set(excludeOrdinal);
        }
    }

    public void excludeReferencedObjects() {
        HashSet<HollowReadStateEngine> stateEngines = new HashSet<HollowReadStateEngine>();
        for (Map.Entry<HollowTypeReadState, BitSet> entry : this.excludedOrdinals.entrySet()) {
            stateEngines.add(entry.getKey().getStateEngine());
        }
        for (HollowReadStateEngine stateEngine : stateEngines) {
            HashMap<String, BitSet> typeBitSetsForStateEngine = new HashMap<String, BitSet>();
            for (Map.Entry<HollowTypeReadState, BitSet> entry : this.excludedOrdinals.entrySet()) {
                if (entry.getKey().getStateEngine() != stateEngine) continue;
                String type = entry.getKey().getSchema().getName();
                typeBitSetsForStateEngine.put(type, BitSet.valueOf(entry.getValue().toLongArray()));
            }
            TransitiveSetTraverser.addTransitiveMatches(stateEngine, typeBitSetsForStateEngine);
            for (Map.Entry<HollowTypeReadState, BitSet> entry : typeBitSetsForStateEngine.entrySet()) {
                this.excludedOrdinals.put(stateEngine.getTypeState((String)((Object)entry.getKey())), entry.getValue());
            }
        }
    }

    @Override
    public boolean shouldCopy(HollowTypeReadState typeState, int ordinal) {
        BitSet bitSet = this.excludedOrdinals.get(typeState);
        if (bitSet != null && bitSet.get(ordinal)) {
            return false;
        }
        return this.baseDirector.shouldCopy(typeState, ordinal);
    }
}

