/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.combine;

import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.ByteArrayOrdinalMap;
import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSchemaSorter;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.HollowWriteStateCreator;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowHashableWriteRecord;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import com.netflix.hollow.tools.combine.HollowCombinerCopyDirector;
import com.netflix.hollow.tools.combine.HollowCombinerExcludePrimaryKeysCopyDirector;
import com.netflix.hollow.tools.combine.HollowCombinerOrdinalRemapper;
import com.netflix.hollow.tools.combine.HollowCombinerPrimaryKeyOrdinalRemapper;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class HollowCombiner {
    private final HollowReadStateEngine[] inputs;
    private final OrdinalRemapper[] ordinalRemappers;
    private final HollowWriteStateEngine output;
    private final Set<String> typeNamesWithDefinedHashCodes;
    private final Set<String> ignoredTypes;
    private final HollowCombinerCopyDirector copyDirector;
    private List<PrimaryKey> primaryKeys;
    private final ThreadLocal<Map<String, HollowCombinerCopier>> copiersPerType;
    private final Map<String, ByteArrayOrdinalMap> hashOrderIndependentOrdinalMaps;

    public HollowCombiner(HollowReadStateEngine ... inputs) {
        this(HollowWriteStateCreator.createWithSchemas(HollowCombiner.validateInputs(inputs)[0].getSchemas()), inputs);
    }

    static HollowReadStateEngine[] validateInputs(HollowReadStateEngine ... inputs) {
        Objects.requireNonNull(inputs);
        if (inputs.length == 0) {
            throw new IllegalArgumentException("No input read state engines");
        }
        return inputs;
    }

    public HollowCombiner(HollowCombinerCopyDirector director, HollowReadStateEngine ... inputs) {
        this(director, HollowWriteStateCreator.createWithSchemas(inputs[0].getSchemas()), inputs);
    }

    public HollowCombiner(HollowWriteStateEngine output, HollowReadStateEngine ... inputs) {
        this(HollowCombinerCopyDirector.DEFAULT_DIRECTOR, output, inputs);
    }

    public HollowCombiner(HollowCombinerCopyDirector copyDirector, HollowWriteStateEngine output, HollowReadStateEngine ... inputs) {
        Objects.requireNonNull(copyDirector);
        Objects.requireNonNull(output);
        this.inputs = HollowCombiner.validateInputs(inputs);
        this.output = output;
        this.typeNamesWithDefinedHashCodes = this.getAllTypesWithDefinedHashCodes();
        this.ordinalRemappers = new OrdinalRemapper[inputs.length];
        this.copiersPerType = new ThreadLocal();
        this.hashOrderIndependentOrdinalMaps = new HashMap<String, ByteArrayOrdinalMap>();
        this.ignoredTypes = new HashSet<String>();
        this.copyDirector = copyDirector;
        this.initializePrimaryKeys();
    }

    private Set<String> getAllTypesWithDefinedHashCodes() {
        HashSet<String> unionOfTypesWithDefinedHashCodes = new HashSet<String>();
        for (HollowReadStateEngine input : this.inputs) {
            unionOfTypesWithDefinedHashCodes.addAll(input.getTypesWithDefinedHashCodes());
        }
        return unionOfTypesWithDefinedHashCodes;
    }

    public void setPrimaryKeys(PrimaryKey ... newKeys) {
        Objects.requireNonNull(newKeys);
        if (newKeys.length == 0) {
            return;
        }
        if (this.inputs.length == 1) {
            return;
        }
        HashMap<String, PrimaryKey> keysByType = new HashMap<String, PrimaryKey>();
        for (PrimaryKey primaryKey : this.primaryKeys) {
            keysByType.put(primaryKey.getType(), primaryKey);
        }
        for (PrimaryKey primaryKey : newKeys) {
            keysByType.put(primaryKey.getType(), primaryKey);
        }
        this.primaryKeys = this.sortPrimaryKeys(new ArrayList<PrimaryKey>(keysByType.values()));
    }

    public List<PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    private void initializePrimaryKeys() {
        if (this.inputs.length == 1) {
            this.primaryKeys = new ArrayList<PrimaryKey>();
            return;
        }
        ArrayList<PrimaryKey> keys = new ArrayList<PrimaryKey>();
        for (HollowSchema schema : this.output.getSchemas()) {
            PrimaryKey pk;
            if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT || this.ignoredTypes.contains(schema.getName()) || (pk = ((HollowObjectSchema)schema).getPrimaryKey()) == null) continue;
            keys.add(pk);
        }
        this.primaryKeys = this.sortPrimaryKeys(keys);
    }

    private List<PrimaryKey> sortPrimaryKeys(List<PrimaryKey> primaryKeys) {
        final List<HollowSchema> dependencyOrderedSchemas = HollowSchemaSorter.dependencyOrderedSchemaList(this.output.getSchemas());
        primaryKeys.sort(new Comparator<PrimaryKey>(){

            @Override
            public int compare(PrimaryKey o1, PrimaryKey o2) {
                return this.schemaDependencyIdx(o1) - this.schemaDependencyIdx(o2);
            }

            private int schemaDependencyIdx(PrimaryKey key) {
                for (int i = 0; i < dependencyOrderedSchemas.size(); ++i) {
                    if (!((HollowSchema)dependencyOrderedSchemas.get(i)).getName().equals(key.getType())) continue;
                    return i;
                }
                throw new IllegalArgumentException("Primary key defined for non-existent type: " + key.getType());
            }
        });
        return primaryKeys;
    }

    public void addIgnoredTypes(String ... typeNames) {
        for (String typeName : typeNames) {
            this.ignoredTypes.add(typeName);
        }
    }

    public void combine() {
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "combine");
        int numThreads = executor.getCorePoolSize();
        this.createOrdinalRemappers();
        this.createHashOrderIndependentOrdinalMaps();
        HashSet processedTypes = new HashSet();
        HashSet<PrimaryKey> processedPrimaryKeys = new HashSet<PrimaryKey>();
        HashSet<PrimaryKey> selectedPrimaryKeys = new HashSet<PrimaryKey>();
        while (processedTypes.size() < this.output.getOrderedTypeStates().size()) {
            for (PrimaryKey key : this.primaryKeys) {
                if (processedPrimaryKeys.contains(key) || this.ignoredTypes.contains(key.getType()) || this.isAnySelectedPrimaryKeyADependencyOf(key.getType(), selectedPrimaryKeys)) continue;
                selectedPrimaryKeys.add(key);
            }
            HashSet<String> typesToProcessThisIteration = new HashSet<String>();
            HashMap<String, HollowPrimaryKeyIndex[]> primaryKeyIndexes = new HashMap<String, HollowPrimaryKeyIndex[]>();
            HollowCombinerExcludePrimaryKeysCopyDirector primaryKeyCopyDirector = new HollowCombinerExcludePrimaryKeysCopyDirector(this.copyDirector);
            for (HollowSchema schema : this.output.getSchemas()) {
                if (processedTypes.contains(schema.getName()) || this.ignoredTypes.contains(schema.getName()) || !selectedPrimaryKeys.isEmpty() && !this.isAnySelectedPrimaryKeyDependentOn(schema.getName(), selectedPrimaryKeys)) continue;
                for (PrimaryKey pk : selectedPrimaryKeys) {
                    int i;
                    if (!pk.getType().equals(schema.getName())) continue;
                    HollowPrimaryKeyIndex[] indexes = new HollowPrimaryKeyIndex[this.inputs.length];
                    for (i = 0; i < indexes.length; ++i) {
                        if (this.inputs[i].getTypeState(pk.getType()) == null) continue;
                        indexes[i] = new HollowPrimaryKeyIndex(this.inputs[i], pk);
                    }
                    for (i = 0; i < indexes.length; ++i) {
                        HollowTypeReadState typeState = this.inputs[i].getTypeState(pk.getType());
                        if (typeState == null) continue;
                        BitSet populatedOrdinals = typeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
                        int ordinal = populatedOrdinals.nextSetBit(0);
                        while (ordinal != -1) {
                            if (primaryKeyCopyDirector.shouldCopy(typeState, ordinal)) {
                                Object[] recordKey = indexes[i].getRecordKey(ordinal);
                                for (int j = i + 1; j < indexes.length; ++j) {
                                    primaryKeyCopyDirector.excludeKey(indexes[j], recordKey);
                                }
                            }
                            ordinal = populatedOrdinals.nextSetBit(ordinal + 1);
                        }
                    }
                    primaryKeyIndexes.put(pk.getType(), indexes);
                }
                typesToProcessThisIteration.add(schema.getName());
            }
            if (typesToProcessThisIteration.isEmpty()) break;
            int i = 0;
            while (i < numThreads) {
                int threadNumber = i++;
                executor.execute(() -> {
                    for (int i1 = 0; i1 < this.inputs.length; ++i1) {
                        HollowCombinerCopier copier;
                        HollowTypeWriteState writeState;
                        HollowTypeReadState readState;
                        HollowCombinerCopyDirector copyDirector = selectedPrimaryKeys.isEmpty() ? this.copyDirector : primaryKeyCopyDirector;
                        HollowReadStateEngine inputEngine = this.inputs[i1];
                        OrdinalRemapper ordinalRemapper = selectedPrimaryKeys.isEmpty() ? this.ordinalRemappers[i1] : new HollowCombinerPrimaryKeyOrdinalRemapper(this.ordinalRemappers, primaryKeyIndexes, i1);
                        HashMap<String, HollowCombinerCopier> copierMap = new HashMap<String, HollowCombinerCopier>();
                        ArrayList<HollowCombinerCopier> copierList = new ArrayList<HollowCombinerCopier>();
                        for (String typeName : typesToProcessThisIteration) {
                            readState = inputEngine.getTypeState(typeName);
                            writeState = this.output.getTypeState(typeName);
                            if (readState == null || writeState == null) continue;
                            copier = new HollowCombinerCopier(readState, writeState, ordinalRemapper);
                            copierList.add(copier);
                            copierMap.put(typeName, copier);
                        }
                        for (String typeName : processedTypes) {
                            readState = inputEngine.getTypeState(typeName);
                            writeState = this.output.getTypeState(typeName);
                            if (readState == null || writeState == null) continue;
                            copier = new HollowCombinerCopier(readState, writeState, this.ordinalRemappers[i1]);
                            copierMap.put(typeName, copier);
                        }
                        this.copiersPerType.set(copierMap);
                        int currentOrdinal = threadNumber;
                        while (!copierList.isEmpty()) {
                            this.copyOrdinalForAllStates(currentOrdinal, copierList, ordinalRemapper, copyDirector);
                            currentOrdinal += numThreads;
                        }
                    }
                });
            }
            try {
                executor.awaitSuccessfulCompletionOfCurrentTasks();
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
            processedTypes.addAll(typesToProcessThisIteration);
            processedPrimaryKeys.addAll(selectedPrimaryKeys);
            selectedPrimaryKeys.clear();
        }
        executor.shutdown();
    }

    private boolean isAnySelectedPrimaryKeyADependencyOf(String type, Set<PrimaryKey> selectedPrimaryKeys) {
        for (PrimaryKey selectedKey : selectedPrimaryKeys) {
            if (!HollowSchemaSorter.typeIsTransitivelyDependent(this.output, type, selectedKey.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean isAnySelectedPrimaryKeyDependentOn(String type, Set<PrimaryKey> selectedPrimaryKeys) {
        for (PrimaryKey selectedKey : selectedPrimaryKeys) {
            if (!HollowSchemaSorter.typeIsTransitivelyDependent(this.output, selectedKey.getType(), type)) continue;
            return true;
        }
        return false;
    }

    public HollowWriteStateEngine getCombinedStateEngine() {
        return this.output;
    }

    void copyOrdinalForAllStates(int currentOrdinal, List<HollowCombinerCopier> copiers, OrdinalRemapper ordinalRemapper, HollowCombinerCopyDirector copyDirector) {
        Iterator<HollowCombinerCopier> iter = copiers.iterator();
        while (iter.hasNext()) {
            HollowCombinerCopier copier = iter.next();
            HollowTypeReadState readTypeState = copier.getReadTypeState();
            if (currentOrdinal <= readTypeState.maxOrdinal()) {
                if (!copyDirector.shouldCopy(readTypeState, currentOrdinal)) continue;
                copier.copy(currentOrdinal);
                continue;
            }
            iter.remove();
        }
    }

    int copyOrdinal(String typeName, int currentOrdinal) {
        HollowCombinerCopier hollowCombinerCopier = this.copiersPerType.get().get(typeName);
        return hollowCombinerCopier == null ? currentOrdinal : hollowCombinerCopier.copy(currentOrdinal);
    }

    private OrdinalRemapper[] createOrdinalRemappers() {
        for (int i = 0; i < this.ordinalRemappers.length; ++i) {
            this.ordinalRemappers[i] = new HollowCombinerOrdinalRemapper(this, this.inputs[i]);
        }
        return this.ordinalRemappers;
    }

    private void createHashOrderIndependentOrdinalMaps() {
        for (HollowSchema schema : this.output.getSchemas()) {
            if (!this.isDefinedHashCode(schema)) continue;
            this.hashOrderIndependentOrdinalMaps.put(schema.getName(), new ByteArrayOrdinalMap());
        }
    }

    private boolean isDefinedHashCode(HollowSchema schema) {
        if (schema instanceof HollowSetSchema) {
            return this.typeNamesWithDefinedHashCodes.contains(((HollowSetSchema)schema).getElementType());
        }
        if (schema instanceof HollowMapSchema) {
            return this.typeNamesWithDefinedHashCodes.contains(((HollowMapSchema)schema).getKeyType());
        }
        return false;
    }

    private class HollowCombinerCopier {
        private final HollowRecordCopier copier;
        private final BitSet populatedOrdinals;
        private final HollowTypeWriteState writeState;
        private final OrdinalRemapper ordinalRemapper;
        private final ByteArrayOrdinalMap hashOrderIndependentOrdinalMap;
        private final ByteDataArray scratch;

        HollowCombinerCopier(HollowTypeReadState readState, HollowTypeWriteState writeState, OrdinalRemapper ordinalRemapper) {
            this.copier = HollowRecordCopier.createCopier(readState, writeState.getSchema(), ordinalRemapper, HollowCombiner.this.isDefinedHashCode(readState.getSchema()));
            this.populatedOrdinals = readState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
            this.writeState = writeState;
            this.ordinalRemapper = ordinalRemapper;
            this.hashOrderIndependentOrdinalMap = (ByteArrayOrdinalMap)HollowCombiner.this.hashOrderIndependentOrdinalMaps.get(readState.getSchema().getName());
            this.scratch = this.hashOrderIndependentOrdinalMap != null ? new ByteDataArray(WastefulRecycler.SMALL_ARRAY_RECYCLER) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int copy(int ordinal) {
            if (this.isOrdinalPopulated(ordinal)) {
                if (!this.ordinalRemapper.ordinalIsMapped(this.getType(), ordinal)) {
                    HollowWriteRecord rec = this.copier.copy(ordinal);
                    if (this.hashOrderIndependentOrdinalMap == null) {
                        int outputOrdinal = this.writeState.add(rec);
                        this.ordinalRemapper.remapOrdinal(this.getType(), ordinal, outputOrdinal);
                        return outputOrdinal;
                    }
                    this.scratch.reset();
                    ((HollowHashableWriteRecord)rec).writeDataTo(this.scratch, HollowHashableWriteRecord.HashBehavior.IGNORED_HASHES);
                    int outputOrdinal = this.hashOrderIndependentOrdinalMap.get(this.scratch);
                    if (outputOrdinal != -1) {
                        return outputOrdinal;
                    }
                    ByteArrayOrdinalMap byteArrayOrdinalMap = this.hashOrderIndependentOrdinalMap;
                    synchronized (byteArrayOrdinalMap) {
                        outputOrdinal = this.hashOrderIndependentOrdinalMap.get(this.scratch);
                        if (outputOrdinal != -1) {
                            return outputOrdinal;
                        }
                        outputOrdinal = this.writeState.add(rec);
                        this.ordinalRemapper.remapOrdinal(this.getType(), ordinal, outputOrdinal);
                        this.hashOrderIndependentOrdinalMap.put(this.scratch, outputOrdinal);
                    }
                }
                return this.ordinalRemapper.getMappedOrdinal(this.getType(), ordinal);
            }
            return -1;
        }

        boolean isOrdinalPopulated(int ordinal) {
            return this.populatedOrdinals.get(ordinal);
        }

        String getType() {
            return this.copier.getReadTypeState().getSchema().getName();
        }

        HollowTypeReadState getReadTypeState() {
            return this.copier.getReadTypeState();
        }
    }
}

