/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.checksum;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import java.util.Collections;
import java.util.Objects;
import java.util.Vector;

public class HollowChecksum {
    private int currentChecksum = 0;
    private Vector<TypeChecksum> sortedTypeChecksums;

    public void setSortedTypeChecksums(Vector<TypeChecksum> sortedTypeChecksums) {
        this.sortedTypeChecksums = sortedTypeChecksums;
    }

    public Vector<TypeChecksum> getSortedTypeChecksums() {
        return this.sortedTypeChecksums;
    }

    public void applyType(TypeChecksum typeChecksum) {
        if (this.sortedTypeChecksums == null) {
            this.sortedTypeChecksums = new Vector();
        }
        this.sortedTypeChecksums.addElement(typeChecksum);
        this.applyInt(typeChecksum.checksum);
    }

    public void applyInt(int value) {
        this.currentChecksum ^= HashCodes.hashInt(value);
        this.currentChecksum = HashCodes.hashInt(this.currentChecksum);
    }

    public void applyLong(long value) {
        this.currentChecksum ^= HashCodes.hashLong(value);
        this.currentChecksum = HashCodes.hashInt(this.currentChecksum);
    }

    public int intValue() {
        return this.currentChecksum;
    }

    public boolean equals(Object other) {
        if (other instanceof HollowChecksum) {
            return ((HollowChecksum)other).currentChecksum == this.currentChecksum;
        }
        return false;
    }

    public int hashCode() {
        return this.currentChecksum;
    }

    public String toString() {
        return Integer.toHexString(this.currentChecksum);
    }

    public static HollowChecksum forStateEngine(HollowReadStateEngine stateEngine) {
        return HollowChecksum.forStateEngineWithCommonSchemas(stateEngine, stateEngine);
    }

    public static HollowChecksum forStateEngineWithCommonSchemas(HollowReadStateEngine stateEngine, HollowReadStateEngine commonSchemasWithState) {
        final Vector typeChecksums = new Vector();
        SimultaneousExecutor executor = new SimultaneousExecutor(HollowChecksum.class, "checksum-common-schemas");
        for (final HollowTypeReadState typeState : stateEngine.getTypeStates()) {
            HollowTypeReadState commonSchemasWithType = commonSchemasWithState.getTypeState(typeState.getSchema().getName());
            if (commonSchemasWithType == null) continue;
            final HollowSchema commonSchemasWith = commonSchemasWithType.getSchema();
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    HollowChecksum cksum = typeState.getChecksum(commonSchemasWith);
                    typeChecksums.addElement(new TypeChecksum(typeState.getSchema().getName(), cksum));
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Collections.sort(typeChecksums);
        HollowChecksum totalChecksum = new HollowChecksum();
        for (TypeChecksum cksum : typeChecksums) {
            totalChecksum.applyType(cksum);
        }
        return totalChecksum;
    }

    public static class TypeChecksum
    implements Comparable<TypeChecksum> {
        private final String type;
        private final int checksum;

        public TypeChecksum(String type, HollowChecksum cksum) {
            this.type = type;
            this.checksum = cksum.intValue();
        }

        public int getChecksum() {
            return this.checksum;
        }

        @Override
        public int compareTo(TypeChecksum other) {
            return this.type.compareTo(other.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeChecksum that = (TypeChecksum)o;
            return this.checksum == that.checksum && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.checksum);
        }

        public String toString() {
            return "TypeChecksum{type='" + this.type + '\'' + ", checksum=" + Integer.toHexString(this.checksum) + '}';
        }
    }
}

