/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords.traversal;

import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordOrdinalReader;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalListNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalMapNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalSetNode;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class FlatRecordTraversalObjectNode
implements FlatRecordTraversalNode {
    private final FlatRecordOrdinalReader reader;
    private final HollowObjectSchema schema;
    private final int ordinal;
    private Map<String, HollowObjectSchema> commonSchemaMap;

    public FlatRecordTraversalObjectNode(FlatRecordOrdinalReader reader, HollowObjectSchema schema, int ordinal) {
        this.reader = reader;
        this.schema = schema;
        this.ordinal = ordinal;
    }

    public FlatRecordTraversalObjectNode(FlatRecord rec) {
        this.reader = new FlatRecordOrdinalReader(rec);
        this.ordinal = this.reader.getOrdinalCount() - 1;
        this.schema = (HollowObjectSchema)this.reader.readSchema(this.ordinal);
    }

    @Override
    public HollowObjectSchema getSchema() {
        return this.schema;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setCommonSchema(Map<String, HollowObjectSchema> commonSchema) {
        this.commonSchemaMap = commonSchema;
    }

    public FlatRecordTraversalObjectNode getObjectFieldNode(String field) {
        return (FlatRecordTraversalObjectNode)this.getFieldNode(field);
    }

    public FlatRecordTraversalListNode getListFieldNode(String field) {
        return (FlatRecordTraversalListNode)this.getFieldNode(field);
    }

    public FlatRecordTraversalSetNode getSetFieldNode(String field) {
        return (FlatRecordTraversalSetNode)this.getFieldNode(field);
    }

    public FlatRecordTraversalMapNode getMapFieldNode(String field) {
        return (FlatRecordTraversalMapNode)this.getFieldNode(field);
    }

    public boolean isFieldNull(String field) {
        return this.reader.isNull(this.ordinal, field);
    }

    public FlatRecordTraversalNode getFieldNode(String field) {
        HollowObjectSchema.FieldType fieldType = this.schema.getFieldType(field);
        if (fieldType == null) {
            return null;
        }
        if (fieldType != HollowObjectSchema.FieldType.REFERENCE) {
            throw new IllegalArgumentException("Cannot get child for non-reference field: " + field);
        }
        int refOrdinal = this.reader.readFieldReference(this.ordinal, field);
        if (refOrdinal == -1) {
            return null;
        }
        return this.createNode(this.reader, refOrdinal);
    }

    public Object getFieldValue(String field) {
        HollowObjectSchema.FieldType fieldType = this.schema.getFieldType(field);
        if (fieldType == null) {
            return null;
        }
        switch (fieldType) {
            case BOOLEAN: {
                return this.reader.readFieldBoolean(this.ordinal, field);
            }
            case INT: {
                return this.reader.readFieldInt(this.ordinal, field);
            }
            case LONG: {
                return this.reader.readFieldLong(this.ordinal, field);
            }
            case FLOAT: {
                return Float.valueOf(this.reader.readFieldFloat(this.ordinal, field));
            }
            case DOUBLE: {
                return this.reader.readFieldDouble(this.ordinal, field);
            }
            case STRING: {
                return this.reader.readFieldString(this.ordinal, field);
            }
            case BYTES: {
                return this.reader.readFieldBytes(this.ordinal, field);
            }
            case REFERENCE: {
                throw new IllegalArgumentException("Cannot get leaf value for reference field: " + field);
            }
        }
        return null;
    }

    public boolean getFieldValueBoolean(String field) {
        Boolean b = this.reader.readFieldBoolean(this.ordinal, field);
        return Boolean.TRUE.equals(b);
    }

    public Boolean getFieldValueBooleanBoxed(String field) {
        return this.getFieldValueBoolean(field);
    }

    public int getFieldValueInt(String field) {
        return this.reader.readFieldInt(this.ordinal, field);
    }

    public Integer getFieldValueIntBoxed(String field) {
        int value = this.getFieldValueInt(field);
        if (value == Integer.MIN_VALUE) {
            return null;
        }
        return value;
    }

    public long getFieldValueLong(String field) {
        return this.reader.readFieldLong(this.ordinal, field);
    }

    public Long getFieldValueLongBoxed(String field) {
        long value = this.getFieldValueLong(field);
        if (value == Long.MIN_VALUE) {
            return null;
        }
        return value;
    }

    public float getFieldValueFloat(String field) {
        return this.reader.readFieldFloat(this.ordinal, field);
    }

    public Float getFieldValueFloatBoxed(String field) {
        float value = this.getFieldValueFloat(field);
        if (Float.isNaN(value)) {
            return null;
        }
        return Float.valueOf(value);
    }

    public double getFieldValueDouble(String field) {
        return this.reader.readFieldDouble(this.ordinal, field);
    }

    public Double getFieldValueDoubleBoxed(String field) {
        double value = this.getFieldValueDouble(field);
        if (Double.isNaN(value)) {
            return null;
        }
        return value;
    }

    public String getFieldValueString(String field) {
        return this.reader.readFieldString(this.ordinal, field);
    }

    public byte[] getFieldValueBytes(String field) {
        return this.reader.readFieldBytes(this.ordinal, field);
    }

    public int hashCode() {
        HollowObjectSchema commonSchema = this.commonSchemaMap.get(this.schema.getName());
        Object[] fields = new Object[commonSchema.numFields()];
        for (int i = 0; i < commonSchema.numFields(); ++i) {
            String fieldName = commonSchema.getFieldName(i);
            if (commonSchema.getFieldType(fieldName) == HollowObjectSchema.FieldType.REFERENCE) continue;
            fields[i] = this.getFieldValue(fieldName);
        }
        return Objects.hash(this.schema.getName(), Arrays.deepHashCode(fields));
    }
}

