/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords.traversal;

import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordOrdinalReader;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalListNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalMapNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalObjectNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalSetNode;
import java.util.Map;

public interface FlatRecordTraversalNode {
    public int getOrdinal();

    public HollowSchema getSchema();

    public void setCommonSchema(Map<String, HollowObjectSchema> var1);

    default public FlatRecordTraversalNode createNode(FlatRecordOrdinalReader reader, int ordinal) {
        HollowSchema schema = reader.readSchema(ordinal);
        switch (schema.getSchemaType()) {
            case OBJECT: {
                return new FlatRecordTraversalObjectNode(reader, (HollowObjectSchema)schema, ordinal);
            }
            case LIST: {
                return new FlatRecordTraversalListNode(reader, (HollowListSchema)schema, ordinal);
            }
            case SET: {
                return new FlatRecordTraversalSetNode(reader, (HollowSetSchema)schema, ordinal);
            }
            case MAP: {
                return new FlatRecordTraversalMapNode(reader, (HollowMapSchema)schema, ordinal);
            }
        }
        throw new IllegalArgumentException("Unsupported schema type: " + (Object)((Object)schema.getSchemaType()));
    }
}

