/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords.traversal;

import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordOrdinalReader;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalNode;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FlatRecordTraversalMapNode
extends AbstractMap<FlatRecordTraversalNode, FlatRecordTraversalNode>
implements FlatRecordTraversalNode {
    private final FlatRecordOrdinalReader reader;
    private final HollowMapSchema schema;
    private final int ordinal;
    private final int[] keyOrdinals;
    private final int[] valueOrdinals;
    private Map<String, HollowObjectSchema> commonSchemaMap;

    public FlatRecordTraversalMapNode(FlatRecordOrdinalReader reader, HollowMapSchema schema, int ordinal) {
        this.reader = reader;
        this.schema = schema;
        this.ordinal = ordinal;
        int size = reader.readSize(ordinal);
        this.keyOrdinals = new int[size];
        this.valueOrdinals = new int[size];
        reader.readMapElementsInto(ordinal, this.keyOrdinals, this.valueOrdinals);
    }

    @Override
    public HollowMapSchema getSchema() {
        return this.schema;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setCommonSchema(Map<String, HollowObjectSchema> commonSchema) {
        this.commonSchemaMap = commonSchema;
    }

    @Override
    public Set<Map.Entry<FlatRecordTraversalNode, FlatRecordTraversalNode>> entrySet() {
        return new AbstractSet<Map.Entry<FlatRecordTraversalNode, FlatRecordTraversalNode>>(){

            @Override
            public Iterator<Map.Entry<FlatRecordTraversalNode, FlatRecordTraversalNode>> iterator() {
                return new EntrySetIteratorImpl<FlatRecordTraversalNode, FlatRecordTraversalNode>();
            }

            @Override
            public int size() {
                return FlatRecordTraversalMapNode.this.keyOrdinals.length;
            }
        };
    }

    public <K extends FlatRecordTraversalNode, V extends FlatRecordTraversalNode> Iterator<Map.Entry<K, V>> entrySetIterator() {
        return new EntrySetIteratorImpl();
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Map.Entry<FlatRecordTraversalNode, FlatRecordTraversalNode> e : this.entrySet()) {
            FlatRecordTraversalNode key = e.getKey();
            FlatRecordTraversalNode value = e.getValue();
            if (this.commonSchemaMap.containsKey(key.getSchema().getName())) {
                key.setCommonSchema(this.commonSchemaMap);
                h += key.hashCode();
            }
            if (!this.commonSchemaMap.containsKey(value.getSchema().getName())) continue;
            value.setCommonSchema(this.commonSchemaMap);
            h += value.hashCode();
        }
        return h;
    }

    private class EntrySetIteratorImpl<K extends FlatRecordTraversalNode, V extends FlatRecordTraversalNode>
    implements Iterator<Map.Entry<K, V>> {
        private int index = 0;

        private EntrySetIteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.index < FlatRecordTraversalMapNode.this.keyOrdinals.length;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.index >= FlatRecordTraversalMapNode.this.keyOrdinals.length) {
                throw new IllegalStateException("No more elements");
            }
            final int keyOrdinal = FlatRecordTraversalMapNode.this.keyOrdinals[this.index];
            final int valueOrdinal = FlatRecordTraversalMapNode.this.valueOrdinals[this.index];
            ++this.index;
            return new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    if (keyOrdinal == -1) {
                        return null;
                    }
                    return FlatRecordTraversalMapNode.this.createNode(FlatRecordTraversalMapNode.this.reader, keyOrdinal);
                }

                @Override
                public V getValue() {
                    if (valueOrdinal == -1) {
                        return null;
                    }
                    return FlatRecordTraversalMapNode.this.createNode(FlatRecordTraversalMapNode.this.reader, valueOrdinal);
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

