/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords;

import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.encoding.ZigZag;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;

public class FlatRecordOrdinalReader {
    private final FlatRecord record;
    private final IntList ordinalOffsets = new IntList();

    public FlatRecordOrdinalReader(FlatRecord record) {
        this.record = record;
        this.populateOrdinalOffset();
    }

    private void populateOrdinalOffset() {
        for (int offset = this.record.dataStartByte; offset < this.record.dataEndByte; offset += this.sizeOfOrdinal(this.ordinalOffsets.size() - 1)) {
            this.ordinalOffsets.add(offset);
        }
    }

    private int getOrdinalOffset(int ordinal) {
        return this.ordinalOffsets.get(ordinal);
    }

    public int getOrdinalCount() {
        return this.ordinalOffsets.size();
    }

    public HollowSchema readSchema(int ordinal) {
        int schemaId = VarInt.readVInt(this.record.data, (long)this.getOrdinalOffset(ordinal));
        return this.record.schemaIdMapper.getSchema(schemaId);
    }

    public int readSize(int ordinal) {
        int offset = this.getOrdinalOffset(ordinal);
        int schemaId = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(schemaId);
        HollowSchema schema = this.record.schemaIdMapper.getSchema(schemaId);
        if (schema.getSchemaType() != HollowSchema.SchemaType.LIST && schema.getSchemaType() != HollowSchema.SchemaType.SET && schema.getSchemaType() != HollowSchema.SchemaType.MAP) {
            throw new IllegalArgumentException(String.format("Ordinal %d is not a LIST, SET, or MAP type (found %s)", new Object[]{ordinal, schema.getSchemaType()}));
        }
        return VarInt.readVInt(this.record.data, (long)offset);
    }

    public void readListElementsInto(int ordinal, int[] elements) {
        int offset = this.getOrdinalOffset(ordinal);
        int schemaId = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(schemaId);
        HollowSchema schema = this.record.schemaIdMapper.getSchema(schemaId);
        if (schema.getSchemaType() != HollowSchema.SchemaType.LIST) {
            throw new IllegalArgumentException(String.format("Ordinal %d is not a LIST type (found %s)", new Object[]{ordinal, schema.getSchemaType()}));
        }
        int size = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(size);
        for (int i = 0; i < size; ++i) {
            elements[i] = VarInt.readVInt(this.record.data, (long)offset);
            offset += VarInt.sizeOfVInt(elements[i]);
        }
    }

    public void readSetElementsInto(int ordinal, int[] elements) {
        int offset = this.getOrdinalOffset(ordinal);
        int schemaId = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(schemaId);
        HollowSchema schema = this.record.schemaIdMapper.getSchema(schemaId);
        if (schema.getSchemaType() != HollowSchema.SchemaType.SET) {
            throw new IllegalArgumentException(String.format("Ordinal %d is not a SET type (found %s)", new Object[]{ordinal, schema.getSchemaType()}));
        }
        int size = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(size);
        int elementOrdinal = 0;
        for (int i = 0; i < size; ++i) {
            int elementOrdinalDelta = VarInt.readVInt(this.record.data, (long)offset);
            offset += VarInt.sizeOfVInt(elementOrdinalDelta);
            elements[i] = elementOrdinal += elementOrdinalDelta;
        }
    }

    public void readMapElementsInto(int ordinal, int[] keys, int[] values) {
        int offset = this.getOrdinalOffset(ordinal);
        int schemaId = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(schemaId);
        HollowSchema schema = this.record.schemaIdMapper.getSchema(schemaId);
        if (schema.getSchemaType() != HollowSchema.SchemaType.MAP) {
            throw new IllegalArgumentException(String.format("Ordinal %d is not a MAP type (found %s)", new Object[]{ordinal, schema.getSchemaType()}));
        }
        int size = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(size);
        int keyOrdinal = 0;
        for (int i = 0; i < size; ++i) {
            int keyOrdinalDelta = VarInt.readVInt(this.record.data, (long)offset);
            keys[i] = keyOrdinal += keyOrdinalDelta;
            values[i] = VarInt.readVInt(this.record.data, (long)(offset += VarInt.sizeOfVInt(keyOrdinalDelta)));
            offset += VarInt.sizeOfVInt(values[i]);
        }
    }

    public int readFieldReference(int ordinal, String field) {
        int offset = this.skipToField(ordinal, HollowObjectSchema.FieldType.REFERENCE, field);
        if (offset == -1) {
            return -1;
        }
        if (VarInt.readVNull(this.record.data, (long)offset)) {
            return -1;
        }
        return VarInt.readVInt(this.record.data, (long)offset);
    }

    public Boolean readFieldBoolean(int ordinal, String field) {
        int offset = this.skipToField(ordinal, HollowObjectSchema.FieldType.BOOLEAN, field);
        if (offset == -1) {
            return null;
        }
        if (VarInt.readVNull(this.record.data, (long)offset)) {
            return null;
        }
        byte value = this.record.data.get(offset);
        return value == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    public int readFieldInt(int ordinal, String field) {
        int offset = this.skipToField(ordinal, HollowObjectSchema.FieldType.INT, field);
        if (offset == -1) {
            return Integer.MIN_VALUE;
        }
        if (VarInt.readVNull(this.record.data, (long)offset)) {
            return Integer.MIN_VALUE;
        }
        int value = VarInt.readVInt(this.record.data, (long)offset);
        return ZigZag.decodeInt(value);
    }

    public long readFieldLong(int ordinal, String field) {
        int offset = this.skipToField(ordinal, HollowObjectSchema.FieldType.LONG, field);
        if (offset == -1) {
            return Long.MIN_VALUE;
        }
        if (VarInt.readVNull(this.record.data, (long)offset)) {
            return Long.MIN_VALUE;
        }
        long value = VarInt.readVLong(this.record.data, (long)offset);
        return ZigZag.decodeLong(value);
    }

    public float readFieldFloat(int ordinal, String field) {
        int offset = this.skipToField(ordinal, HollowObjectSchema.FieldType.FLOAT, field);
        if (offset == -1) {
            return Float.NaN;
        }
        int value = this.record.data.readIntBits(offset);
        if (value == HollowObjectWriteRecord.NULL_FLOAT_BITS) {
            return Float.NaN;
        }
        return Float.intBitsToFloat(value);
    }

    public double readFieldDouble(int ordinal, String field) {
        int offset = this.skipToField(ordinal, HollowObjectSchema.FieldType.DOUBLE, field);
        if (offset == -1) {
            return Double.NaN;
        }
        long value = this.record.data.readLongBits(offset);
        if (value == HollowObjectWriteRecord.NULL_DOUBLE_BITS) {
            return Double.NaN;
        }
        return Double.longBitsToDouble(value);
    }

    public String readFieldString(int ordinal, String field) {
        int offset = this.skipToField(ordinal, HollowObjectSchema.FieldType.STRING, field);
        if (offset == -1) {
            return null;
        }
        if (VarInt.readVNull(this.record.data, (long)offset)) {
            return null;
        }
        int length = VarInt.readVInt(this.record.data, (long)offset);
        int cLength = VarInt.countVarIntsInRange(this.record.data, offset += VarInt.sizeOfVInt(length), length);
        char[] s = new char[cLength];
        for (int i = 0; i < cLength; ++i) {
            int charValue = VarInt.readVInt(this.record.data, (long)offset);
            s[i] = (char)charValue;
            offset += VarInt.sizeOfVInt(charValue);
        }
        return new String(s);
    }

    public byte[] readFieldBytes(int ordinal, String field) {
        int offset = this.skipToField(ordinal, HollowObjectSchema.FieldType.BYTES, field);
        if (offset == -1) {
            return null;
        }
        if (VarInt.readVNull(this.record.data, (long)offset)) {
            return null;
        }
        int length = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(length);
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = this.record.data.get(offset++);
        }
        return b;
    }

    public boolean isNull(int ordinal, String field) {
        HollowSchema schema = this.readSchema(ordinal);
        if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT) {
            throw new IllegalArgumentException(String.format("Ordinal %d is not an OBJECT type (found %s)", new Object[]{ordinal, schema.getSchemaType()}));
        }
        HollowObjectSchema.FieldType fieldType = ((HollowObjectSchema)schema).getFieldType(field);
        if (fieldType == null) {
            return true;
        }
        int offset = this.skipToField(ordinal, fieldType, field);
        if (offset == -1) {
            return true;
        }
        switch (fieldType) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case REFERENCE: 
            case BYTES: 
            case STRING: {
                return VarInt.readVNull(this.record.data, (long)offset);
            }
            case FLOAT: {
                return this.record.data.readIntBits(offset) == HollowObjectWriteRecord.NULL_FLOAT_BITS;
            }
            case DOUBLE: {
                return this.record.data.readLongBits(offset) == HollowObjectWriteRecord.NULL_DOUBLE_BITS;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + (Object)((Object)fieldType));
    }

    private int skipToField(int ordinal, HollowObjectSchema.FieldType fieldType, String field) {
        int offset = this.getOrdinalOffset(ordinal);
        int schemaId = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(schemaId);
        HollowSchema schema = this.record.schemaIdMapper.getSchema(schemaId);
        if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT) {
            throw new IllegalArgumentException(String.format("Ordinal %d is not an OBJECT type (found %s)", new Object[]{ordinal, schema.getSchemaType()}));
        }
        HollowObjectSchema objectSchema = (HollowObjectSchema)schema;
        int fieldIndex = objectSchema.getPosition(field);
        if (fieldIndex == -1) {
            return -1;
        }
        if (fieldType != objectSchema.getFieldType(fieldIndex)) {
            throw new IllegalArgumentException(String.format("Field %s is not of type %s", new Object[]{field, fieldType}));
        }
        for (int i = 0; i < fieldIndex; ++i) {
            offset += this.sizeOfFieldValue(objectSchema.getFieldType(i), offset);
        }
        return offset;
    }

    private int sizeOfOrdinal(int ordinal) {
        int offset;
        int start = offset = this.getOrdinalOffset(ordinal);
        int schemaId = VarInt.readVInt(this.record.data, (long)offset);
        offset += VarInt.sizeOfVInt(schemaId);
        HollowSchema schema = this.record.schemaIdMapper.getSchema(schemaId);
        switch (schema.getSchemaType()) {
            case OBJECT: {
                HollowObjectSchema objectSchema = (HollowObjectSchema)schema;
                for (int i = 0; i < objectSchema.numFields(); ++i) {
                    offset += this.sizeOfFieldValue(objectSchema.getFieldType(i), offset);
                }
                break;
            }
            case LIST: 
            case SET: {
                int size = VarInt.readVInt(this.record.data, (long)offset);
                offset += VarInt.sizeOfVInt(size);
                for (int i = 0; i < size; ++i) {
                    offset += VarInt.nextVLongSize(this.record.data, (long)offset);
                }
                break;
            }
            case MAP: {
                int size = VarInt.readVInt(this.record.data, (long)offset);
                offset += VarInt.sizeOfVInt(size);
                for (int i = 0; i < size; ++i) {
                    offset += VarInt.nextVLongSize(this.record.data, (long)offset);
                    offset += VarInt.nextVLongSize(this.record.data, (long)offset);
                }
                break;
            }
        }
        return offset - start;
    }

    private int sizeOfFieldValue(HollowObjectSchema.FieldType fieldType, int offset) {
        switch (fieldType) {
            case INT: 
            case LONG: 
            case REFERENCE: {
                return VarInt.nextVLongSize(this.record.data, (long)offset);
            }
            case BYTES: 
            case STRING: {
                if (VarInt.readVNull(this.record.data, (long)offset)) {
                    return 1;
                }
                int fieldLength = VarInt.readVInt(this.record.data, (long)offset);
                return VarInt.sizeOfVInt(fieldLength) + fieldLength;
            }
            case BOOLEAN: {
                return 1;
            }
            case DOUBLE: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + (Object)((Object)fieldType));
    }
}

