/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadState;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import com.netflix.hollow.core.write.objectmapper.flatrecords.HollowSchemaIdentifierMapper;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import java.util.HashMap;
import java.util.Map;

public class FlatRecordExtractor {
    private final HollowReadStateEngine extractFrom;
    private final FlatRecordWriter writer;
    private final ExtractorOrdinalRemapper ordinalRemapper;
    private final Map<String, HollowRecordCopier> recordCopiersByType;

    public FlatRecordExtractor(HollowReadStateEngine extractFrom, HollowSchemaIdentifierMapper schemaIdMapper) {
        this.extractFrom = extractFrom;
        this.writer = new FlatRecordWriter(extractFrom, schemaIdMapper);
        this.ordinalRemapper = new ExtractorOrdinalRemapper();
        this.recordCopiersByType = new HashMap<String, HollowRecordCopier>();
    }

    public synchronized FlatRecord extract(String type, int ordinal) {
        this.ordinalRemapper.clear();
        this.writer.reset();
        HollowTypeReadState typeState = this.extractFrom.getTypeState(type);
        this.extractHollowRecord(typeState, ordinal);
        return this.writer.generateFlatRecord();
    }

    private void extractHollowRecord(HollowTypeReadState typeState, int ordinal) {
        if (ordinal == -1) {
            return;
        }
        this.traverse(typeState, ordinal);
        String type = typeState.getSchema().getName();
        HollowRecordCopier recordCopier = this.recordCopier(type);
        HollowWriteRecord rec = recordCopier.copy(ordinal);
        int flatOrdinal = this.writer.write(typeState.getSchema(), rec);
        this.ordinalRemapper.remapOrdinal(type, ordinal, flatOrdinal);
    }

    private void traverse(HollowTypeReadState typeState, int ordinal) {
        switch (typeState.getSchema().getSchemaType()) {
            case OBJECT: {
                this.traverseObject((HollowObjectTypeReadState)typeState, ordinal);
                break;
            }
            case LIST: {
                this.traverseList((HollowListTypeReadState)typeState, ordinal);
                break;
            }
            case SET: {
                this.traverseSet((HollowSetTypeReadState)typeState, ordinal);
                break;
            }
            case MAP: {
                this.traverseMap((HollowMapTypeReadState)typeState, ordinal);
            }
        }
    }

    private void traverseObject(HollowObjectTypeReadState typeState, int ordinal) {
        HollowObjectSchema schema = typeState.getSchema();
        for (int i = 0; i < schema.numFields(); ++i) {
            if (schema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE) continue;
            HollowTypeReadState refTypeState = schema.getReferencedTypeState(i);
            int refOrdinal = typeState.readOrdinal(ordinal, i);
            this.extractHollowRecord(refTypeState, refOrdinal);
        }
    }

    private void traverseList(HollowListTypeReadState typeState, int ordinal) {
        HollowListSchema schema = typeState.getSchema();
        int size = typeState.size(ordinal);
        for (int i = 0; i < size; ++i) {
            int refOrdinal = typeState.getElementOrdinal(ordinal, i);
            if (refOrdinal == -1) continue;
            this.extractHollowRecord(schema.getElementTypeState(), refOrdinal);
        }
    }

    private void traverseSet(HollowSetTypeReadState typeState, int ordinal) {
        HollowSetSchema schema = typeState.getSchema();
        HollowOrdinalIterator iter = typeState.ordinalIterator(ordinal);
        int refOrdinal = iter.next();
        while (refOrdinal != Integer.MAX_VALUE) {
            if (refOrdinal != -1) {
                this.extractHollowRecord(schema.getElementTypeState(), refOrdinal);
            }
            refOrdinal = iter.next();
        }
    }

    private void traverseMap(HollowMapTypeReadState typeState, int ordinal) {
        HollowMapSchema schema = typeState.getSchema();
        HollowMapEntryOrdinalIterator iter = typeState.ordinalIterator(ordinal);
        while (iter.next()) {
            if (iter.getKey() != -1) {
                this.extractHollowRecord(schema.getKeyTypeState(), iter.getKey());
            }
            if (iter.getValue() == -1) continue;
            this.extractHollowRecord(schema.getValueTypeState(), iter.getValue());
        }
    }

    private HollowRecordCopier recordCopier(String type) {
        HollowRecordCopier recordCopier = this.recordCopiersByType.get(type);
        if (recordCopier == null) {
            recordCopier = HollowRecordCopier.createCopier(this.extractFrom.getTypeState(type), this.ordinalRemapper, false);
            this.recordCopiersByType.put(type, recordCopier);
        }
        return recordCopier;
    }

    private static class ExtractorOrdinalRemapper
    implements OrdinalRemapper {
        private final Map<TypedOrdinal, Integer> mappedFlatOrdinals = new HashMap<TypedOrdinal, Integer>();

        private ExtractorOrdinalRemapper() {
        }

        @Override
        public int getMappedOrdinal(String type, int originalOrdinal) {
            return this.mappedFlatOrdinals.get(new TypedOrdinal(type, originalOrdinal));
        }

        @Override
        public void remapOrdinal(String type, int originalOrdinal, int mappedOrdinal) {
            this.mappedFlatOrdinals.put(new TypedOrdinal(type, originalOrdinal), mappedOrdinal);
        }

        @Override
        public boolean ordinalIsMapped(String type, int originalOrdinal) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.mappedFlatOrdinals.clear();
        }

        private static class TypedOrdinal {
            private final String type;
            private final int ordinal;

            public TypedOrdinal(String type, int ordinal) {
                this.type = type;
                this.ordinal = ordinal;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.ordinal;
                result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TypedOrdinal other = (TypedOrdinal)obj;
                if (this.ordinal != other.ordinal) {
                    return false;
                }
                return !(this.type == null ? other.type != null : !this.type.equals(other.type));
            }
        }
    }
}

