/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.ByteData;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.encoding.ZigZag;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.objectmapper.RecordPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.flatrecords.HollowSchemaIdentifierMapper;
import java.util.Arrays;

public class FlatRecord {
    final HollowSchemaIdentifierMapper schemaIdMapper;
    final ByteData data;
    final int dataStartByte;
    final int dataEndByte;
    final RecordPrimaryKey recordPrimaryKey;

    public FlatRecord(ByteData recordData, HollowSchemaIdentifierMapper schemaIdMapper) {
        this.data = recordData;
        this.schemaIdMapper = schemaIdMapper;
        int currentRecordPointer = 0;
        int locationOfTopRecord = VarInt.readVInt(recordData, (long)currentRecordPointer);
        int end = VarInt.readVInt(recordData, (long)(currentRecordPointer += VarInt.sizeOfVInt(locationOfTopRecord)));
        this.dataStartByte = currentRecordPointer += VarInt.sizeOfVInt(end);
        this.dataEndByte = end + this.dataStartByte + locationOfTopRecord;
        int topRecordSchemaId = VarInt.readVInt(recordData, (long)(this.dataStartByte + locationOfTopRecord));
        HollowSchema topRecordSchema = schemaIdMapper.getSchema(topRecordSchemaId);
        if (topRecordSchema == null) {
            throw new IllegalStateException("Could not find schema for schemaId " + topRecordSchemaId);
        }
        if (topRecordSchema.getSchemaType() == HollowSchema.SchemaType.OBJECT) {
            PrimaryKey primaryKey = ((HollowObjectSchema)topRecordSchema).getPrimaryKey();
            if (primaryKey != null) {
                Object[] recordPrimaryKey = new Object[primaryKey.numFields()];
                HollowObjectSchema.FieldType[] primaryKeyFieldTypes = schemaIdMapper.getPrimaryKeyFieldTypes(topRecordSchemaId);
                int primaryKeyRecordPointer = this.dataEndByte;
                for (int i = 0; i < recordPrimaryKey.length; ++i) {
                    int locationOfField = VarInt.readVInt(recordData, (long)primaryKeyRecordPointer);
                    primaryKeyRecordPointer += VarInt.sizeOfVInt(locationOfField);
                    recordPrimaryKey[i] = this.readPrimaryKeyField(locationOfField + this.dataStartByte, primaryKeyFieldTypes[i]);
                }
                this.recordPrimaryKey = new RecordPrimaryKey(topRecordSchema.getName(), recordPrimaryKey);
            } else {
                this.recordPrimaryKey = null;
            }
        } else {
            this.recordPrimaryKey = null;
        }
    }

    public byte[] toArray() {
        byte[] arr = new byte[(int)this.data.length()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.data.get(i);
        }
        return arr;
    }

    public long size() {
        return this.data.length();
    }

    private Object readPrimaryKeyField(int location, HollowObjectSchema.FieldType fieldType) {
        switch (fieldType) {
            case BOOLEAN: {
                return this.data.get(location) == 1;
            }
            case INT: {
                return ZigZag.decodeInt(VarInt.readVInt(this.data, (long)location));
            }
            case LONG: {
                return ZigZag.decodeLong(VarInt.readVLong(this.data, (long)location));
            }
            case DOUBLE: {
                long longBits = this.data.readLongBits(location);
                return Double.longBitsToDouble(longBits);
            }
            case FLOAT: {
                int intBits = this.data.readIntBits(location);
                return Float.valueOf(Float.intBitsToFloat(intBits));
            }
            case STRING: {
                int length = VarInt.readVInt(this.data, (long)location);
                int endLocation = (location += VarInt.sizeOfVInt(length)) + length;
                char[] s = new char[length];
                int cnt = 0;
                while (location < endLocation) {
                    int c = VarInt.readVInt(this.data, (long)location);
                    s[cnt] = (char)c;
                    location += VarInt.sizeOfVInt(c);
                    ++cnt;
                }
                if (cnt < s.length) {
                    s = Arrays.copyOf(s, cnt);
                }
                return new String(s);
            }
            case BYTES: {
                int length = VarInt.readVInt(this.data, (long)location);
                location += VarInt.sizeOfVInt(length);
                byte[] b = new byte[length];
                for (int i = 0; i < b.length; ++i) {
                    b[i] = this.data.get(location++);
                }
                return b;
            }
        }
        throw new IllegalStateException("Should not have encoded primary key with REFERENCE type fields.");
    }

    public RecordPrimaryKey getRecordPrimaryKey() {
        return this.recordPrimaryKey;
    }
}

