/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.copy;

import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowSetOrdinalIterator;
import com.netflix.hollow.core.write.HollowHashableWriteRecord;
import com.netflix.hollow.core.write.HollowSetWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import com.netflix.hollow.tools.combine.OrdinalRemapper;

public class HollowSetCopier
extends HollowRecordCopier {
    public HollowSetCopier(HollowSetTypeReadState typeState, OrdinalRemapper ordinalRemapper, boolean preserveHashPositions) {
        super(typeState, new HollowSetWriteRecord(preserveHashPositions ? HollowHashableWriteRecord.HashBehavior.UNMIXED_HASHES : HollowHashableWriteRecord.HashBehavior.MIXED_HASHES), ordinalRemapper, preserveHashPositions);
    }

    @Override
    public HollowWriteRecord copy(int ordinal) {
        HollowSetWriteRecord rec = this.rec();
        rec.reset();
        String elementType = this.readState().getSchema().getElementType();
        HollowOrdinalIterator ordinalIterator = this.readState().ordinalIterator(ordinal);
        int elementOrdinal = ordinalIterator.next();
        while (elementOrdinal != Integer.MAX_VALUE) {
            int remappedElementOrdinal = this.ordinalRemapper.getMappedOrdinal(elementType, elementOrdinal);
            int hashCode = this.preserveHashPositions ? ((HollowSetOrdinalIterator)ordinalIterator).getCurrentBucket() : remappedElementOrdinal;
            rec.addElement(remappedElementOrdinal, hashCode);
            elementOrdinal = ordinalIterator.next();
        }
        return rec;
    }

    private HollowSetTypeReadState readState() {
        return (HollowSetTypeReadState)this.readTypeState;
    }

    private HollowSetWriteRecord rec() {
        return (HollowSetWriteRecord)this.writeRecord;
    }
}

