/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.ThreadSafeBitSet;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteStateEnginePrimaryKeyHasher;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HollowSetTypeWriteState
extends HollowTypeWriteState {
    private static final Logger LOG = Logger.getLogger(HollowSetTypeWriteState.class.getName());
    private int bitsPerSetPointer;
    private int revBitsPerSetPointer;
    private int bitsPerElement;
    private int bitsPerSetSizeValue;
    private long[] totalOfSetBuckets;
    private long[] revTotalOfSetBuckets;
    private FixedLengthElementArray[] setPointersAndSizesArray;
    private FixedLengthElementArray[] elementArray;
    private int[] numSetsInDelta;
    private long[] numBucketsInDelta;
    private ByteDataArray[] deltaAddedOrdinals;
    private ByteDataArray[] deltaRemovedOrdinals;

    public HollowSetTypeWriteState(HollowSetSchema schema) {
        this(schema, -1);
    }

    public HollowSetTypeWriteState(HollowSetSchema schema, int numShards) {
        super(schema, numShards);
    }

    @Override
    public HollowSetSchema getSchema() {
        return (HollowSetSchema)this.schema;
    }

    @Override
    public void prepareForWrite(boolean canReshard) {
        super.prepareForWrite(canReshard);
        this.maxOrdinal = this.ordinalMap.maxOrdinal();
        this.gatherShardingStats(this.maxOrdinal, canReshard);
        this.gatherStatistics(this.numShards != this.revNumShards);
    }

    private void gatherStatistics(boolean numShardsChanged) {
        int maxElementOrdinal = 0;
        int maxSetSize = 0;
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        this.totalOfSetBuckets = new long[this.numShards];
        if (numShardsChanged) {
            this.revTotalOfSetBuckets = new long[this.revNumShards];
        }
        for (int i = 0; i <= this.maxOrdinal; ++i) {
            if (!this.currentCyclePopulated.get(i) && !this.previousCyclePopulated.get(i)) continue;
            long pointer = this.ordinalMap.getPointerForData(i);
            int size = VarInt.readVInt(data, pointer);
            int numBuckets = HashCodes.hashTableSize(size);
            if (size > maxSetSize) {
                maxSetSize = size;
            }
            pointer += (long)VarInt.sizeOfVInt(size);
            int elementOrdinal = 0;
            for (int j = 0; j < size; ++j) {
                int elementOrdinalDelta = VarInt.readVInt(data, pointer);
                if ((elementOrdinal += elementOrdinalDelta) > maxElementOrdinal) {
                    maxElementOrdinal = elementOrdinal;
                }
                pointer += (long)VarInt.sizeOfVInt(elementOrdinalDelta);
                pointer += (long)VarInt.nextVLongSize(data, pointer);
            }
            int n = i & this.numShards - 1;
            this.totalOfSetBuckets[n] = this.totalOfSetBuckets[n] + (long)numBuckets;
            if (!numShardsChanged) continue;
            int n2 = i & this.revNumShards - 1;
            this.revTotalOfSetBuckets[n2] = this.revTotalOfSetBuckets[n2] + (long)numBuckets;
        }
        long maxShardTotalOfSetBuckets = 0L;
        for (int i = 0; i < this.numShards; ++i) {
            if (this.totalOfSetBuckets[i] <= maxShardTotalOfSetBuckets) continue;
            maxShardTotalOfSetBuckets = this.totalOfSetBuckets[i];
        }
        this.bitsPerElement = 64 - Long.numberOfLeadingZeros(maxElementOrdinal + 1);
        this.bitsPerSetSizeValue = 64 - Long.numberOfLeadingZeros(maxSetSize);
        this.bitsPerSetPointer = 64 - Long.numberOfLeadingZeros(maxShardTotalOfSetBuckets);
        if (numShardsChanged) {
            long revMaxShardTotalOfSetBuckets = 0L;
            for (int i = 0; i < this.revNumShards; ++i) {
                if (this.revTotalOfSetBuckets[i] <= revMaxShardTotalOfSetBuckets) continue;
                revMaxShardTotalOfSetBuckets = this.revTotalOfSetBuckets[i];
            }
            this.revBitsPerSetPointer = 64 - Long.numberOfLeadingZeros(revMaxShardTotalOfSetBuckets);
        }
    }

    @Override
    protected int typeStateNumShards(int maxOrdinal) {
        int maxSetSize = 0;
        int maxElementOrdinal = 0;
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        long totalOfSetBuckets = 0L;
        for (int i = 0; i <= maxOrdinal; ++i) {
            if (!this.currentCyclePopulated.get(i) && !this.previousCyclePopulated.get(i)) continue;
            long pointer = this.ordinalMap.getPointerForData(i);
            int size = VarInt.readVInt(data, pointer);
            int numBuckets = HashCodes.hashTableSize(size);
            if (size > maxSetSize) {
                maxSetSize = size;
            }
            pointer += (long)VarInt.sizeOfVInt(size);
            int elementOrdinal = 0;
            for (int j = 0; j < size; ++j) {
                int elementOrdinalDelta = VarInt.readVInt(data, pointer);
                if ((elementOrdinal += elementOrdinalDelta) > maxElementOrdinal) {
                    maxElementOrdinal = elementOrdinal;
                }
                pointer += (long)VarInt.sizeOfVInt(elementOrdinalDelta);
                pointer += (long)VarInt.nextVLongSize(data, pointer);
            }
            totalOfSetBuckets += (long)numBuckets;
        }
        long bitsPerElement = 64 - Long.numberOfLeadingZeros(maxElementOrdinal + 1);
        long bitsPerSetSizeValue = 64 - Long.numberOfLeadingZeros(maxSetSize);
        long bitsPerSetPointer = 64 - Long.numberOfLeadingZeros(totalOfSetBuckets);
        long projectedSizeOfType = (bitsPerSetSizeValue + bitsPerSetPointer) * (long)(maxOrdinal + 1) / 8L;
        projectedSizeOfType += bitsPerElement * totalOfSetBuckets / 8L;
        int targetNumShards = 1;
        while (this.stateEngine.getTargetMaxTypeShardSize() * (long)targetNumShards < projectedSizeOfType) {
            targetNumShards *= 2;
        }
        return targetNumShards;
    }

    @Override
    public void calculateSnapshot() {
        int bitsPerSetFixedLengthPortion = this.bitsPerSetSizeValue + this.bitsPerSetPointer;
        this.setPointersAndSizesArray = new FixedLengthElementArray[this.numShards];
        this.elementArray = new FixedLengthElementArray[this.numShards];
        for (int i = 0; i < this.numShards; ++i) {
            this.setPointersAndSizesArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)bitsPerSetFixedLengthPortion * (long)(this.maxShardOrdinal[i] + 1));
            this.elementArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)this.bitsPerElement * this.totalOfSetBuckets[i]);
        }
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        int[] bucketCounter = new int[this.numShards];
        int shardMask = this.numShards - 1;
        HollowWriteStateEnginePrimaryKeyHasher primaryKeyHasher = null;
        if (this.getSchema().getHashKey() != null) {
            try {
                primaryKeyHasher = new HollowWriteStateEnginePrimaryKeyHasher(this.getSchema().getHashKey(), this.getStateEngine());
            }
            catch (FieldPaths.FieldPathException e) {
                if (e.error == FieldPaths.FieldPathException.ErrorKind.NOT_BINDABLE) {
                    LOG.log(Level.WARNING, "Failed to create a key hasher for " + this.getSchema().getHashKey() + " because a field could not be bound to a type in the state");
                }
                throw e;
            }
        }
        for (int ordinal = 0; ordinal <= this.maxOrdinal; ++ordinal) {
            int shardNumber = ordinal & shardMask;
            int shardOrdinal = ordinal / this.numShards;
            if (this.currentCyclePopulated.get(ordinal)) {
                int j;
                long readPointer = this.ordinalMap.getPointerForData(ordinal);
                int size = VarInt.readVInt(data, readPointer);
                readPointer += (long)VarInt.sizeOfVInt(size);
                int numBuckets = HashCodes.hashTableSize(size);
                this.setPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerSetFixedLengthPortion * (long)shardOrdinal + (long)this.bitsPerSetPointer, this.bitsPerSetSizeValue, size);
                int elementOrdinal = 0;
                for (j = 0; j < numBuckets; ++j) {
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * (long)(bucketCounter[shardNumber] + j), this.bitsPerElement, (1L << this.bitsPerElement) - 1L);
                }
                for (j = 0; j < size; ++j) {
                    int elementOrdinalDelta = VarInt.readVInt(data, readPointer);
                    int hashedBucket = VarInt.readVInt(data, readPointer += (long)VarInt.sizeOfVInt(elementOrdinalDelta));
                    readPointer += (long)VarInt.sizeOfVInt(hashedBucket);
                    elementOrdinal += elementOrdinalDelta;
                    if (primaryKeyHasher != null) {
                        hashedBucket = primaryKeyHasher.getRecordHash(elementOrdinal) & numBuckets - 1;
                    }
                    while (this.elementArray[shardNumber].getElementValue((long)this.bitsPerElement * (long)(bucketCounter[shardNumber] + hashedBucket), this.bitsPerElement) != (1L << this.bitsPerElement) - 1L) {
                        ++hashedBucket;
                        hashedBucket &= numBuckets - 1;
                    }
                    this.elementArray[shardNumber].clearElementValue((long)this.bitsPerElement * (long)(bucketCounter[shardNumber] + hashedBucket), this.bitsPerElement);
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * (long)(bucketCounter[shardNumber] + hashedBucket), this.bitsPerElement, elementOrdinal);
                }
                int n = shardNumber;
                bucketCounter[n] = bucketCounter[n] + numBuckets;
            }
            this.setPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerSetFixedLengthPortion * (long)shardOrdinal, this.bitsPerSetPointer, bucketCounter[shardNumber]);
        }
    }

    @Override
    public void writeSnapshot(DataOutputStream os) throws IOException {
        if (this.numShards == 1) {
            this.writeSnapshotShard(os, 0);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < this.numShards; ++i) {
                this.writeSnapshotShard(os, i);
            }
        }
        this.currentCyclePopulated.serializeBitsTo(os);
        this.setPointersAndSizesArray = null;
        this.elementArray = null;
    }

    private void writeSnapshotShard(DataOutputStream os, int shardNumber) throws IOException {
        int bitsPerSetFixedLengthPortion = this.bitsPerSetSizeValue + this.bitsPerSetPointer;
        VarInt.writeVInt(os, this.maxShardOrdinal[shardNumber]);
        VarInt.writeVInt(os, this.bitsPerSetPointer);
        VarInt.writeVInt(os, this.bitsPerSetSizeValue);
        VarInt.writeVInt(os, this.bitsPerElement);
        VarInt.writeVLong(os, this.totalOfSetBuckets[shardNumber]);
        int numSetFixedLengthLongs = this.maxShardOrdinal[shardNumber] == -1 ? 0 : (int)(((long)(this.maxShardOrdinal[shardNumber] + 1) * (long)bitsPerSetFixedLengthPortion - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numSetFixedLengthLongs);
        for (int i = 0; i < numSetFixedLengthLongs; ++i) {
            os.writeLong(this.setPointersAndSizesArray[shardNumber].get(i));
        }
        int numElementLongs = this.totalOfSetBuckets[shardNumber] == 0L ? 0 : (int)((this.totalOfSetBuckets[shardNumber] * (long)this.bitsPerElement - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numElementLongs);
        for (int i = 0; i < numElementLongs; ++i) {
            os.writeLong(this.elementArray[shardNumber].get(i));
        }
    }

    @Override
    public void calculateDelta(ThreadSafeBitSet fromCyclePopulated, ThreadSafeBitSet toCyclePopulated, boolean isReverse) {
        int numShards = this.numShards;
        int bitsPerSetPointer = this.bitsPerSetPointer;
        if (isReverse && numShards != this.revNumShards) {
            numShards = this.revNumShards;
            bitsPerSetPointer = this.revBitsPerSetPointer;
        }
        int bitsPerSetFixedLengthPortion = this.bitsPerSetSizeValue + bitsPerSetPointer;
        this.numSetsInDelta = new int[numShards];
        this.numBucketsInDelta = new long[numShards];
        this.setPointersAndSizesArray = new FixedLengthElementArray[numShards];
        this.elementArray = new FixedLengthElementArray[numShards];
        this.deltaAddedOrdinals = new ByteDataArray[numShards];
        this.deltaRemovedOrdinals = new ByteDataArray[numShards];
        ThreadSafeBitSet deltaAdditions = toCyclePopulated.andNot(fromCyclePopulated);
        int shardMask = numShards - 1;
        int addedOrdinal = deltaAdditions.nextSetBit(0);
        while (addedOrdinal != -1) {
            int n = addedOrdinal & shardMask;
            this.numSetsInDelta[n] = this.numSetsInDelta[n] + 1;
            long readPointer = this.ordinalMap.getPointerForData(addedOrdinal);
            int size = VarInt.readVInt(this.ordinalMap.getByteData().getUnderlyingArray(), readPointer);
            int n2 = addedOrdinal & shardMask;
            this.numBucketsInDelta[n2] = this.numBucketsInDelta[n2] + (long)HashCodes.hashTableSize(size);
            addedOrdinal = deltaAdditions.nextSetBit(addedOrdinal + 1);
        }
        for (int i = 0; i < numShards; ++i) {
            this.setPointersAndSizesArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)this.numSetsInDelta[i] * (long)bitsPerSetFixedLengthPortion);
            this.elementArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, this.numBucketsInDelta[i] * (long)this.bitsPerElement);
            this.deltaAddedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
            this.deltaRemovedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
        }
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        int[] setCounter = new int[numShards];
        long[] bucketCounter = new long[numShards];
        int[] previousRemovedOrdinal = new int[numShards];
        int[] previousAddedOrdinal = new int[numShards];
        HollowWriteStateEnginePrimaryKeyHasher primaryKeyHasher = null;
        if (this.getSchema().getHashKey() != null) {
            try {
                primaryKeyHasher = new HollowWriteStateEnginePrimaryKeyHasher(this.getSchema().getHashKey(), this.getStateEngine());
            }
            catch (FieldPaths.FieldPathException e) {
                if (e.error == FieldPaths.FieldPathException.ErrorKind.NOT_BINDABLE) {
                    LOG.log(Level.WARNING, "Failed to create a key hasher for " + this.getSchema().getHashKey() + " because a field could not be bound to a type in the state");
                }
                throw e;
            }
        }
        for (int ordinal = 0; ordinal <= this.maxOrdinal; ++ordinal) {
            int shardNumber = ordinal & shardMask;
            if (deltaAdditions.get(ordinal)) {
                int j;
                long readPointer = this.ordinalMap.getPointerForData(ordinal);
                int size = VarInt.readVInt(data, readPointer);
                readPointer += (long)VarInt.sizeOfVInt(size);
                int numBuckets = HashCodes.hashTableSize(size);
                long endBucketPosition = bucketCounter[shardNumber] + (long)numBuckets;
                this.setPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerSetFixedLengthPortion * (long)setCounter[shardNumber], bitsPerSetPointer, endBucketPosition);
                this.setPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerSetFixedLengthPortion * (long)setCounter[shardNumber] + (long)bitsPerSetPointer, this.bitsPerSetSizeValue, size);
                int elementOrdinal = 0;
                for (j = 0; j < numBuckets; ++j) {
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * (bucketCounter[shardNumber] + (long)j), this.bitsPerElement, (1L << this.bitsPerElement) - 1L);
                }
                for (j = 0; j < size; ++j) {
                    int elementOrdinalDelta = VarInt.readVInt(data, readPointer);
                    int hashedBucket = VarInt.readVInt(data, readPointer += (long)VarInt.sizeOfVInt(elementOrdinalDelta));
                    readPointer += (long)VarInt.sizeOfVInt(hashedBucket);
                    elementOrdinal += elementOrdinalDelta;
                    if (primaryKeyHasher != null) {
                        hashedBucket = primaryKeyHasher.getRecordHash(elementOrdinal) & numBuckets - 1;
                    }
                    while (this.elementArray[shardNumber].getElementValue((long)this.bitsPerElement * (bucketCounter[shardNumber] + (long)hashedBucket), this.bitsPerElement) != (1L << this.bitsPerElement) - 1L) {
                        ++hashedBucket;
                        hashedBucket &= numBuckets - 1;
                    }
                    this.elementArray[shardNumber].clearElementValue((long)this.bitsPerElement * (bucketCounter[shardNumber] + (long)hashedBucket), this.bitsPerElement);
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * (bucketCounter[shardNumber] + (long)hashedBucket), this.bitsPerElement, elementOrdinal);
                }
                int n = shardNumber;
                bucketCounter[n] = bucketCounter[n] + (long)numBuckets;
                int n3 = shardNumber;
                setCounter[n3] = setCounter[n3] + 1;
                int shardOrdinal = ordinal / numShards;
                VarInt.writeVInt(this.deltaAddedOrdinals[shardNumber], shardOrdinal - previousAddedOrdinal[shardNumber]);
                previousAddedOrdinal[shardNumber] = shardOrdinal;
                continue;
            }
            if (!fromCyclePopulated.get(ordinal) || toCyclePopulated.get(ordinal)) continue;
            int shardOrdinal = ordinal / numShards;
            VarInt.writeVInt(this.deltaRemovedOrdinals[shardNumber], shardOrdinal - previousRemovedOrdinal[shardNumber]);
            previousRemovedOrdinal[shardNumber] = shardOrdinal;
        }
    }

    @Override
    public void writeCalculatedDelta(DataOutputStream os, boolean isReverse, int[] maxShardOrdinal) throws IOException {
        int numShards = this.numShards;
        int bitsPerSetPointer = this.bitsPerSetPointer;
        long[] totalOfSetBuckets = this.totalOfSetBuckets;
        if (isReverse && numShards != this.revNumShards) {
            numShards = this.revNumShards;
            bitsPerSetPointer = this.revBitsPerSetPointer;
            totalOfSetBuckets = this.revTotalOfSetBuckets;
        }
        if (numShards == 1) {
            this.writeCalculatedDeltaShard(os, 0, maxShardOrdinal, bitsPerSetPointer, totalOfSetBuckets);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < numShards; ++i) {
                this.writeCalculatedDeltaShard(os, i, maxShardOrdinal, bitsPerSetPointer, totalOfSetBuckets);
            }
        }
        this.setPointersAndSizesArray = null;
        this.elementArray = null;
        this.deltaAddedOrdinals = null;
        this.deltaRemovedOrdinals = null;
    }

    private void writeCalculatedDeltaShard(DataOutputStream os, int shardNumber, int[] maxShardOrdinal, int bitsPerSetPointer, long[] totalOfSetBuckets) throws IOException {
        int bitsPerSetFixedLengthPortion = this.bitsPerSetSizeValue + bitsPerSetPointer;
        VarInt.writeVInt(os, maxShardOrdinal[shardNumber]);
        VarInt.writeVLong(os, this.deltaRemovedOrdinals[shardNumber].length());
        this.deltaRemovedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaRemovedOrdinals[shardNumber].length());
        VarInt.writeVLong(os, this.deltaAddedOrdinals[shardNumber].length());
        this.deltaAddedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaAddedOrdinals[shardNumber].length());
        VarInt.writeVInt(os, bitsPerSetPointer);
        VarInt.writeVInt(os, this.bitsPerSetSizeValue);
        VarInt.writeVInt(os, this.bitsPerElement);
        VarInt.writeVLong(os, totalOfSetBuckets[shardNumber]);
        int numSetFixedLengthLongs = this.numSetsInDelta[shardNumber] == 0 ? 0 : (int)(((long)this.numSetsInDelta[shardNumber] * (long)bitsPerSetFixedLengthPortion - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numSetFixedLengthLongs);
        for (int i = 0; i < numSetFixedLengthLongs; ++i) {
            os.writeLong(this.setPointersAndSizesArray[shardNumber].get(i));
        }
        int numElementLongs = this.numBucketsInDelta[shardNumber] == 0L ? 0 : (int)((this.numBucketsInDelta[shardNumber] * (long)this.bitsPerElement - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numElementLongs);
        for (int i = 0; i < numElementLongs; ++i) {
            os.writeLong(this.elementArray[shardNumber].get(i));
        }
    }
}

