/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.encoding.ZigZag;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.HollowWriteRecord;

public class HollowObjectWriteRecord
implements HollowWriteRecord {
    private final HollowObjectSchema schema;
    private final ByteDataArray[] fieldData;
    private final boolean[] isNonNull;
    public static final int NULL_FLOAT_BITS = Float.floatToIntBits(Float.NaN) + 1;
    public static final long NULL_DOUBLE_BITS = Double.doubleToLongBits(Double.NaN) + 1L;

    public HollowObjectWriteRecord(HollowObjectSchema schema) {
        this.schema = schema;
        this.fieldData = new ByteDataArray[schema.numFields()];
        this.isNonNull = new boolean[schema.numFields()];
        for (int i = 0; i < this.fieldData.length; ++i) {
            this.fieldData[i] = new ByteDataArray(WastefulRecycler.SMALL_ARRAY_RECYCLER);
        }
    }

    public HollowObjectSchema getSchema() {
        return this.schema;
    }

    @Override
    public void writeDataTo(ByteDataArray buf) {
        for (int i = 0; i < this.fieldData.length; ++i) {
            this.writeField(buf, i);
        }
    }

    public void writeDataTo(ByteDataArray buf, HollowObjectSchema translate) {
        for (int i = 0; i < translate.numFields(); ++i) {
            int fieldIndex = this.schema.getPosition(translate.getFieldName(i));
            if (fieldIndex != -1) {
                this.writeField(buf, fieldIndex);
                continue;
            }
            this.writeNull(buf, translate.getFieldType(i));
        }
    }

    private void writeField(ByteDataArray buf, int fieldIndex) {
        if (this.isNonNull[fieldIndex]) {
            if (this.getSchema().getFieldType(fieldIndex).isVariableLength()) {
                VarInt.writeVInt(buf, (int)this.fieldData[fieldIndex].length());
            }
            this.fieldData[fieldIndex].copyTo(buf);
        } else {
            this.writeNull(buf, this.schema.getFieldType(fieldIndex));
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.fieldData.length; ++i) {
            this.isNonNull[i] = false;
        }
    }

    public void setNull(String fieldName) {
        int fieldIndex = this.getSchema().getPosition(fieldName);
        ByteDataArray fieldBuffer = this.getFieldBuffer(fieldIndex);
        HollowObjectSchema.FieldType fieldType = this.getSchema().getFieldType(fieldIndex);
        this.writeNull(fieldBuffer, fieldType);
    }

    public void setInt(String fieldName, int value) {
        if (value == Integer.MIN_VALUE) {
            this.setNull(fieldName);
        } else {
            int fieldIndex = this.getSchema().getPosition(fieldName);
            this.validateFieldType(fieldIndex, fieldName, HollowObjectSchema.FieldType.INT);
            ByteDataArray buf = this.getFieldBuffer(fieldIndex);
            VarInt.writeVInt(buf, ZigZag.encodeInt(value));
        }
    }

    public void setLong(String fieldName, long value) {
        if (value == Long.MIN_VALUE) {
            this.setNull(fieldName);
        } else {
            int fieldIndex = this.getSchema().getPosition(fieldName);
            this.validateFieldType(fieldIndex, fieldName, HollowObjectSchema.FieldType.LONG);
            ByteDataArray buf = this.getFieldBuffer(fieldIndex);
            VarInt.writeVLong(buf, ZigZag.encodeLong(value));
        }
    }

    public void setFloat(String fieldName, float value) {
        int fieldIndex = this.getSchema().getPosition(fieldName);
        this.validateFieldType(fieldIndex, fieldName, HollowObjectSchema.FieldType.FLOAT);
        ByteDataArray buf = this.getFieldBuffer(fieldIndex);
        int intBits = Float.floatToIntBits(value);
        HollowObjectWriteRecord.writeFixedLengthInt(buf, intBits);
    }

    public void setDouble(String fieldName, double value) {
        int fieldIndex = this.getSchema().getPosition(fieldName);
        this.validateFieldType(fieldIndex, fieldName, HollowObjectSchema.FieldType.DOUBLE);
        ByteDataArray buf = this.getFieldBuffer(fieldIndex);
        long longBits = Double.doubleToLongBits(value);
        HollowObjectWriteRecord.writeFixedLengthLong(buf, longBits);
    }

    public void setBoolean(String fieldName, boolean value) {
        int fieldIndex = this.getSchema().getPosition(fieldName);
        this.validateFieldType(fieldIndex, fieldName, HollowObjectSchema.FieldType.BOOLEAN);
        ByteDataArray buf = this.getFieldBuffer(fieldIndex);
        buf.write(value ? (byte)1 : 0);
    }

    public void setBytes(String fieldName, byte[] value) {
        if (value == null) {
            return;
        }
        int fieldIndex = this.getSchema().getPosition(fieldName);
        this.validateFieldType(fieldIndex, fieldName, HollowObjectSchema.FieldType.BYTES);
        ByteDataArray buf = this.getFieldBuffer(fieldIndex);
        for (int i = 0; i < value.length; ++i) {
            buf.write(value[i]);
        }
    }

    public void setString(String fieldName, String value) {
        if (value == null) {
            return;
        }
        int fieldIndex = this.getSchema().getPosition(fieldName);
        this.validateFieldType(fieldIndex, fieldName, HollowObjectSchema.FieldType.STRING);
        ByteDataArray buf = this.getFieldBuffer(fieldIndex);
        for (int i = 0; i < value.length(); ++i) {
            VarInt.writeVInt(buf, (int)value.charAt(i));
        }
    }

    public void setReference(String fieldName, int ordinal) {
        int fieldIndex = this.getSchema().getPosition(fieldName);
        this.validateFieldType(fieldIndex, fieldName, HollowObjectSchema.FieldType.REFERENCE);
        ByteDataArray buf = this.getFieldBuffer(fieldIndex);
        VarInt.writeVInt(buf, ordinal);
    }

    private void writeNull(ByteDataArray buf, HollowObjectSchema.FieldType fieldType) {
        if (fieldType == HollowObjectSchema.FieldType.FLOAT) {
            HollowObjectWriteRecord.writeNullFloat(buf);
        } else if (fieldType == HollowObjectSchema.FieldType.DOUBLE) {
            HollowObjectWriteRecord.writeNullDouble(buf);
        } else {
            VarInt.writeVNull(buf);
        }
    }

    private ByteDataArray getFieldBuffer(int fieldPosition) {
        this.isNonNull[fieldPosition] = true;
        this.fieldData[fieldPosition].reset();
        return this.fieldData[fieldPosition];
    }

    private static void writeNullFloat(ByteDataArray fieldBuffer) {
        HollowObjectWriteRecord.writeFixedLengthInt(fieldBuffer, NULL_FLOAT_BITS);
    }

    private static void writeFixedLengthInt(ByteDataArray fieldBuffer, int intBits) {
        fieldBuffer.write((byte)(intBits >>> 24));
        fieldBuffer.write((byte)(intBits >>> 16));
        fieldBuffer.write((byte)(intBits >>> 8));
        fieldBuffer.write((byte)intBits);
    }

    private static void writeNullDouble(ByteDataArray fieldBuffer) {
        HollowObjectWriteRecord.writeFixedLengthLong(fieldBuffer, NULL_DOUBLE_BITS);
    }

    private static void writeFixedLengthLong(ByteDataArray fieldBuffer, long intBits) {
        fieldBuffer.write((byte)(intBits >>> 56));
        fieldBuffer.write((byte)(intBits >>> 48));
        fieldBuffer.write((byte)(intBits >>> 40));
        fieldBuffer.write((byte)(intBits >>> 32));
        fieldBuffer.write((byte)(intBits >>> 24));
        fieldBuffer.write((byte)(intBits >>> 16));
        fieldBuffer.write((byte)(intBits >>> 8));
        fieldBuffer.write((byte)intBits);
    }

    private void validateFieldType(int fieldIndex, String fieldName, HollowObjectSchema.FieldType attemptedFieldType) {
        if (this.getSchema().getFieldType(fieldIndex) != attemptedFieldType) {
            throw new IllegalArgumentException("Attempting to serialize " + (Object)((Object)attemptedFieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + this.getSchema().getName() + ".");
        }
    }
}

