/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.ThreadSafeBitSet;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import java.io.DataOutputStream;
import java.io.IOException;

public class HollowListTypeWriteState
extends HollowTypeWriteState {
    private int bitsPerListPointer;
    private int revBitsPerListPointer;
    private int bitsPerElement;
    private long[] totalOfListSizes;
    private long[] revTotalOfListSizes;
    private FixedLengthElementArray[] listPointerArray;
    private FixedLengthElementArray[] elementArray;
    private int[] numListsInDelta;
    private long[] numElementsInDelta;
    private ByteDataArray[] deltaAddedOrdinals;
    private ByteDataArray[] deltaRemovedOrdinals;

    public HollowListTypeWriteState(HollowListSchema schema) {
        this(schema, -1);
    }

    public HollowListTypeWriteState(HollowListSchema schema, int numShards) {
        super(schema, numShards);
    }

    @Override
    public HollowListSchema getSchema() {
        return (HollowListSchema)this.schema;
    }

    @Override
    public void prepareForWrite(boolean canReshard) {
        super.prepareForWrite(canReshard);
        this.maxOrdinal = this.ordinalMap.maxOrdinal();
        this.gatherShardingStats(this.maxOrdinal, canReshard);
        this.gatherStatistics(this.numShards != this.revNumShards);
    }

    private void gatherStatistics(boolean numShardsChanged) {
        int maxElementOrdinal = 0;
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        this.totalOfListSizes = new long[this.numShards];
        if (numShardsChanged) {
            this.revTotalOfListSizes = new long[this.revNumShards];
        }
        for (int i = 0; i <= this.maxOrdinal; ++i) {
            if (!this.currentCyclePopulated.get(i) && !this.previousCyclePopulated.get(i)) continue;
            long pointer = this.ordinalMap.getPointerForData(i);
            int size = VarInt.readVInt(data, pointer);
            pointer += (long)VarInt.sizeOfVInt(size);
            for (int j = 0; j < size; ++j) {
                int elementOrdinal = VarInt.readVInt(data, pointer);
                if (elementOrdinal > maxElementOrdinal) {
                    maxElementOrdinal = elementOrdinal;
                }
                pointer += (long)VarInt.sizeOfVInt(elementOrdinal);
            }
            int n = i & this.numShards - 1;
            this.totalOfListSizes[n] = this.totalOfListSizes[n] + (long)size;
            if (!numShardsChanged) continue;
            int n2 = i & this.revNumShards - 1;
            this.revTotalOfListSizes[n2] = this.revTotalOfListSizes[n2] + (long)size;
        }
        long maxShardTotalOfListSizes = 0L;
        for (int i = 0; i < this.numShards; ++i) {
            if (this.totalOfListSizes[i] <= maxShardTotalOfListSizes) continue;
            maxShardTotalOfListSizes = this.totalOfListSizes[i];
        }
        this.bitsPerElement = maxElementOrdinal == 0 ? 1 : 64 - Long.numberOfLeadingZeros(maxElementOrdinal);
        int n = this.bitsPerListPointer = maxShardTotalOfListSizes == 0L ? 1 : 64 - Long.numberOfLeadingZeros(maxShardTotalOfListSizes);
        if (numShardsChanged) {
            long revMaxShardTotalOfListSizes = 0L;
            for (int i = 0; i < this.revNumShards; ++i) {
                if (this.revTotalOfListSizes[i] <= revMaxShardTotalOfListSizes) continue;
                revMaxShardTotalOfListSizes = this.revTotalOfListSizes[i];
            }
            this.revBitsPerListPointer = revMaxShardTotalOfListSizes == 0L ? 1 : 64 - Long.numberOfLeadingZeros(revMaxShardTotalOfListSizes);
        }
    }

    @Override
    protected int typeStateNumShards(int maxOrdinal) {
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        long maxElementOrdinal = 0L;
        long totalOfListSizes = 0L;
        for (int i = 0; i <= maxOrdinal; ++i) {
            if (!this.currentCyclePopulated.get(i) && !this.previousCyclePopulated.get(i)) continue;
            long pointer = this.ordinalMap.getPointerForData(i);
            int size = VarInt.readVInt(data, pointer);
            pointer += (long)VarInt.sizeOfVInt(size);
            for (int j = 0; j < size; ++j) {
                int elementOrdinal = VarInt.readVInt(data, pointer);
                if ((long)elementOrdinal > maxElementOrdinal) {
                    maxElementOrdinal = elementOrdinal;
                }
                pointer += (long)VarInt.sizeOfVInt(elementOrdinal);
            }
            totalOfListSizes += (long)size;
        }
        long bitsPerElement = maxElementOrdinal == 0L ? 1L : (long)(64 - Long.numberOfLeadingZeros(maxElementOrdinal));
        long bitsPerListPointer = totalOfListSizes == 0L ? 1L : (long)(64 - Long.numberOfLeadingZeros(totalOfListSizes));
        long projectedSizeOfType = bitsPerElement * totalOfListSizes / 8L;
        projectedSizeOfType += (bitsPerListPointer * (long)maxOrdinal + 1L) / 8L;
        int targetNumShards = 1;
        while (this.stateEngine.getTargetMaxTypeShardSize() * (long)targetNumShards < projectedSizeOfType) {
            targetNumShards *= 2;
        }
        return targetNumShards;
    }

    @Override
    public void calculateSnapshot() {
        this.listPointerArray = new FixedLengthElementArray[this.numShards];
        this.elementArray = new FixedLengthElementArray[this.numShards];
        for (int i = 0; i < this.numShards; ++i) {
            this.listPointerArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)this.bitsPerListPointer * (long)(this.maxShardOrdinal[i] + 1));
            this.elementArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)this.bitsPerElement * this.totalOfListSizes[i]);
        }
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        long[] elementCounter = new long[this.numShards];
        int shardMask = this.numShards - 1;
        for (int ordinal = 0; ordinal <= this.maxOrdinal; ++ordinal) {
            int shardNumber = ordinal & shardMask;
            int shardOrdinal = ordinal / this.numShards;
            if (this.currentCyclePopulated.get(ordinal)) {
                long readPointer = this.ordinalMap.getPointerForData(ordinal);
                int size = VarInt.readVInt(data, readPointer);
                readPointer += (long)VarInt.sizeOfVInt(size);
                for (int j = 0; j < size; ++j) {
                    int elementOrdinal = VarInt.readVInt(data, readPointer);
                    readPointer += (long)VarInt.sizeOfVInt(elementOrdinal);
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * elementCounter[shardNumber], this.bitsPerElement, elementOrdinal);
                    int n = shardNumber;
                    elementCounter[n] = elementCounter[n] + 1L;
                }
            }
            this.listPointerArray[shardNumber].setElementValue((long)this.bitsPerListPointer * (long)shardOrdinal, this.bitsPerListPointer, elementCounter[shardNumber]);
        }
    }

    @Override
    public void writeSnapshot(DataOutputStream os) throws IOException {
        if (this.numShards == 1) {
            this.writeSnapshotShard(os, 0);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < this.numShards; ++i) {
                this.writeSnapshotShard(os, i);
            }
        }
        this.currentCyclePopulated.serializeBitsTo(os);
        this.listPointerArray = null;
        this.elementArray = null;
    }

    private void writeSnapshotShard(DataOutputStream os, int shardNumber) throws IOException {
        VarInt.writeVInt(os, this.maxShardOrdinal[shardNumber]);
        VarInt.writeVInt(os, this.bitsPerListPointer);
        VarInt.writeVInt(os, this.bitsPerElement);
        VarInt.writeVLong(os, this.totalOfListSizes[shardNumber]);
        int numListPointerLongs = this.maxShardOrdinal[shardNumber] == -1 ? 0 : (int)(((long)(this.maxShardOrdinal[shardNumber] + 1) * (long)this.bitsPerListPointer - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numListPointerLongs);
        for (int i = 0; i < numListPointerLongs; ++i) {
            os.writeLong(this.listPointerArray[shardNumber].get(i));
        }
        int numElementLongs = this.totalOfListSizes[shardNumber] == 0L ? 0 : (int)((this.totalOfListSizes[shardNumber] * (long)this.bitsPerElement - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numElementLongs);
        for (int i = 0; i < numElementLongs; ++i) {
            os.writeLong(this.elementArray[shardNumber].get(i));
        }
    }

    @Override
    public void calculateDelta(ThreadSafeBitSet fromCyclePopulated, ThreadSafeBitSet toCyclePopulated, boolean isReverse) {
        int numShards = this.numShards;
        int bitsPerListPointer = this.bitsPerListPointer;
        if (isReverse && this.numShards != this.revNumShards) {
            numShards = this.revNumShards;
            bitsPerListPointer = this.revBitsPerListPointer;
        }
        this.numListsInDelta = new int[numShards];
        this.numElementsInDelta = new long[numShards];
        this.listPointerArray = new FixedLengthElementArray[numShards];
        this.elementArray = new FixedLengthElementArray[numShards];
        this.deltaAddedOrdinals = new ByteDataArray[numShards];
        this.deltaRemovedOrdinals = new ByteDataArray[numShards];
        ThreadSafeBitSet deltaAdditions = toCyclePopulated.andNot(fromCyclePopulated);
        int shardMask = numShards - 1;
        int addedOrdinal = deltaAdditions.nextSetBit(0);
        while (addedOrdinal != -1) {
            int n = addedOrdinal & shardMask;
            this.numListsInDelta[n] = this.numListsInDelta[n] + 1;
            long readPointer = this.ordinalMap.getPointerForData(addedOrdinal);
            int n2 = addedOrdinal & shardMask;
            this.numElementsInDelta[n2] = this.numElementsInDelta[n2] + (long)VarInt.readVInt(this.ordinalMap.getByteData().getUnderlyingArray(), readPointer);
            addedOrdinal = deltaAdditions.nextSetBit(addedOrdinal + 1);
        }
        for (int i = 0; i < numShards; ++i) {
            this.listPointerArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)this.numListsInDelta[i] * (long)bitsPerListPointer);
            this.elementArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, this.numElementsInDelta[i] * (long)this.bitsPerElement);
            this.deltaAddedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
            this.deltaRemovedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
        }
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        int[] listCounter = new int[numShards];
        long[] elementCounter = new long[numShards];
        int[] previousRemovedOrdinal = new int[numShards];
        int[] previousAddedOrdinal = new int[numShards];
        for (int ordinal = 0; ordinal <= this.maxOrdinal; ++ordinal) {
            int shardNumber = ordinal & shardMask;
            if (deltaAdditions.get(ordinal)) {
                long readPointer = this.ordinalMap.getPointerForData(ordinal);
                int size = VarInt.readVInt(data, readPointer);
                readPointer += (long)VarInt.sizeOfVInt(size);
                this.listPointerArray[shardNumber].setElementValue((long)bitsPerListPointer * (long)listCounter[shardNumber], bitsPerListPointer, elementCounter[shardNumber] + (long)size);
                for (int j = 0; j < size; ++j) {
                    int elementOrdinal = VarInt.readVInt(data, readPointer);
                    readPointer += (long)VarInt.sizeOfVInt(elementOrdinal);
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * elementCounter[shardNumber], this.bitsPerElement, elementOrdinal);
                    int n = shardNumber;
                    elementCounter[n] = elementCounter[n] + 1L;
                }
                int n = shardNumber;
                listCounter[n] = listCounter[n] + 1;
                int shardOrdinal = ordinal / numShards;
                VarInt.writeVInt(this.deltaAddedOrdinals[shardNumber], shardOrdinal - previousAddedOrdinal[shardNumber]);
                previousAddedOrdinal[shardNumber] = shardOrdinal;
                continue;
            }
            if (!fromCyclePopulated.get(ordinal) || toCyclePopulated.get(ordinal)) continue;
            int shardOrdinal = ordinal / numShards;
            VarInt.writeVInt(this.deltaRemovedOrdinals[shardNumber], shardOrdinal - previousRemovedOrdinal[shardNumber]);
            previousRemovedOrdinal[shardNumber] = shardOrdinal;
        }
    }

    @Override
    public void writeCalculatedDelta(DataOutputStream os, boolean isReverse, int[] maxShardOrdinal) throws IOException {
        int numShards = this.numShards;
        int bitsPerListPointer = this.bitsPerListPointer;
        long[] totalOfListSizes = this.totalOfListSizes;
        if (isReverse && this.numShards != this.revNumShards) {
            numShards = this.revNumShards;
            bitsPerListPointer = this.revBitsPerListPointer;
            totalOfListSizes = this.revTotalOfListSizes;
        }
        if (numShards == 1) {
            this.writeCalculatedDeltaShard(os, 0, maxShardOrdinal, bitsPerListPointer, totalOfListSizes);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < numShards; ++i) {
                this.writeCalculatedDeltaShard(os, i, maxShardOrdinal, bitsPerListPointer, totalOfListSizes);
            }
        }
        this.listPointerArray = null;
        this.elementArray = null;
        this.deltaAddedOrdinals = null;
        this.deltaRemovedOrdinals = null;
    }

    private void writeCalculatedDeltaShard(DataOutputStream os, int shardNumber, int[] maxShardOrdinal, int bitsPerListPointer, long[] totalOfListSizes) throws IOException {
        VarInt.writeVInt(os, maxShardOrdinal[shardNumber]);
        VarInt.writeVLong(os, this.deltaRemovedOrdinals[shardNumber].length());
        this.deltaRemovedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaRemovedOrdinals[shardNumber].length());
        VarInt.writeVLong(os, this.deltaAddedOrdinals[shardNumber].length());
        this.deltaAddedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaAddedOrdinals[shardNumber].length());
        VarInt.writeVInt(os, bitsPerListPointer);
        VarInt.writeVInt(os, this.bitsPerElement);
        VarInt.writeVLong(os, totalOfListSizes[shardNumber]);
        int numListPointerLongs = this.numListsInDelta[shardNumber] == 0 ? 0 : (int)(((long)this.numListsInDelta[shardNumber] * (long)bitsPerListPointer - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numListPointerLongs);
        for (int i = 0; i < numListPointerLongs; ++i) {
            os.writeLong(this.listPointerArray[shardNumber].get(i));
        }
        int numElementLongs = this.numElementsInDelta[shardNumber] == 0L ? 0 : (int)((this.numElementsInDelta[shardNumber] * (long)this.bitsPerElement - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numElementLongs);
        for (int i = 0; i < numElementLongs; ++i) {
            os.writeLong(this.elementArray[shardNumber].get(i));
        }
    }
}

