/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntList {
    private int[] values;
    private int size;

    public IntList() {
        this(12);
    }

    public IntList(int initialSize) {
        this.values = new int[initialSize];
    }

    public int get(int index) {
        return this.values[index];
    }

    public void add(int value) {
        if (this.values.length == this.size) {
            this.values = Arrays.copyOf(this.values, this.values.length * 3 / 2);
        }
        this.values[this.size++] = value;
    }

    public void addAll(IntList list) {
        for (int i = 0; i < list.size; ++i) {
            this.add(list.get(i));
        }
    }

    public void set(int index, int value) {
        this.values[index] = value;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.size);
    }

    public int binarySearch(int value) {
        return Arrays.binarySearch(this.values, 0, this.size, value);
    }

    public void expandTo(int size) {
        if (this.values.length < size) {
            this.values = Arrays.copyOf(this.values, size);
        }
        this.size = size;
    }

    public void trim() {
        this.values = Arrays.copyOf(this.values, Math.max(this.size, 12));
    }

    public int[] arrayCopyOfRange(int beginIdx, int endIdx) {
        int[] arr = new int[endIdx - beginIdx];
        System.arraycopy(this.values, beginIdx, arr, 0, endIdx - beginIdx);
        return arr;
    }

    public boolean equals(Object other) {
        if (other instanceof IntList) {
            IntList that = (IntList)other;
            if (this.size() == that.size()) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.get(i) == that.get(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = this.size;
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public static Set<Integer> createSetFromIntList(IntList list) {
        if (Objects.isNull(list)) {
            return new HashSet<Integer>();
        }
        HashSet<Integer> result = new HashSet<Integer>(list.size());
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            result.add(list.get(i));
        }
        return result;
    }

    public static IntList createIntListFromSet(Set<Integer> set) {
        if (Objects.isNull(set)) {
            return new IntList(0);
        }
        IntList result = new IntList(set.size());
        for (int value : set) {
            result.add(value);
        }
        return result;
    }
}

