/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.HollowStateEngine;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HollowSchemaSorter {
    public static List<HollowSchema> dependencyOrderedSchemaList(HollowDataset dataset) {
        return HollowSchemaSorter.dependencyOrderedSchemaList(dataset.getSchemas());
    }

    public static List<HollowSchema> dependencyOrderedSchemaList(Collection<HollowSchema> schemas) {
        DependencyIndex idx = new DependencyIndex();
        HashMap<String, HollowSchema> schemaMap = new HashMap<String, HollowSchema>();
        for (HollowSchema schema : schemas) {
            schemaMap.put(schema.getName(), schema);
            idx.indexSchema(schema, schemas);
        }
        ArrayList<HollowSchema> orderedSchemas = new ArrayList<HollowSchema>();
        while (idx.hasMoreTypes()) {
            orderedSchemas.add((HollowSchema)schemaMap.get(idx.getNextType()));
        }
        return orderedSchemas;
    }

    public static boolean typeIsTransitivelyDependent(HollowStateEngine stateEngine, String dependentType, String dependencyType) {
        if (dependentType.equals(dependencyType)) {
            return true;
        }
        HollowSchema dependentTypeSchema = stateEngine.getSchema(dependentType);
        if (dependentTypeSchema == null) {
            return false;
        }
        switch (dependentTypeSchema.getSchemaType()) {
            case OBJECT: {
                HollowObjectSchema objectSchema = (HollowObjectSchema)dependentTypeSchema;
                for (int i = 0; i < objectSchema.numFields(); ++i) {
                    if (objectSchema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE || !HollowSchemaSorter.typeIsTransitivelyDependent(stateEngine, objectSchema.getReferencedType(i), dependencyType)) continue;
                    return true;
                }
                break;
            }
            case LIST: 
            case SET: {
                return HollowSchemaSorter.typeIsTransitivelyDependent(stateEngine, ((HollowCollectionSchema)dependentTypeSchema).getElementType(), dependencyType);
            }
            case MAP: {
                return HollowSchemaSorter.typeIsTransitivelyDependent(stateEngine, ((HollowMapSchema)dependentTypeSchema).getKeyType(), dependencyType) || HollowSchemaSorter.typeIsTransitivelyDependent(stateEngine, ((HollowMapSchema)dependentTypeSchema).getValueType(), dependencyType);
            }
        }
        return false;
    }

    private static class DependencyIndex {
        private final Map<String, Set<String>> dependencyIndex = new HashMap<String, Set<String>>();
        private final Map<String, Set<String>> reverseDependencyIndex = new HashMap<String, Set<String>>();

        public boolean hasMoreTypes() {
            for (Map.Entry<String, Set<String>> entry : this.dependencyIndex.entrySet()) {
                if (!entry.getValue().isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String getNextType() {
            ArrayList<String> availableTypes = new ArrayList<String>();
            for (Map.Entry<String, Set<String>> entry : this.dependencyIndex.entrySet()) {
                if (!entry.getValue().isEmpty()) continue;
                availableTypes.add(entry.getKey());
            }
            String firstAvailableType = (String)availableTypes.get(0);
            for (int i = 1; i < availableTypes.size(); ++i) {
                if (((String)availableTypes.get(i)).compareTo(firstAvailableType) >= 0) continue;
                firstAvailableType = (String)availableTypes.get(i);
            }
            this.removeType(firstAvailableType);
            return firstAvailableType;
        }

        private void indexSchema(HollowSchema schema, Collection<HollowSchema> allSchemas) {
            if (schema instanceof HollowCollectionSchema) {
                String elementType = ((HollowCollectionSchema)schema).getElementType();
                this.addDependency(schema.getName(), elementType, allSchemas);
            } else if (schema instanceof HollowMapSchema) {
                String keyType = ((HollowMapSchema)schema).getKeyType();
                String valueType = ((HollowMapSchema)schema).getValueType();
                this.addDependency(schema.getName(), keyType, allSchemas);
                this.addDependency(schema.getName(), valueType, allSchemas);
            } else if (schema instanceof HollowObjectSchema) {
                HollowObjectSchema objectSchema = (HollowObjectSchema)schema;
                for (int i = 0; i < objectSchema.numFields(); ++i) {
                    if (objectSchema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE) continue;
                    String refType = objectSchema.getReferencedType(i);
                    this.addDependency(schema.getName(), refType, allSchemas);
                }
            }
            this.getList(schema.getName(), this.dependencyIndex);
            this.getList(schema.getName(), this.reverseDependencyIndex);
        }

        private void removeType(String type) {
            Set<String> dependents = this.reverseDependencyIndex.remove(type);
            for (String dependent : dependents) {
                this.dependencyIndex.get(dependent).remove(type);
            }
            this.dependencyIndex.remove(type);
        }

        private void addDependency(String dependent, String dependency, Collection<HollowSchema> allSchemas) {
            if (this.schemaExists(dependency, allSchemas)) {
                this.getList(dependent, this.dependencyIndex).add(dependency);
                this.getList(dependency, this.reverseDependencyIndex).add(dependent);
            }
        }

        private boolean schemaExists(String schemaName, Collection<HollowSchema> allSchemas) {
            for (HollowSchema schema : allSchemas) {
                if (!schema.getName().equals(schemaName)) continue;
                return true;
            }
            return false;
        }

        private Set<String> getList(String key, Map<String, Set<String>> dependencyIndex2) {
            Set<String> list = dependencyIndex2.get(key);
            if (list == null) {
                list = new HashSet<String>();
                dependencyIndex2.put(key, list);
            }
            return list;
        }
    }
}

