/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.api.error.IncompatibleSchemaException;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.filter.TypeFilter;
import com.netflix.hollow.core.schema.HollowSchema;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HollowObjectSchema
extends HollowSchema {
    private final Map<String, Integer> nameFieldIndexLookup;
    private final String[] fieldNames;
    private final FieldType[] fieldTypes;
    protected final String[] referencedTypes;
    private final HollowTypeReadState[] referencedFieldTypeStates;
    private final PrimaryKey primaryKey;
    private int size;

    public HollowObjectSchema(String schemaName, int numFields, String ... keyFieldPaths) {
        this(schemaName, numFields, keyFieldPaths == null || keyFieldPaths.length == 0 ? null : new PrimaryKey(schemaName, keyFieldPaths));
    }

    public HollowObjectSchema(String schemaName, int numFields, PrimaryKey primaryKey) {
        super(schemaName);
        this.nameFieldIndexLookup = new HashMap<String, Integer>(numFields);
        this.fieldNames = new String[numFields];
        this.fieldTypes = new FieldType[numFields];
        this.referencedTypes = new String[numFields];
        this.referencedFieldTypeStates = new HollowTypeReadState[numFields];
        this.primaryKey = primaryKey;
    }

    public int numFields() {
        return this.size;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public int addField(String fieldName, FieldType fieldType) {
        return this.addField(fieldName, fieldType, null);
    }

    public int addField(String fieldName, FieldType fieldType, String referencedType) {
        if (fieldType == FieldType.REFERENCE && referencedType == null) {
            throw new RuntimeException("When adding a REFERENCE field to a schema, the referenced type must be provided.  Check type: " + this.getName() + " field: " + fieldName);
        }
        this.fieldNames[this.size] = fieldName;
        this.fieldTypes[this.size] = fieldType;
        this.referencedTypes[this.size] = referencedType;
        this.nameFieldIndexLookup.put(fieldName, this.size);
        ++this.size;
        return this.size - 1;
    }

    @Deprecated
    public int addField(String fieldName, FieldType fieldType, String referencedType, HollowTypeReadState referencedTypeState) {
        return this.addField(fieldName, fieldType, referencedType);
    }

    public int getPosition(String fieldName) {
        Integer index = this.nameFieldIndexLookup.get(fieldName);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public String getFieldName(int fieldPosition) {
        return this.fieldNames[fieldPosition];
    }

    public FieldType getFieldType(String fieldName) {
        int fieldPosition = this.getPosition(fieldName);
        if (fieldPosition == -1) {
            return null;
        }
        return this.getFieldType(fieldPosition);
    }

    public FieldType getFieldType(int fieldPosition) {
        return this.fieldTypes[fieldPosition];
    }

    public String getReferencedType(String fieldName) {
        int fieldPosition = this.getPosition(fieldName);
        if (fieldPosition == -1) {
            return null;
        }
        return this.getReferencedType(fieldPosition);
    }

    public String getReferencedType(int fieldPosition) {
        return this.referencedTypes[fieldPosition];
    }

    public void setReferencedTypeState(int fieldPosition, HollowTypeReadState state) {
        this.referencedFieldTypeStates[fieldPosition] = state;
    }

    public HollowTypeReadState getReferencedTypeState(int fieldPosition) {
        return this.referencedFieldTypeStates[fieldPosition];
    }

    public HollowObjectSchema findCommonSchema(HollowObjectSchema otherSchema) {
        if (!this.getName().equals(otherSchema.getName())) {
            throw new IllegalArgumentException("Cannot find common schema of two schemas with different names!");
        }
        int commonFields = 0;
        for (String fieldName : this.fieldNames) {
            if (otherSchema.getPosition(fieldName) == -1) continue;
            ++commonFields;
        }
        PrimaryKey primaryKey = HollowObjectSchema.isNullableObjectEquals(this.primaryKey, otherSchema.getPrimaryKey()) ? this.primaryKey : null;
        HollowObjectSchema commonSchema = new HollowObjectSchema(this.getName(), commonFields, primaryKey);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            int otherFieldIndex = otherSchema.getPosition(this.fieldNames[i]);
            if (otherFieldIndex == -1) continue;
            if (this.fieldTypes[i] != otherSchema.getFieldType(otherFieldIndex) || !this.referencedTypesEqual(this.referencedTypes[i], otherSchema.getReferencedType(otherFieldIndex))) {
                String fieldType = this.fieldTypes[i] == FieldType.REFERENCE ? this.referencedTypes[i] : this.fieldTypes[i].toString().toLowerCase();
                String otherFieldType = otherSchema.getFieldType(otherFieldIndex) == FieldType.REFERENCE ? otherSchema.getReferencedType(otherFieldIndex) : otherSchema.getFieldType(otherFieldIndex).toString().toLowerCase();
                throw new IncompatibleSchemaException(this.getName(), this.fieldNames[i], fieldType, otherFieldType);
            }
            commonSchema.addField(this.fieldNames[i], this.fieldTypes[i], this.referencedTypes[i]);
        }
        return commonSchema;
    }

    public HollowObjectSchema findUnionSchema(HollowObjectSchema otherSchema) {
        int i;
        if (!this.getName().equals(otherSchema.getName())) {
            throw new IllegalArgumentException("Cannot find common schema of two schemas with different names!");
        }
        int totalFields = otherSchema.numFields();
        for (String fieldName : this.fieldNames) {
            if (otherSchema.getPosition(fieldName) != -1) continue;
            ++totalFields;
        }
        PrimaryKey primaryKey = HollowObjectSchema.isNullableObjectEquals(this.primaryKey, otherSchema.getPrimaryKey()) ? this.primaryKey : null;
        HollowObjectSchema unionSchema = new HollowObjectSchema(this.getName(), totalFields, primaryKey);
        for (i = 0; i < this.fieldNames.length; ++i) {
            unionSchema.addField(this.fieldNames[i], this.fieldTypes[i], this.referencedTypes[i]);
        }
        for (i = 0; i < otherSchema.numFields(); ++i) {
            if (this.getPosition(otherSchema.getFieldName(i)) != -1) continue;
            unionSchema.addField(otherSchema.getFieldName(i), otherSchema.getFieldType(i), otherSchema.getReferencedType(i));
        }
        return unionSchema;
    }

    public HollowObjectSchema filterSchema(HollowFilterConfig config) {
        return this.filterSchema((TypeFilter)config);
    }

    public HollowObjectSchema filterSchema(TypeFilter filter) {
        String type = this.getName();
        int includedFields = 0;
        for (int i = 0; i < this.numFields(); ++i) {
            String field = this.getFieldName(i);
            if (!filter.includes(type, field)) continue;
            ++includedFields;
        }
        HollowObjectSchema filteredSchema = new HollowObjectSchema(this.getName(), includedFields, this.primaryKey);
        for (int i = 0; i < this.numFields(); ++i) {
            String field = this.getFieldName(i);
            if (!filter.includes(type, field)) continue;
            filteredSchema.addField(field, this.getFieldType(i), this.getReferencedType(i));
        }
        return filteredSchema;
    }

    private boolean referencedTypesEqual(String type1, String type2) {
        if (type1 == null) {
            return type2 == null;
        }
        return type1.equals(type2);
    }

    @Override
    public HollowSchema.SchemaType getSchemaType() {
        return HollowSchema.SchemaType.OBJECT;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HollowObjectSchema)) {
            return false;
        }
        HollowObjectSchema otherSchema = (HollowObjectSchema)other;
        if (!this.getName().equals(otherSchema.getName())) {
            return false;
        }
        if (otherSchema.numFields() != this.numFields()) {
            return false;
        }
        if (!HollowObjectSchema.isNullableObjectEquals(this.primaryKey, otherSchema.getPrimaryKey())) {
            return false;
        }
        for (int i = 0; i < this.numFields(); ++i) {
            if (this.getFieldType(i) != otherSchema.getFieldType(i)) {
                return false;
            }
            if (this.getFieldType(i) == FieldType.REFERENCE && !this.getReferencedType(i).equals(otherSchema.getReferencedType(i))) {
                return false;
            }
            if (this.getFieldName(i).equals(otherSchema.getFieldName(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getSchemaType().hashCode();
        result = 31 * result + Objects.hash(this.primaryKey);
        result = 31 * result + Arrays.hashCode(this.fieldNames);
        result = 31 * result + Arrays.hashCode((Object[])this.fieldTypes);
        return result;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        if (this.primaryKey != null) {
            builder.append(" @PrimaryKey(");
            if (this.primaryKey.numFields() > 0) {
                builder.append(this.primaryKey.getFieldPath(0));
                for (i = 1; i < this.primaryKey.numFields(); ++i) {
                    builder.append(", ").append(this.primaryKey.getFieldPath(i));
                }
            }
            builder.append(")");
        }
        builder.append(" {\n");
        for (i = 0; i < this.numFields(); ++i) {
            builder.append("\t");
            if (this.getFieldType(i) == FieldType.REFERENCE) {
                builder.append(this.getReferencedType(i));
            } else {
                builder.append(this.getFieldType(i).toString().toLowerCase());
            }
            builder.append(" ").append(this.getFieldName(i)).append(";\n");
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        int i;
        DataOutputStream dos = new DataOutputStream(os);
        if (this.primaryKey != null) {
            dos.write(HollowSchema.SchemaType.OBJECT.getTypeIdWithPrimaryKey());
        } else {
            dos.write(HollowSchema.SchemaType.OBJECT.getTypeId());
        }
        dos.writeUTF(this.getName());
        if (this.primaryKey != null) {
            VarInt.writeVInt(dos, this.primaryKey.numFields());
            for (i = 0; i < this.primaryKey.numFields(); ++i) {
                dos.writeUTF(this.primaryKey.getFieldPath(i));
            }
        }
        dos.writeShort(this.size);
        for (i = 0; i < this.size; ++i) {
            dos.writeUTF(this.fieldNames[i]);
            dos.writeUTF(this.fieldTypes[i].name());
            if (this.fieldTypes[i] != FieldType.REFERENCE) continue;
            dos.writeUTF(this.referencedTypes[i]);
        }
    }

    public static enum FieldType {
        REFERENCE(-1, false),
        INT(-1, false),
        LONG(-1, false),
        BOOLEAN(1, false),
        FLOAT(4, false),
        DOUBLE(8, false),
        STRING(-1, true),
        BYTES(-1, true);

        private final int fixedLength;
        private final boolean varIntEncodesLength;

        private FieldType(int fixedLength, boolean varIntEncodesLength) {
            this.fixedLength = fixedLength;
            this.varIntEncodesLength = varIntEncodesLength;
        }

        public int getFixedLength() {
            return this.fixedLength;
        }

        public boolean isVariableLength() {
            return this.varIntEncodesLength;
        }
    }
}

