/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowSchema;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class HollowMapSchema
extends HollowSchema {
    private final String keyType;
    private final String valueType;
    private final PrimaryKey hashKey;
    private HollowTypeReadState keyTypeState;
    private HollowTypeReadState valueTypeState;

    public HollowMapSchema(String schemaName, String keyType, String valueType, String ... hashKeyFieldPaths) {
        super(schemaName);
        this.keyType = keyType;
        this.valueType = valueType;
        this.hashKey = hashKeyFieldPaths == null || hashKeyFieldPaths.length == 0 ? null : new PrimaryKey(keyType, hashKeyFieldPaths);
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public PrimaryKey getHashKey() {
        return this.hashKey;
    }

    public HollowTypeReadState getKeyTypeState() {
        return this.keyTypeState;
    }

    public void setKeyTypeState(HollowTypeReadState keyTypeState) {
        this.keyTypeState = keyTypeState;
    }

    public HollowTypeReadState getValueTypeState() {
        return this.valueTypeState;
    }

    public void setValueTypeState(HollowTypeReadState valueTypeState) {
        this.valueTypeState = valueTypeState;
    }

    @Override
    public HollowSchema.SchemaType getSchemaType() {
        return HollowSchema.SchemaType.MAP;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HollowMapSchema)) {
            return false;
        }
        HollowMapSchema otherSchema = (HollowMapSchema)other;
        if (!this.getName().equals(otherSchema.getName())) {
            return false;
        }
        if (!this.getKeyType().equals(otherSchema.getKeyType())) {
            return false;
        }
        if (!this.getValueType().equals(otherSchema.getValueType())) {
            return false;
        }
        return HollowMapSchema.isNullableObjectEquals(this.hashKey, otherSchema.getHashKey());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getSchemaType().hashCode();
        result = 31 * result + this.keyType.hashCode();
        result = 31 * result + this.valueType.hashCode();
        result = 31 * result + Objects.hashCode(this.hashKey);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getName());
        builder.append(" Map<").append(this.getKeyType()).append(",").append(this.getValueType()).append(">");
        if (this.hashKey != null) {
            builder.append(" @HashKey(");
            if (this.hashKey.numFields() > 0) {
                builder.append(this.hashKey.getFieldPath(0));
                for (int i = 1; i < this.hashKey.numFields(); ++i) {
                    builder.append(", ").append(this.hashKey.getFieldPath(i));
                }
            }
            builder.append(")");
        }
        builder.append(";");
        return builder.toString();
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        if (this.getHashKey() != null) {
            dos.write(HollowSchema.SchemaType.MAP.getTypeIdWithPrimaryKey());
        } else {
            dos.write(HollowSchema.SchemaType.MAP.getTypeId());
        }
        dos.writeUTF(this.getName());
        dos.writeUTF(this.getKeyType());
        dos.writeUTF(this.getValueType());
        if (this.getHashKey() != null) {
            VarInt.writeVInt(dos, this.getHashKey().numFields());
            for (int i = 0; i < this.getHashKey().numFields(); ++i) {
                dos.writeUTF(this.getHashKey().getFieldPath(i));
            }
        }
    }
}

