/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.filter;

import com.netflix.hollow.Internal;
import com.netflix.hollow.core.read.filter.TypeFilter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
class TypeActions {
    private static final String ALL = new String("*");
    private final String type;
    private final Map<String, TypeFilter.Builder.Action> actions;

    static TypeActions newTypeActions(String type, TypeFilter.Builder.Action action) {
        return new TypeActions(type, Collections.singletonMap(ALL, action));
    }

    static TypeActions newTypeActions(String type, String field, TypeFilter.Builder.Action action) {
        return new TypeActions(type, Collections.singletonMap(field, action));
    }

    String type() {
        return this.type;
    }

    private TypeActions(String type, Map<String, TypeFilter.Builder.Action> actions) {
        this.type = type;
        this.actions = actions;
    }

    Map<String, TypeFilter.Builder.Action> actions() {
        return this.actions;
    }

    TypeFilter.Builder.Action action() {
        return this.actions.getOrDefault(ALL, TypeFilter.Builder.Action.next);
    }

    TypeFilter.Builder.Action action(String field) {
        return this.actions.getOrDefault(field, TypeFilter.Builder.Action.next);
    }

    TypeActions merge(TypeActions other) {
        LinkedHashMap<String, TypeFilter.Builder.Action> m = new LinkedHashMap<String, TypeFilter.Builder.Action>();
        m.putAll(this.actions);
        m.putAll(other.actions);
        TypeFilter.Builder.Action all = (TypeFilter.Builder.Action)((Object)m.get(ALL));
        m = m.entrySet().stream().filter(entry -> entry.getKey() == ALL || entry.getValue() != all).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new TypeActions(this.type, m);
    }

    public String toString() {
        return this.type + this.actions;
    }
}

